"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getReactiveVariableSpans = getReactiveVariableSpans;
function getReactiveVariableSpans(ts, program, sourceScript, fileName, isTsPlugin) {
    const sourceFile = program.getSourceFile(fileName);
    if (!sourceFile) {
        return [];
    }
    const checker = program.getTypeChecker();
    const minusOffset = isTsPlugin ? sourceScript.snapshot.getLength() : 0;
    const variableSpans = [];
    ts.forEachChild(sourceFile, function visit(node) {
        if (ts.isIdentifier(node)) {
            const symbol = checker.getSymbolAtLocation(node);
            if (symbol) {
                const type = checker.getTypeOfSymbol(symbol);
                const properties = type.getProperties();
                if (properties.some(prop => prop.getName().startsWith('__@RefSymbol@'))) {
                    variableSpans.push({
                        start: node.getStart(sourceFile) - minusOffset,
                        length: node.getWidth(),
                    });
                }
            }
        }
        ts.forEachChild(node, visit);
    });
    return variableSpans;
}
//# sourceMappingURL=getReactiveVariableSpans.js.map