"use strict";
/// <reference types="@volar/typescript" />
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPropertiesAtLocation = getPropertiesAtLocation;
const language_core_1 = require("@vue/language-core");
function getPropertiesAtLocation(fileName, position) {
    const { languageService, language, typescript: ts } = this;
    // mapping
    const sourceScript = language.scripts.get(fileName);
    const root = sourceScript?.generated?.root;
    if (!sourceScript?.generated || !(root instanceof language_core_1.VueVirtualCode)) {
        return [];
    }
    const virtualScript = sourceScript.generated.languagePlugin.typescript?.getServiceScript(root);
    if (!virtualScript) {
        return [];
    }
    let mapped = false;
    for (const [_sourceScript, map] of language.maps.forEach(virtualScript.code)) {
        for (const [position2, mapping] of map.toGeneratedLocation(position)) {
            if ((0, language_core_1.isCompletionEnabled)(mapping.data)) {
                position = position2;
                mapped = true;
                break;
            }
        }
        if (mapped) {
            break;
        }
    }
    if (!mapped) {
        return [];
    }
    position += sourceScript.snapshot.getLength();
    const program = languageService.getProgram();
    const sourceFile = program.getSourceFile(fileName);
    if (!sourceFile) {
        return [];
    }
    const node = findPositionIdentifier(sourceFile, sourceFile, position);
    if (!node) {
        return [];
    }
    const checker = program.getTypeChecker();
    const type = checker.getTypeAtLocation(node);
    const props = type.getProperties();
    return props.map(prop => prop.name);
    function findPositionIdentifier(sourceFile, node, offset) {
        let result;
        node.forEachChild(child => {
            if (!result) {
                if (child.end === offset && ts.isIdentifier(child)) {
                    result = child;
                }
                else if (child.end >= offset && child.getStart(sourceFile) < offset) {
                    result = findPositionIdentifier(sourceFile, child, offset);
                }
            }
        });
        return result;
    }
}
//# sourceMappingURL=getPropertiesAtLocation.js.map