/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.nio.ByteBuffer;
import org.bson.AbstractBsonReader;
import org.bson.BsonBinaryReader;
import org.bson.BsonSerializationException;
import org.bson.io.BsonInput;

public class EnhancedBsonBinaryReader
extends BsonBinaryReader {
    public EnhancedBsonBinaryReader(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public EnhancedBsonBinaryReader(BsonInput bsonInput) {
        super(bsonInput);
    }

    public byte[] getDocumentAsBytes() {
        this.setState(AbstractBsonReader.State.TYPE);
        int size = this.readSize();
        byte[] data = new byte[size];
        this.writeSize(data, size);
        this.getBsonInput().readBytes(data, 4, size - 4);
        return data;
    }

    private int readSize() {
        int size = this.getBsonInput().readInt32();
        if (size < 0) {
            String message = String.format("Size %s is not valid because it is negative.", size);
            throw new BsonSerializationException(message);
        }
        return size;
    }

    private void writeSize(byte[] byteArray, int size) {
        byteArray[0] = (byte)(size >> 0);
        byteArray[1] = (byte)(size >> 8);
        byteArray[2] = (byte)(size >> 16);
        byteArray[3] = (byte)(size >> 24);
    }
}

