/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import picocli.CommandLine;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.commandline.state.BaseStateHolder;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.utility.EnumUtility;

@CommandLine.Command(name="limit", header={"** Limit database object metadata"}, description={"", "When you limit database object metadata, it reduces SchemaCrawler's visibility into other database objects.", "From SchemaCrawler's perspective, the other database objects do not exist.", ""}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"limit"}, optionListHeading="Options:%n")
public final class LimitCommand
extends BaseStateHolder
implements Runnable {
    @CommandLine.Option(names={"--exclude-columns"}, description={"<excludecolumns> is a regular expression to match fully qualified column names, in the form \"CATALOGNAME.SCHEMANAME.TABLENAME.COLUMNNAME\" - for example, --exclude-columns=.*\\.STREET|.*\\.PRICE matches columns named STREET or PRICE in any table", "Columns that match the pattern are not displayed", "Optional, default is to show all columns"})
    private Pattern excludecolumns;
    @CommandLine.Option(names={"--exclude-parameters"}, description={"<excludeparameters> is a regular expression to match fully qualified parameter names - for example, --exclude-parameters=@p1|@p2 matches parameters named @p1 or @p2 in any procedure", "Parameters that match the pattern are not displayed", "Optional, default is to show all parameters"})
    private Pattern excludeparameters;
    @CommandLine.Option(names={"--routines"}, description={"<routines> is a regular expression to match fully qualified stored procedure or function names, in the form \"CATALOGNAME.SCHEMANAME.ROUTINENAME\" - for example, --routines=.*\\.C.*|.*\\.P.* matches any routines whose names start with C or P", "Routines that do not match the pattern are not displayed", "Use --routines= to omit routines", "Optional, defaults to showing no routines"})
    private Pattern routines;
    @CommandLine.Option(names={"--routine-types"}, split=",", description={"<routinetypes> is a comma-separated list of routine types of PROCEDURE,FUNCTION", "Optional, defaults to PROCEDURE,FUNCTION"})
    private String[] routinetypes;
    @CommandLine.Option(names={"--schemas"}, description={"<schemas> is a regular expression to match fully qualified schema names, in the form \"CATALOGNAME.SCHEMANAME\" - for example, --schemas=.*\\.C.*|.*\\.P.* matches any schemas whose names start with C or P", "Schemas that do not match the pattern are not displayed", "Optional, defaults to showing all schemas"})
    private Pattern schemas;
    @CommandLine.Option(names={"--sequences"}, description={"<sequences> is a regular expression to match fully qualified sequence names, in the form \"CATALOGNAME.SCHEMANAME.SEQUENCENAME\" - for example, --sequences=.*\\.C.*|.*\\.P.* matches any sequences whose names start with C or P", "Sequences that do not match the pattern are not displayed", "Use --sequences= to omit sequences", "Sequences will only be shown when -infolevel=maximum", "Optional, defaults to showing no sequences"})
    private Pattern sequences;
    @CommandLine.Option(names={"--synonyms"}, description={"<synonyms> is a regular expression to match fully qualified synonym names, in the form \"CATALOGNAME.SCHEMANAME.SYNONYMNAME\" - for example, --synonyms=.*\\.C.*|.*\\.P.* matches any synonyms whose names start with C or P", "Synonyms that do not match the pattern are not displayed", "Synonyms will only be shown when -infolevel=maximum", "Use --synonyms= to omit synonyms", "Optional, defaults to showing no synonyms"})
    private Pattern synonyms;
    @CommandLine.Option(names={"--tables"}, description={"<regular-expression> is a regular expression to match fully qualified table names, in the form \"CATALOGNAME.SCHEMANAME.TABLENAME\" - for example, --tables=.*\\.C.*|.*\\.P.* matches any tables whose names start with C or P", "Tables that do not match the pattern are not displayed", "Use with care, since --tables= actually takes tables out of consideration from the perspective of SchemaCrawler - to filter tables, look into the grep options", "Optional, defaults to showing all tables"})
    private Pattern tables;
    @CommandLine.Option(names={"--table-types"}, split=",", description={"<tabletypes> is a comma-separated list of table types supported by the database", "If no value is specified, all types of tables are shown", "Optional, defaults to TABLE,VIEW"})
    private String[] tabletypes;

    public LimitCommand(ShellState state) {
        super(state);
    }

    @Override
    public void run() {
        SchemaCrawlerOptions schemaCrawlerOptions = this.state.getSchemaCrawlerOptions();
        LimitOptionsBuilder optionsBuilder = LimitOptionsBuilder.builder().fromOptions(schemaCrawlerOptions.getLimitOptions());
        if (this.schemas != null) {
            optionsBuilder.includeSchemas(this.schemas);
        }
        if (this.tables != null) {
            optionsBuilder.includeTables(this.tables);
        }
        if (this.excludecolumns != null) {
            optionsBuilder.includeColumns((InclusionRule)new RegularExpressionExclusionRule(this.excludecolumns));
        }
        if (this.routines != null) {
            optionsBuilder.includeRoutines(this.routines);
        }
        if (this.excludeparameters != null) {
            optionsBuilder.includeRoutineParameters((InclusionRule)new RegularExpressionExclusionRule(this.excludeparameters));
        }
        if (this.synonyms != null) {
            optionsBuilder.includeSynonyms(this.synonyms);
        }
        if (this.sequences != null) {
            optionsBuilder.includeSequences(this.sequences);
        }
        if (this.tabletypes != null) {
            optionsBuilder.tableTypes(this.tabletypes);
        }
        if (this.routinetypes != null) {
            optionsBuilder.routineTypes(this.routineTypes());
        }
        this.state.withLimitOptions(optionsBuilder.toOptions());
    }

    private Collection<RoutineType> routineTypes() {
        if (this.routinetypes == null) {
            return null;
        }
        HashSet<RoutineType> routineTypesCollection = new HashSet<RoutineType>();
        for (String routineTypeString : this.routinetypes) {
            RoutineType routineType = (RoutineType)EnumUtility.enumValue((String)routineTypeString.toLowerCase(Locale.ENGLISH), (Enum)RoutineType.unknown);
            routineTypesCollection.add(routineType);
        }
        return routineTypesCollection;
    }
}

