/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oci.OracleOCIConnection;
import oracle.jdbc.pool.OracleDataSource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
public class OracleOCIConnectionPool
extends OracleDataSource {
    public OracleOCIConnection m_connection_pool;
    public static final String IS_CONNECTION_POOLING = "is_connection_pooling";
    private int m_conn_min_limit;
    private int m_conn_max_limit;
    private int m_conn_increment;
    private int m_conn_active_size;
    private int m_conn_pool_size;
    private int m_conn_timeout;
    private String m_conn_nowait;
    private int m_is_transactions_distributed;
    public static final String CONNPOOL_OBJECT = "connpool_object";
    public static final String CONNPOOL_LOGON_MODE = "connection_pool";
    public static final String CONNECTION_POOL = "connection_pool";
    public static final String CONNPOOL_CONNECTION = "connpool_connection";
    public static final String CONNPOOL_PROXY_CONNECTION = "connpool_proxy_connection";
    public static final String CONNPOOL_ALIASED_CONNECTION = "connpool_alias_connection";
    public static final String PROXY_USER_NAME = "proxy_user_name";
    public static final String PROXY_DISTINGUISHED_NAME = "proxy_distinguished_name";
    public static final String PROXY_CERTIFICATE = "proxy_certificate";
    public static final String PROXY_ROLES = "proxy_roles";
    public static final String PROXY_NUM_ROLES = "proxy_num_roles";
    public static final String PROXY_PASSWORD = "proxy_password";
    public static final String PROXYTYPE = "proxytype";
    public static final String PROXYTYPE_USER_NAME = "proxytype_user_name";
    public static final String PROXYTYPE_DISTINGUISHED_NAME = "proxytype_distinguished_name";
    public static final String PROXYTYPE_CERTIFICATE = "proxytype_certificate";
    public static final String CONNECTION_ID = "connection_id";
    public static final String CONNPOOL_MIN_LIMIT = "connpool_min_limit";
    public static final String CONNPOOL_MAX_LIMIT = "connpool_max_limit";
    public static final String CONNPOOL_INCREMENT = "connpool_increment";
    public static final String CONNPOOL_ACTIVE_SIZE = "connpool_active_size";
    public static final String CONNPOOL_POOL_SIZE = "connpool_pool_size";
    public static final String CONNPOOL_TIMEOUT = "connpool_timeout";
    public static final String CONNPOOL_NOWAIT = "connpool_nowait";
    public static final String CONNPOOL_IS_POOLCREATED = "connpool_is_poolcreated";
    public static final String TRANSACTIONS_DISTRIBUTED = "transactions_distributed";
    private Hashtable m_lconnections;
    private Lifecycle lifecycle;
    private OracleDriver m_oracleDriver;
    protected int m_stmtCacheSize;
    protected boolean m_stmtClearMetaData;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    private void ensureOpen() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.lifecycle == Lifecycle.NEW) {
                this.createConnectionPool(null);
            }
            if (this.lifecycle != Lifecycle.OPEN) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(8).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public OracleOCIConnectionPool(String us, @Blind String p2, String url, @Blind(value=PropertiesBlinder.class) Properties info) throws SQLException {
        this();
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$29, null, us, "*****", url, TraceControllerImpl.blind(PropertiesBlinder.class, info));
            }
            this.setURL(url);
            this.setUser(us);
            this.setPassword(p2);
            this.createConnectionPool(info);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$29, null);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$29, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$29, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleOCIConnectionPool(String us, @Blind String p2, String url) throws SQLException {
        this();
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$30, null, us, "*****", url);
            }
            this.setURL(url);
            this.setUser(us);
            this.setPassword(p2);
            this.createConnectionPool(null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$30, null);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$30, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$30, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleOCIConnectionPool() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$31, null, new Object[0]);
            }
            this.m_conn_min_limit = 0;
            this.m_conn_max_limit = 0;
            this.m_conn_increment = 0;
            this.m_conn_active_size = 0;
            this.m_conn_pool_size = 0;
            this.m_conn_timeout = 0;
            this.m_conn_nowait = "false";
            this.m_is_transactions_distributed = 0;
            this.m_lconnections = null;
            this.lifecycle = Lifecycle.NEW;
            this.m_oracleDriver = new OracleDriver();
            this.m_stmtCacheSize = 0;
            this.m_stmtClearMetaData = false;
            this.isOracleDataSource = false;
            this.m_lconnections = new Hashtable(10);
            this.setDriverType("oci8");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$31, null);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$31, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection getConnection() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection connection;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$1, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        Connection conn;
                        this.ensureOpen();
                        connection = conn = this.getConnection(this.user, this.password != null ? this.password.get() : null);
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$1, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$1, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            Connection connection2 = connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$1, this, connection2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$1, this, null);
            }
            return connection2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$1, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection getConnection(String string, @Blind String string2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleOCIConnection oracleOCIConnection;
            block20: {
                Monitor.CloseableLock lock;
                block21: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$2, this, string, "*****");
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void p2;
                        void us;
                        this.ensureOpen();
                        Properties info = this.connectionProperties != null ? new Properties(this.connectionProperties) : new Properties();
                        info.put(IS_CONNECTION_POOLING, "true");
                        info.put("user", (Object)us);
                        info.put("password", (Object)p2);
                        info.put("connection_pool", CONNPOOL_CONNECTION);
                        info.put(CONNPOOL_OBJECT, this.m_connection_pool);
                        OracleOCIConnection conn = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, info);
                        if (conn == null) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$2, this, sQLException);
                            }
                            throw sQLException;
                        }
                        conn.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
                        this.m_lconnections.put(conn, conn);
                        conn.setConnectionPool(this);
                        oracleOCIConnection = conn;
                        if (lock == null) break block20;
                        if (throwable == null) break block21;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$2, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$2, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                lock.close();
            }
            OracleOCIConnection oracleOCIConnection2 = oracleOCIConnection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$2, this, oracleOCIConnection2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$2, this, null);
            }
            return oracleOCIConnection2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$2, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Reference getReference() throws NamingException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            Reference reference;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$3, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        Reference ref = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
                        super.addRefProperties(ref);
                        ref.add(new StringRefAddr(CONNPOOL_MIN_LIMIT, String.valueOf(this.m_conn_min_limit)));
                        ref.add(new StringRefAddr(CONNPOOL_MAX_LIMIT, String.valueOf(this.m_conn_max_limit)));
                        ref.add(new StringRefAddr(CONNPOOL_INCREMENT, String.valueOf(this.m_conn_increment)));
                        ref.add(new StringRefAddr(CONNPOOL_ACTIVE_SIZE, String.valueOf(this.m_conn_active_size)));
                        ref.add(new StringRefAddr(CONNPOOL_POOL_SIZE, String.valueOf(this.m_conn_pool_size)));
                        ref.add(new StringRefAddr(CONNPOOL_TIMEOUT, String.valueOf(this.m_conn_timeout)));
                        ref.add(new StringRefAddr(CONNPOOL_NOWAIT, this.m_conn_nowait));
                        ref.add(new StringRefAddr(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated())));
                        ref.add(new StringRefAddr(TRANSACTIONS_DISTRIBUTED, String.valueOf(this.isDistributedTransEnabled())));
                        reference = ref;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$3, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$3, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            Reference reference2 = reference;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$3, this, reference2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$3, this, null);
            }
            return reference2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$3, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleConnection getProxyConnection(String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleOCIConnection oracleOCIConnection;
            block29: {
                Monitor.CloseableLock lock;
                block30: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$4, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void prop;
                        void proxytype;
                        this.ensureOpen();
                        if (PROXYTYPE_USER_NAME.equals(proxytype)) {
                            prop.put("user", prop.getProperty(PROXY_USER_NAME));
                        } else if (PROXYTYPE_DISTINGUISHED_NAME.equals(proxytype)) {
                            prop.put("user", prop.getProperty(PROXY_DISTINGUISHED_NAME));
                        } else if (PROXYTYPE_CERTIFICATE.equals(proxytype)) {
                            prop.put("user", String.valueOf(prop.getProperty(PROXY_USER_NAME)));
                        } else {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(107, "null properties").fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$4, this, sQLException);
                            }
                            throw sQLException;
                        }
                        prop.put(IS_CONNECTION_POOLING, "true");
                        prop.put(PROXYTYPE, (Object)proxytype);
                        String[] proxyRoles = (String[])prop.get(PROXY_ROLES);
                        if (proxyRoles != null) {
                            prop.put(PROXY_NUM_ROLES, new Integer(proxyRoles.length));
                        } else {
                            prop.put(PROXY_NUM_ROLES, new Integer(0));
                        }
                        prop.put("connection_pool", CONNPOOL_PROXY_CONNECTION);
                        prop.put(CONNPOOL_OBJECT, this.m_connection_pool);
                        OracleOCIConnection conn = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, (Properties)prop);
                        if (conn == null) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$4, this, sQLException);
                            }
                            throw sQLException;
                        }
                        conn.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
                        this.m_lconnections.put(conn, conn);
                        conn.setConnectionPool(this);
                        oracleOCIConnection = conn;
                        if (lock == null) break block29;
                        if (throwable == null) break block30;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$4, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$4, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block29;
                }
                lock.close();
            }
            OracleOCIConnection oracleOCIConnection2 = oracleOCIConnection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$4, this, oracleOCIConnection2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$4, this, null);
            }
            return oracleOCIConnection2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$4, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleConnection getAliasedConnection(byte[] byArray) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleOCIConnection oracleOCIConnection;
            block21: {
                Monitor.CloseableLock lock;
                block22: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$5, this, new Object[]{byArray});
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void conId;
                        if (bl) {
                            this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "OracleOCIConnectionPool.getAliasedConnection(" + OracleLog.bytesToPrintableForm("conId[]=", (byte[])conId) + ")");
                        }
                        this.ensureOpen();
                        Properties info = new Properties();
                        info.put(IS_CONNECTION_POOLING, "true");
                        info.put(CONNECTION_ID, (Object)conId);
                        info.put("connection_pool", CONNPOOL_ALIASED_CONNECTION);
                        info.put(CONNPOOL_OBJECT, this.m_connection_pool);
                        OracleOCIConnection conn = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, info);
                        if (conn == null) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$5, this, sQLException);
                            }
                            throw sQLException;
                        }
                        conn.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
                        this.m_lconnections.put(conn, conn);
                        conn.setConnectionPool(this);
                        oracleOCIConnection = conn;
                        if (lock == null) break block21;
                        if (throwable == null) break block22;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$5, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$5, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                lock.close();
            }
            OracleOCIConnection oracleOCIConnection2 = oracleOCIConnection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$5, this, oracleOCIConnection2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$5, this, null);
            }
            return oracleOCIConnection2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$5, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public void close() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block27: {
                Throwable throwable;
                Monitor.CloseableLock lock;
                block28: {
                    block24: {
                        block25: {
                            block26: {
                                if (bl) {
                                    ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$6, this, new Object[0]);
                                }
                                lock = this.acquireCloseableLock();
                                throwable = null;
                                if (this.lifecycle == Lifecycle.OPEN) break block24;
                                if (lock == null) break block25;
                                if (throwable == null) break block26;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block25;
                            }
                            lock.close();
                        }
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$6, this);
                            ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$6, this, null);
                        }
                        return;
                    }
                    this.lifecycle = Lifecycle.CLOSING;
                    Iterator iter = this.m_lconnections.values().iterator();
                    while (iter.hasNext()) {
                        OracleOCIConnection conn = (OracleOCIConnection)iter.next();
                        if (conn != null && conn != this.m_connection_pool) {
                            conn.close();
                        }
                        iter.remove();
                    }
                    this.m_connection_pool.close();
                    this.lifecycle = Lifecycle.CLOSED;
                    if (lock == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block27;
                }
                lock.close();
                break block27;
                catch (Throwable throwable4) {
                    try {
                        throwable = throwable4;
                        Throwable throwable5 = throwable4;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$6, this, throwable5);
                        }
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (lock != null) {
                            if (throwable != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        Throwable throwable8 = throwable6;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$6, this, throwable8);
                        }
                        throw throwable8;
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable9 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$6, this, throwable9);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPoolConfig(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block22: {
                Monitor.CloseableLock lock;
                block23: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$7, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void prop;
                        if (prop == null) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(106, "null properties").fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$7, this, sQLException);
                            }
                            throw sQLException;
                        }
                        if (!this.isPoolCreated()) {
                            this.createConnectionPool((Properties)prop);
                        } else {
                            Properties info = new Properties();
                            this.checkPoolConfig((Properties)prop, info);
                            int[] p2 = new int[6];
                            OracleOCIConnectionPool.readPoolConfig(info, p2);
                            this.m_connection_pool.setConnectionPoolInfo(p2[0], p2[1], p2[2], p2[3], p2[4], p2[5]);
                        }
                        this.storePoolProperties();
                        if (lock == null) break block22;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$7, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$7, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block22;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$7, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void readPoolConfig(int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int[] nArray) {
        boolean bl3 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void transactionsDistributed;
            void nowait;
            void timeout;
            void increment;
            void maxLimit;
            int minLimit;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$8, null, n2, n3, n4, n5, bl, bl2, nArray);
            }
            for (int i2 = 0; i2 < 6; ++i2) {
                p[i2] = false;
            }
            p[0] = minLimit;
            p[1] = maxLimit;
            p[2] = increment;
            p[3] = timeout;
            if (nowait != false) {
                p[4] = true;
            }
            if (transactionsDistributed != false) {
                p[5] = true;
            }
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    public static void readPoolConfig(@Blind(value=PropertiesBlinder.class) Properties properties, int[] nArray) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            Properties info;
            String value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$9, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties), nArray);
            }
            if ((value = info.getProperty(CONNPOOL_MIN_LIMIT)) != null) {
                p[0] = Integer.parseInt(value);
            }
            if ((value = info.getProperty(CONNPOOL_MAX_LIMIT)) != null) {
                p[1] = Integer.parseInt(value);
            }
            if ((value = info.getProperty(CONNPOOL_INCREMENT)) != null) {
                p[2] = Integer.parseInt(value);
            }
            if ((value = info.getProperty(CONNPOOL_TIMEOUT)) != null) {
                p[3] = Integer.parseInt(value);
            }
            if ((value = info.getProperty(CONNPOOL_NOWAIT)) != null && value.equalsIgnoreCase("true")) {
                p[4] = true;
            }
            if ((value = info.getProperty(TRANSACTIONS_DISTRIBUTED)) != null && value.equalsIgnoreCase("true")) {
                p[5] = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$9, null);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$9, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkPoolConfig(@Blind(value=PropertiesBlinder.class) Properties properties, @Blind(value=PropertiesBlinder.class) Properties properties2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pc_in;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$10, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), TraceControllerImpl.blind(PropertiesBlinder.class, properties2));
            }
            String dist_txn = (String)pc_in.get(TRANSACTIONS_DISTRIBUTED);
            String conn_nowait = (String)pc_in.get(CONNPOOL_NOWAIT);
            if (dist_txn != null && !dist_txn.equalsIgnoreCase("true") || conn_nowait != null && !conn_nowait.equalsIgnoreCase("true") || pc_in.get(CONNPOOL_MIN_LIMIT) == null || pc_in.get(CONNPOOL_MAX_LIMIT) == null || pc_in.get(CONNPOOL_INCREMENT) == null || Integer.decode((String)pc_in.get(CONNPOOL_MIN_LIMIT)) < 0 || Integer.decode((String)pc_in.get(CONNPOOL_MAX_LIMIT)) < 0 || Integer.decode((String)pc_in.get(CONNPOOL_INCREMENT)) < 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(106, "").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$10, this, sQLException);
                }
                throw sQLException;
            }
            Enumeration<?> e2 = pc_in.propertyNames();
            while (e2.hasMoreElements()) {
                void pc_out;
                String key = (String)e2.nextElement();
                String value = pc_in.getProperty(key);
                if (TRANSACTIONS_DISTRIBUTED.equals(key) || CONNPOOL_NOWAIT.equals(key)) {
                    pc_out.put(key, "true");
                    continue;
                }
                pc_out.put(key, value);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storePoolProperties() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$11, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        Properties info = this.getPoolConfig();
                        this.m_conn_min_limit = Integer.decode(info.getProperty(CONNPOOL_MIN_LIMIT));
                        this.m_conn_max_limit = Integer.decode(info.getProperty(CONNPOOL_MAX_LIMIT));
                        this.m_conn_increment = Integer.decode(info.getProperty(CONNPOOL_INCREMENT));
                        this.m_conn_active_size = Integer.decode(info.getProperty(CONNPOOL_ACTIVE_SIZE));
                        this.m_conn_pool_size = Integer.decode(info.getProperty(CONNPOOL_POOL_SIZE));
                        this.m_conn_timeout = Integer.decode(info.getProperty(CONNPOOL_TIMEOUT));
                        this.m_conn_nowait = info.getProperty(CONNPOOL_NOWAIT);
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$11, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$11, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$11, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Blind(value=PropertiesBlinder.class)
    public Properties getPoolConfig() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            Properties properties;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$12, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        this.ensureOpen();
                        Properties info = this.m_connection_pool.getConnectionPoolInfo();
                        info.put(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated()));
                        properties = info;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$12, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$12, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            Properties properties2 = properties;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$12, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties2));
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$12, this, null);
            }
            return properties2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$12, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getActiveSize() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$13, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        int res;
                        this.ensureOpen();
                        Properties info = this.m_connection_pool.getConnectionPoolInfo();
                        String value = info.getProperty(CONNPOOL_ACTIVE_SIZE);
                        n2 = res = Integer.decode(value).intValue();
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$13, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$13, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$13, this, n3);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$13, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$13, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPoolSize() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$14, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        int res;
                        this.ensureOpen();
                        Properties info = this.m_connection_pool.getConnectionPoolInfo();
                        String value = info.getProperty(CONNPOOL_POOL_SIZE);
                        n2 = res = Integer.decode(value).intValue();
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$14, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$14, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$14, this, n3);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$14, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$14, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTimeout() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$15, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        int res;
                        this.ensureOpen();
                        Properties info = this.m_connection_pool.getConnectionPoolInfo();
                        String value = info.getProperty(CONNPOOL_TIMEOUT);
                        n2 = res = Integer.decode(value).intValue();
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$15, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$15, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$15, this, n3);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$15, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$15, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNoWait() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$16, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        this.ensureOpen();
                        Properties info = this.m_connection_pool.getConnectionPoolInfo();
                        string = info.getProperty(CONNPOOL_NOWAIT);
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$16, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$16, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            String string2 = string;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$16, this, string2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$16, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$16, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMinLimit() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$17, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        int res;
                        this.ensureOpen();
                        Properties info = this.m_connection_pool.getConnectionPoolInfo();
                        String value = info.getProperty(CONNPOOL_MIN_LIMIT);
                        n2 = res = Integer.decode(value).intValue();
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$17, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$17, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$17, this, n3);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$17, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$17, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMaxLimit() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$18, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        int res;
                        this.ensureOpen();
                        Properties info = this.m_connection_pool.getConnectionPoolInfo();
                        String value = info.getProperty(CONNPOOL_MAX_LIMIT);
                        n2 = res = Integer.decode(value).intValue();
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$18, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$18, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$18, this, n3);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$18, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$18, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getConnectionIncrement() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$19, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        int res;
                        this.ensureOpen();
                        Properties info = this.m_connection_pool.getConnectionPoolInfo();
                        String value = info.getProperty(CONNPOOL_INCREMENT);
                        n2 = res = Integer.decode(value).intValue();
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$19, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$19, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$19, this, n3);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$19, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$19, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public boolean isDistributedTransEnabled() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            Throwable throwable;
            Monitor.CloseableLock lock;
            block25: {
                block26: {
                    block22: {
                        boolean bl3;
                        block23: {
                            block24: {
                                if (bl) {
                                    ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$20, this, new Object[0]);
                                }
                                lock = this.acquireCloseableLock();
                                throwable = null;
                                if (this.m_is_transactions_distributed != 1) break block22;
                                bl3 = true;
                                if (lock == null) break block23;
                                if (throwable == null) break block24;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block23;
                            }
                            lock.close();
                        }
                        boolean bl4 = bl3;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$20, this, bl4);
                            ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$20, this, null);
                        }
                        return bl4;
                    }
                    bl2 = false;
                    if (lock == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                lock.close();
            }
            boolean bl5 = bl2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$20, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$20, this, null);
            }
            return bl5;
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    Throwable throwable5 = throwable4;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$20, this, throwable5);
                    }
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (lock != null) {
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            lock.close();
                        }
                    }
                    Throwable throwable8 = throwable6;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$20, this, throwable8);
                    }
                    throw throwable8;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable9 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$20, this, throwable9);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createConnectionPool(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void poolConfig;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$21, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            if (this.lifecycle != Lifecycle.NEW) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$21, this);
                    ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$21, this, null);
                }
                return;
            }
            if (this.user == null || this.password == null || this.password.isNull()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(106, " ").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$21, this, sQLException);
                }
                throw sQLException;
            }
            Properties info = new Properties();
            if (poolConfig != null) {
                this.checkPoolConfig((Properties)poolConfig, info);
            }
            info.put(IS_CONNECTION_POOLING, "true");
            info.put("user", this.user);
            info.put("password", this.password.get());
            info.put("connection_pool", "connection_pool");
            if (this.getURL() == null) {
                this.makeURL();
            }
            if (bl) {
                this.debug($$$loggerRef$$$21, Level.FINEST, $$$methodRef$$$21, "OracleOCIConnectionPool.createConnectionPool() -  User:" + this.user + "URL:" + this.getURL());
            }
            this.m_connection_pool = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, info);
            if (this.m_connection_pool == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$21, this, sQLException);
                }
                throw sQLException;
            }
            this.m_connection_pool.setConnectionPool(this);
            this.m_lconnections.put(this.m_connection_pool, this.m_connection_pool);
            this.lifecycle = Lifecycle.OPEN;
            this.storePoolProperties();
            if (poolConfig != null && "true".equalsIgnoreCase(poolConfig.getProperty(TRANSACTIONS_DISTRIBUTED))) {
                this.m_is_transactions_distributed = 1;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPoolCreated() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$22, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        boolean bl3 = bl2 = this.lifecycle == Lifecycle.OPEN;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$22, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$22, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            boolean bl4 = bl2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$22, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$22, this, null);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$22, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connectionClosed(OracleOCIConnection oracleOCIConnection) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block20: {
                Monitor.CloseableLock lock;
                block21: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$23, this, oracleOCIConnection);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void conn;
                        if (this.lifecycle != Lifecycle.CLOSING && this.m_lconnections.remove(conn) == null) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "internal OracleOCIConnectionPool error").fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$23, this, sQLException);
                            }
                            throw sQLException;
                        }
                        if (lock == null) break block20;
                        if (throwable == null) break block21;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$23, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$23, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$23, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStmtCacheSize(int n2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$24, this, n2);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void size;
                        this.setStmtCacheSize((int)size, false);
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$24, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$24, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$24, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block20: {
                Monitor.CloseableLock lock;
                block21: {
                    if (bl2) {
                        ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$25, this, n2, bl);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void clearMetaData;
                        void size;
                        if (size < 0) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$25, this, sQLException);
                            }
                            throw sQLException;
                        }
                        this.m_stmtCacheSize = size;
                        this.m_stmtClearMetaData = clearMetaData;
                        if (lock == null) break block20;
                        if (throwable == null) break block21;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$25, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$25, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                lock.close();
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$25, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getStmtCacheSize() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$26, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        n2 = this.m_stmtCacheSize;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$26, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$26, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$26, this, n3);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$26, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$26, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public boolean isStmtCacheEnabled() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            Throwable throwable;
            Monitor.CloseableLock lock;
            block25: {
                block26: {
                    block22: {
                        boolean bl3;
                        block23: {
                            block24: {
                                if (bl) {
                                    ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$27, this, new Object[0]);
                                }
                                lock = this.acquireCloseableLock();
                                throwable = null;
                                if (this.m_stmtCacheSize <= 0) break block22;
                                bl3 = true;
                                if (lock == null) break block23;
                                if (throwable == null) break block24;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block23;
                            }
                            lock.close();
                        }
                        boolean bl4 = bl3;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$27, this, bl4);
                            ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$27, this, null);
                        }
                        return bl4;
                    }
                    bl2 = false;
                    if (lock == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                lock.close();
            }
            boolean bl5 = bl2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$27, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$27, this, null);
            }
            return bl5;
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    Throwable throwable5 = throwable4;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$27, this, throwable5);
                    }
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (lock != null) {
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            lock.close();
                        }
                    }
                    Throwable throwable8 = throwable6;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$27, this, throwable8);
                    }
                    throw throwable8;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable9 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$27, this, throwable9);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$28, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$28, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$28, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleOCIConnectionPool.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$31 = OracleOCIConnectionPool.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleOCIConnectionPool.class.getDeclaredConstructor(String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleOCIConnectionPool.class.getDeclaredConstructor(String.class, String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleOCIConnectionPool.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleOCIConnectionPool.class.getDeclaredMethod("isStmtCacheEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleOCIConnectionPool.class.getDeclaredMethod("getStmtCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleOCIConnectionPool.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleOCIConnectionPool.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleOCIConnectionPool.class.getDeclaredMethod("connectionClosed", OracleOCIConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleOCIConnectionPool.class.getDeclaredMethod("isPoolCreated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleOCIConnectionPool.class.getDeclaredMethod("createConnectionPool", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleOCIConnectionPool.class.getDeclaredMethod("isDistributedTransEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleOCIConnectionPool.class.getDeclaredMethod("getConnectionIncrement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleOCIConnectionPool.class.getDeclaredMethod("getMaxLimit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleOCIConnectionPool.class.getDeclaredMethod("getMinLimit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleOCIConnectionPool.class.getDeclaredMethod("getNoWait", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleOCIConnectionPool.class.getDeclaredMethod("getTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleOCIConnectionPool.class.getDeclaredMethod("getPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleOCIConnectionPool.class.getDeclaredMethod("getActiveSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleOCIConnectionPool.class.getDeclaredMethod("getPoolConfig", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleOCIConnectionPool.class.getDeclaredMethod("storePoolProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleOCIConnectionPool.class.getDeclaredMethod("checkPoolConfig", Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleOCIConnectionPool.class.getDeclaredMethod("readPoolConfig", Properties.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleOCIConnectionPool.class.getDeclaredMethod("readPoolConfig", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleOCIConnectionPool.class.getDeclaredMethod("setPoolConfig", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleOCIConnectionPool.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleOCIConnectionPool.class.getDeclaredMethod("getAliasedConnection", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleOCIConnectionPool.class.getDeclaredMethod("getProxyConnection", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleOCIConnectionPool.class.getDeclaredMethod("getReference", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleOCIConnectionPool.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleOCIConnectionPool.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleOCIConnectionPool.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static final class Lifecycle
    extends Enum<Lifecycle> {
        public static final /* enum */ Lifecycle NEW;
        public static final /* enum */ Lifecycle OPEN;
        public static final /* enum */ Lifecycle CLOSING;
        public static final /* enum */ Lifecycle CLOSED;
        private static final /* synthetic */ Lifecycle[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static Lifecycle[] values() {
            return (Lifecycle[])$VALUES.clone();
        }

        public static Lifecycle valueOf(String name) {
            return Enum.valueOf(Lifecycle.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = Lifecycle.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Lifecycle.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Lifecycle.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            NEW = new Lifecycle();
            OPEN = new Lifecycle();
            CLOSING = new Lifecycle();
            CLOSED = new Lifecycle();
            $VALUES = new Lifecycle[]{NEW, OPEN, CLOSING, CLOSED};
        }
    }
}

