/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.png.PngIOMetadata;
import net.sourceforge.plantuml.png.quant.QuantUtils;
import net.sourceforge.plantuml.png.quant.Quantify555;
import net.sourceforge.plantuml.png.quant.QuantifyPacked28;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.utils.Log;

public class PngIO {
    private static final String copyleft = "Generated by https://plantuml.com";

    public static void write(RenderedImage image, ColorMapper mapper, SFile file, String metadata, int dpi) throws IOException {
        try (BufferedOutputStream os = file.createBufferedOutputStream();){
            PngIO.write(image, mapper, os, metadata, dpi);
        }
        Log.debug(() -> "File is " + file);
        Log.debug(() -> "File size " + file.length());
        if (file.length() == 0L) {
            Log.error("File size is zero: " + file);
            SImageIO.write(image, "png", file);
        }
    }

    public static void write(RenderedImage image, ColorMapper mapper, OutputStream os, String metadata, int dpi) throws IOException {
        BufferedImage bufferedImage = QuantUtils.toBufferedARGBorRGB(image);
        if (bufferedImage != null) {
            int type = bufferedImage.getType();
            assert (type == 2 || type == 1 || type == 5 || type == 6);
            boolean hasAlpha = type == 2 || type == 6;
            Log.info(() -> "Trying to pack image. hasAlpha=" + hasAlpha);
            BufferedImage tmp = null;
            if (!hasAlpha) {
                tmp = Quantify555.packMeIfPossible(bufferedImage);
            }
            if (tmp == null) {
                tmp = QuantifyPacked28.packMeIfPossible(bufferedImage);
            }
            if (tmp != null) {
                image = tmp;
            }
        }
        PngIOMetadata.writeWithMetadata(image, os, metadata, dpi, null, 7);
    }
}

