/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.text.StringLocated;

public class StartUtils {
    public static final Pattern2 patternFilename = Pattern2.cmpile("^[@\\\\]start[^%s{}%g]+[%s{][%s%g]*([^%g]*?)[%s}%g]*$");
    public static final String PAUSE_PATTERN = "((?:\\W|\\<[^<>]*\\>)*)[@\\\\]unpause";
    public static final String START_PATTERN = "((?:[^\\w~]|\\<[^<>]*\\>)*)[@\\\\]start";
    private static final Pattern2 append = Pattern2.cmpile("^\\W*[@\\\\](append|a)\\b");

    public static String beforeStartUml(String s) {
        boolean inside = false;
        for (int i = 0; i < s.length(); ++i) {
            String tmp = s.substring(i, s.length());
            if (StartUtils.startsWithSymbolAnd("start", tmp)) {
                return s.substring(0, i);
            }
            String single = s.substring(i, i + 1);
            if (inside) {
                if (!single.equals(">")) continue;
                inside = false;
                continue;
            }
            if (single.equals("<")) {
                inside = true;
                continue;
            }
            if (!single.matches("[\\w~]")) continue;
            return null;
        }
        return null;
    }

    public static boolean isArobaseStartDiagram(String s) {
        return DiagramType.getTypeFromArobaseStart(s) != DiagramType.UNKNOWN;
    }

    private static boolean startsWithSymbolAnd(String keyword, String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c != '@' && c != '\\') {
                return false;
            }
            if (text.length() - i - 1 < keyword.length()) {
                return false;
            }
            return text.regionMatches(i + 1, keyword, 0, keyword.length());
        }
        return false;
    }

    public static boolean isArobaseEndDiagram(String s) {
        return StartUtils.startsWithSymbolAnd("end", s);
    }

    public static boolean isArobasePauseDiagram(String s) {
        return StartUtils.startsWithSymbolAnd("pause", s);
    }

    public static boolean isArobaseUnpauseDiagram(String s) {
        return StartUtils.startsWithSymbolAnd("unpause", s);
    }

    public static boolean isExit(CharSequence s) {
        int start;
        int len = s.length();
        int end = len - 1;
        for (start = 0; start < len && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        while (end >= start && Character.isWhitespace(s.charAt(end))) {
            --end;
        }
        if (end - start + 1 != 5) {
            return false;
        }
        return s.charAt(start) == '!' && s.charAt(start + 1) == 'e' && s.charAt(start + 2) == 'x' && s.charAt(start + 3) == 'i' && s.charAt(start + 4) == 't';
    }

    public static StringLocated getPossibleAppend(StringLocated cs) {
        String s = cs.getString();
        Matcher2 m = append.matcher(s);
        if (m.find()) {
            String tmp = s.substring(m.group(0).length(), s.length());
            return new StringLocated(StringUtils.trin(tmp), cs.getLocation(), cs.getPreprocessorError());
        }
        return null;
    }
}

