/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.cucadiagram.Bodier;

abstract class BodierAbstract
implements Bodier {
    protected final List<CharSequence> rawBody = new ArrayList<CharSequence>();
    protected Entity leaf;
    private static final long WEIGHT_BEFORE_MATCH_STEP = 1L;
    private static final long WEIGHT_AFTER_SEPARATOR = 1000L;
    private static final long WEIGHT_TRAILING_LETTERS = 1000000L;
    private static final long WEIGHT_BEFORE_MATCH_LETTER_STEP = 1000000000L;

    BodierAbstract() {
    }

    @Override
    public final void setLeaf(Entity leaf) {
        this.leaf = Objects.requireNonNull(leaf);
    }

    @Override
    public final List<CharSequence> getRawBody() {
        return Collections.unmodifiableList(this.rawBody);
    }

    private static boolean isAlphanum(char c) {
        return Character.isAlphabetic(c) || Character.isDigit(c) || c == '_';
    }

    private static boolean isOnlyLetter(char c) {
        return Character.isAlphabetic(c);
    }

    @Override
    public final CharSequence getBestMatch(CharSequence candidate) {
        if (candidate == null || candidate.length() == 0) {
            throw new IllegalArgumentException("candidate must not be empty");
        }
        CharSequence best = null;
        long bestScore = Long.MAX_VALUE;
        for (CharSequence line : this.rawBody) {
            long score = BodierAbstract.matchScore(line, candidate);
            if (score >= bestScore) continue;
            best = line;
            bestScore = score;
            if (bestScore != 0L) continue;
            return best;
        }
        return best;
    }

    static long matchScore(CharSequence fullString, CharSequence candidate) {
        if (fullString == null || candidate == null) {
            throw new IllegalArgumentException();
        }
        if (candidate.length() == 0) {
            throw new IllegalArgumentException("candidate must not be empty");
        }
        int lenFull = fullString.length();
        int lenCand = candidate.length();
        long score = 0L;
        for (int i = 0; i <= lenFull - lenCand; ++i) {
            if (BodierAbstract.startsWith(fullString, i, candidate)) {
                boolean separatorSeen = false;
                for (int j = i + lenCand; j < lenFull; ++j) {
                    char ch = fullString.charAt(j);
                    if (!separatorSeen && BodierAbstract.isAlphanum(ch)) {
                        score += 1000000L;
                        continue;
                    }
                    separatorSeen = true;
                    score += 1000L;
                }
                return score;
            }
            char ch = fullString.charAt(i);
            if (BodierAbstract.isOnlyLetter(ch)) {
                score += 1000000000L;
                continue;
            }
            ++score;
        }
        return Long.MAX_VALUE;
    }

    static boolean startsWith(CharSequence fullString, int startIdx, CharSequence candidate) {
        if (fullString == null || candidate == null) {
            return false;
        }
        int lenFull = fullString.length();
        int lenCandidate = candidate.length();
        if (lenCandidate == 0) {
            throw new IllegalArgumentException();
        }
        if (startIdx < 0 || startIdx > lenFull) {
            return false;
        }
        if (startIdx + lenCandidate > lenFull) {
            return false;
        }
        for (int i = 0; i < lenCandidate; ++i) {
            if (fullString.charAt(startIdx + i) == candidate.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

