/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.WebSocket;

class NodeAddress {
    public final String hostname;
    public final int port;
    public final String keyfile;
    public final boolean islocal;
    public final WebSocket websocket;
    public int stamp = 0;
    private int unique = 0;
    private static int uniqueKey = 0;

    NodeAddress(String string, int n, String string2, WebSocket webSocket) {
        this.hostname = string;
        this.port = n;
        this.keyfile = string2;
        this.islocal = false;
        this.websocket = webSocket != null ? webSocket : new WebSocket(false);
    }

    NodeAddress(int n, boolean bl) {
        this.hostname = "localhost";
        this.port = n;
        this.keyfile = null;
        this.islocal = true;
        this.websocket = new WebSocket(false);
        if (bl) {
            this.unique = this.getUnique();
        }
    }

    NodeAddress(NodeAddress nodeAddress) {
        this.hostname = nodeAddress.hostname;
        this.port = nodeAddress.port;
        this.keyfile = nodeAddress.keyfile;
        this.websocket = nodeAddress.websocket;
        this.islocal = nodeAddress.islocal;
        this.unique = nodeAddress.unique;
    }

    public synchronized int getStamp() {
        ++this.stamp;
        return this.stamp;
    }

    public synchronized int getUnique() {
        return ++uniqueKey;
    }

    public int hashCode() {
        int n = this.hostname.hashCode();
        if (this.keyfile != null) {
            n ^= this.keyfile.hashCode();
        }
        return n += this.port * 179425171 + this.websocket.hashCode();
    }

    public boolean equals(Object object) {
        NodeAddress nodeAddress;
        NodeAddress nodeAddress2 = nodeAddress = object instanceof NodeAddress ? (NodeAddress)object : null;
        if (this == nodeAddress) {
            return true;
        }
        if (nodeAddress == null) {
            return false;
        }
        boolean bl = false;
        if (this.keyfile == null && nodeAddress.keyfile == null) {
            bl = true;
        } else if (this.keyfile != null && nodeAddress.keyfile != null && this.keyfile.equals(nodeAddress.keyfile)) {
            bl = true;
        }
        return this.port == nodeAddress.port && this.hostname.equals(nodeAddress.hostname) && this.unique == nodeAddress.unique && bl && this.websocket.equals(nodeAddress.websocket);
    }

    public String toString() {
        String string = "";
        if (this.websocket.enabled) {
            string = ",websocket=" + this.websocket.toString();
        }
        String string2 = "";
        if (this.keyfile != null) {
            string2 = ",keyfile=" + this.keyfile;
        }
        return String.format("%s:%d%s%s", this.hostname, this.port, string2, string);
    }
}

