/*
 * Decompiled with CFR 0.152.
 */
package raven.toast;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.Animator;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import raven.toast.ui.ToastNotificationPanel;
import raven.toast.util.NotificationHolder;
import raven.toast.util.UIUtils;

public class Notifications {
    private static Notifications instance;
    private JFrame frame;
    private final Map<Location, List<NotificationAnimation>> lists = new HashMap<Location, List<NotificationAnimation>>();
    private final NotificationHolder notificationHolder = new NotificationHolder();
    private ComponentListener windowEvent;

    private void installEvent(final JFrame frame) {
        if (this.windowEvent == null && frame != null) {
            this.windowEvent = new ComponentAdapter(this){
                final /* synthetic */ Notifications this$0;
                {
                    Notifications notifications = this$0;
                    Objects.requireNonNull(notifications);
                    this.this$0 = notifications;
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    this.this$0.move(frame.getBounds());
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    this.this$0.move(frame.getBounds());
                }
            };
        }
        if (this.frame != null) {
            this.frame.removeComponentListener(this.windowEvent);
        }
        if (frame != null) {
            frame.addComponentListener(this.windowEvent);
        }
        this.frame = frame;
    }

    public static Notifications getInstance() {
        if (instance == null) {
            instance = new Notifications();
        }
        return instance;
    }

    private int getCurrentShowCount(Location location) {
        List<NotificationAnimation> list = this.lists.get((Object)location);
        return list == null ? 0 : list.size();
    }

    private synchronized void move(Rectangle rectangle) {
        for (Map.Entry<Location, List<NotificationAnimation>> set : this.lists.entrySet()) {
            for (int i = 0; i < set.getValue().size(); ++i) {
                NotificationAnimation an = set.getValue().get(i);
                if (an == null) continue;
                an.move(rectangle);
            }
        }
    }

    public void setJFrame(JFrame frame) {
        this.installEvent(frame);
    }

    public void show(Type type, String message) {
        this.show(type, Location.TOP_CENTER, message);
    }

    public void show(Type type, long duration, String message) {
        this.show(type, Location.TOP_CENTER, duration, message);
    }

    public void show(Type type, Location location, String message) {
        long duration = FlatUIUtils.getUIInt((String)"Toast.duration", (int)2500);
        this.show(type, location, duration, message);
    }

    public void show(Type type, Location location, long duration, String message) {
        this.initStart(new NotificationAnimation(this, type, location, duration, message), duration);
    }

    public void show(JComponent component) {
        this.show(Location.TOP_CENTER, component);
    }

    public void show(Location location, JComponent component) {
        long duration = FlatUIUtils.getUIInt((String)"Toast.duration", (int)2500);
        this.show(location, duration, component);
    }

    public void show(Location location, long duration, JComponent component) {
        this.initStart(new NotificationAnimation(this, location, duration, component), duration);
    }

    private synchronized boolean initStart(NotificationAnimation notificationAnimation, long duration) {
        int limit = FlatUIUtils.getUIInt((String)"Toast.limit", (int)-1);
        if (limit == -1 || this.getCurrentShowCount(notificationAnimation.getLocation()) < limit) {
            notificationAnimation.start();
            return true;
        }
        this.notificationHolder.hold(notificationAnimation);
        return false;
    }

    private synchronized void notificationClose(NotificationAnimation notificationAnimation) {
        NotificationAnimation hold = this.notificationHolder.getHold(notificationAnimation.getLocation());
        if (hold != null && this.initStart(hold, hold.getDuration())) {
            this.notificationHolder.removeHold(hold);
        }
    }

    public void clearAll() {
        this.notificationHolder.clearHold();
        for (Map.Entry<Location, List<NotificationAnimation>> set : this.lists.entrySet()) {
            for (int i = 0; i < set.getValue().size(); ++i) {
                NotificationAnimation an = set.getValue().get(i);
                if (an == null) continue;
                an.close();
            }
        }
    }

    public void clear(Location location) {
        this.notificationHolder.clearHold(location);
        List<NotificationAnimation> list = this.lists.get((Object)location);
        if (list != null) {
            for (NotificationAnimation an : list) {
                if (an == null) continue;
                an.close();
            }
        }
    }

    public void clearHold() {
        this.notificationHolder.clearHold();
    }

    public void clearHold(Location location) {
        this.notificationHolder.clearHold(location);
    }

    protected ToastNotificationPanel createNotification(Type type, String message) {
        ToastNotificationPanel toastNotificationPanel = new ToastNotificationPanel();
        toastNotificationPanel.set(type, message);
        return toastNotificationPanel;
    }

    private synchronized void updateList(Location key, NotificationAnimation values, boolean add) {
        if (add) {
            if (this.lists.containsKey((Object)key)) {
                this.lists.get((Object)key).add(values);
            } else {
                ArrayList<NotificationAnimation> list = new ArrayList<NotificationAnimation>();
                list.add(values);
                this.lists.put(key, list);
            }
        } else if (this.lists.containsKey((Object)key)) {
            this.lists.get((Object)key).remove(values);
            if (this.lists.get((Object)key).isEmpty()) {
                this.lists.remove((Object)key);
            }
        }
    }

    public class NotificationAnimation {
        private final JWindow window;
        private Animator animator;
        private boolean show;
        private float animate;
        private int x;
        private int y;
        private final Location location;
        private final long duration;
        private Insets frameInsets;
        private int horizontalSpace;
        private int animationMove;
        private boolean top;
        private boolean close;
        final /* synthetic */ Notifications this$0;

        public NotificationAnimation(Notifications this$0, Type type, Location location, long duration, String message) {
            Notifications notifications = this$0;
            Objects.requireNonNull(notifications);
            this.this$0 = notifications;
            this.show = true;
            this.close = false;
            this.installDefault();
            this.location = location;
            this.duration = duration;
            this.window = new JWindow(this$0.frame);
            ToastNotificationPanel toastNotificationPanel = this$0.createNotification(type, message);
            toastNotificationPanel.putClientProperty("Toast.closeCallback", o -> this.close());
            this.window.setContentPane(toastNotificationPanel);
            this.window.setFocusableWindowState(false);
            this.window.pack();
            toastNotificationPanel.setDialog(this.window);
        }

        public NotificationAnimation(Notifications this$0, Location location, long duration, JComponent component) {
            Notifications notifications = this$0;
            Objects.requireNonNull(notifications);
            this.this$0 = notifications;
            this.show = true;
            this.close = false;
            this.installDefault();
            this.location = location;
            this.duration = duration;
            this.window = new JWindow(this$0.frame);
            this.window.setBackground(new Color(0, 0, 0, 0));
            this.window.setContentPane(component);
            this.window.setFocusableWindowState(false);
            this.window.setSize(component.getPreferredSize());
        }

        private void installDefault() {
            this.frameInsets = UIUtils.getInsets("Toast.frameInsets", new Insets(10, 10, 10, 10));
            this.horizontalSpace = FlatUIUtils.getUIInt((String)"Toast.horizontalGap", (int)10);
            this.animationMove = FlatUIUtils.getUIInt((String)"Toast.animationMove", (int)10);
        }

        public void start() {
            int animation = FlatUIUtils.getUIInt((String)"Toast.animation", (int)200);
            int resolution = FlatUIUtils.getUIInt((String)"Toast.animationResolution", (int)5);
            this.animator = new Animator(animation, new Animator.TimingTarget(this){
                final /* synthetic */ NotificationAnimation this$1;
                {
                    NotificationAnimation notificationAnimation = this$1;
                    Objects.requireNonNull(notificationAnimation);
                    this.this$1 = notificationAnimation;
                }

                public void begin() {
                    if (this.this$1.show) {
                        this.this$1.this$0.updateList(this.this$1.location, this.this$1, true);
                        this.this$1.installLocation();
                    }
                }

                public void timingEvent(float f) {
                    this.this$1.animate = this.this$1.show ? f : 1.0f - f;
                    this.this$1.updateLocation(true);
                }

                public void end() {
                    if (this.this$1.show && !this.this$1.close) {
                        SwingUtilities.invokeLater(() -> new Thread(() -> {
                            this.this$1.sleep(this.this$1.duration);
                            if (!this.this$1.close) {
                                this.this$1.show = false;
                                this.this$1.animator.start();
                            }
                        }).start());
                    } else {
                        this.this$1.this$0.updateList(this.this$1.location, this.this$1, false);
                        this.this$1.window.dispose();
                        this.this$1.this$0.notificationClose(this.this$1);
                    }
                }
            });
            this.animator.setResolution(resolution);
            this.animator.start();
        }

        private void installLocation() {
            Rectangle rec;
            Insets insets;
            if (this.this$0.frame == null) {
                insets = UIScale.scale((Insets)this.frameInsets);
                rec = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
            } else {
                insets = UIScale.scale((Insets)FlatUIUtils.addInsets((Insets)this.frameInsets, (Insets)this.this$0.frame.getInsets()));
                rec = this.this$0.frame.getBounds();
            }
            this.setupLocation(rec, insets);
            this.window.setOpacity(0.0f);
            this.window.setVisible(true);
        }

        private void move(Rectangle rec) {
            Insets insets = UIScale.scale((Insets)FlatUIUtils.addInsets((Insets)this.frameInsets, (Insets)this.this$0.frame.getInsets()));
            this.setupLocation(rec, insets);
        }

        private void setupLocation(Rectangle rec, Insets insets) {
            if (this.location == Location.TOP_LEFT) {
                this.x = rec.x + insets.left;
                this.y = rec.y + insets.top;
                this.top = true;
            } else if (this.location == Location.TOP_CENTER) {
                this.x = rec.x + (rec.width - this.window.getWidth()) / 2;
                this.y = rec.y + insets.top;
                this.top = true;
            } else if (this.location == Location.TOP_RIGHT) {
                this.x = rec.x + rec.width - (this.window.getWidth() + insets.right);
                this.y = rec.y + insets.top;
                this.top = true;
            } else if (this.location == Location.BOTTOM_LEFT) {
                this.x = rec.x + insets.left;
                this.y = rec.y + rec.height - (this.window.getHeight() + insets.bottom);
                this.top = false;
            } else if (this.location == Location.BOTTOM_CENTER) {
                this.x = rec.x + (rec.width - this.window.getWidth()) / 2;
                this.y = rec.y + rec.height - (this.window.getHeight() + insets.bottom);
                this.top = false;
            } else if (this.location == Location.BOTTOM_RIGHT) {
                this.x = rec.x + rec.width - (this.window.getWidth() + insets.right);
                this.y = rec.y + rec.height - (this.window.getHeight() + insets.bottom);
                this.top = false;
            }
            int am = UIScale.scale((int)(this.top ? this.animationMove : -this.animationMove));
            int ly = (int)((float)(this.getLocation(this) + this.y) + this.animate * (float)am);
            this.window.setLocation(this.x, ly);
        }

        private void updateLocation(boolean loop) {
            int am = UIScale.scale((int)(this.top ? this.animationMove : -this.animationMove));
            int ly = (int)((float)(this.getLocation(this) + this.y) + this.animate * (float)am);
            this.window.setLocation(this.x, ly);
            this.window.setOpacity(this.animate);
            if (loop) {
                this.update(this);
            }
        }

        private int getLocation(NotificationAnimation notification) {
            int height = 0;
            List<NotificationAnimation> list = this.this$0.lists.get((Object)this.location);
            for (NotificationAnimation n : list) {
                if (notification == n) {
                    return height;
                }
                double v = n.animate * (float)(n.window.getHeight() + UIScale.scale((int)this.horizontalSpace));
                height = (int)((double)height + (this.top ? v : -v));
            }
            return height;
        }

        private void update(NotificationAnimation except) {
            List<NotificationAnimation> list = this.this$0.lists.get((Object)this.location);
            for (NotificationAnimation n : list) {
                if (n == except) continue;
                n.updateLocation(false);
            }
        }

        public void close() {
            if (this.show) {
                if (this.animator.isRunning()) {
                    this.animator.stop();
                }
                this.close = true;
                this.show = false;
                this.animator.start();
            }
        }

        private void sleep(long l) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
        }

        public Location getLocation() {
            return this.location;
        }

        public long getDuration() {
            return this.duration;
        }
    }

    public static enum Location {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }

    public static enum Type {
        SUCCESS,
        INFO,
        WARNING,
        ERROR;

    }
}

