/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.iio.bmp.BMPImageLoaderFactory;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.gif.GIFImageLoaderFactory;
import com.sun.javafx.iio.ios.IosImageLoaderFactory;
import com.sun.javafx.iio.jpeg.JPEGImageLoaderFactory;
import com.sun.javafx.iio.png.PNGImageLoaderFactory;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.DataURI;
import com.sun.javafx.util.Logging;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ImageStorage {
    private final HashMap<ImageFormatDescription.Signature, ImageLoaderFactory> loaderFactoriesBySignature;
    private final HashMap<String, ImageLoaderFactory> loaderFactoriesByMimeSubtype;
    private final ImageLoaderFactory[] loaderFactories = isIOS ? new ImageLoaderFactory[]{IosImageLoaderFactory.getInstance()} : new ImageLoaderFactory[]{GIFImageLoaderFactory.getInstance(), JPEGImageLoaderFactory.getInstance(), PNGImageLoaderFactory.getInstance(), BMPImageLoaderFactory.getInstance()};
    private Optional<ImageLoaderFactory> j2dImageLoaderFactory;
    private int maxSignatureLength;
    private static final boolean isIOS = PlatformUtil.isIOS();

    public static ImageStorage getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public ImageStorage() {
        this.loaderFactoriesBySignature = new HashMap(this.loaderFactories.length);
        this.loaderFactoriesByMimeSubtype = new HashMap(this.loaderFactories.length);
        for (int i = 0; i < this.loaderFactories.length; ++i) {
            this.addImageLoaderFactory(this.loaderFactories[i]);
        }
    }

    public ImageFormatDescription[] getSupportedDescriptions() {
        ImageFormatDescription[] imageFormatDescriptionArray = new ImageFormatDescription[this.loaderFactories.length];
        for (int i = 0; i < this.loaderFactories.length; ++i) {
            imageFormatDescriptionArray[i] = this.loaderFactories[i].getFormatDescription();
        }
        return imageFormatDescriptionArray;
    }

    public int getNumBands(ImageType imageType) {
        int n = -1;
        switch (imageType.ordinal()) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n = 1;
                break;
            }
            case 1: 
            case 2: {
                n = 2;
                break;
            }
            case 7: {
                n = 3;
                break;
            }
            case 9: 
            case 10: {
                n = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ImageType " + String.valueOf((Object)imageType));
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageLoaderFactory(ImageLoaderFactory imageLoaderFactory) {
        ImageFormatDescription imageFormatDescription = imageLoaderFactory.getFormatDescription();
        for (ImageFormatDescription.Signature object : imageFormatDescription.getSignatures()) {
            this.loaderFactoriesBySignature.put(object, imageLoaderFactory);
        }
        for (String string : imageFormatDescription.getMIMESubtypes()) {
            this.loaderFactoriesByMimeSubtype.put(string.toLowerCase(), imageLoaderFactory);
        }
        Class<ImageStorage> clazz = ImageStorage.class;
        synchronized (ImageStorage.class) {
            this.maxSignatureLength = -1;
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    public ImageFrame[] loadAll(InputStream inputStream, ImageLoadListener imageLoadListener, double d, double d2, boolean bl, float f, boolean bl2) throws ImageStorageException {
        ImageFrame[] imageFrameArray;
        block8: {
            ImageLoader imageLoader = null;
            imageFrameArray = null;
            try {
                imageLoader = this.findImageLoader(inputStream, imageLoadListener);
                if (imageLoader != null) {
                    imageFrameArray = this.loadAll(imageLoader, d, d2, bl, f, 1.0f, bl2);
                    break block8;
                }
                throw new ImageStorageException("No loader for image data");
            }
            catch (ImageStorageException imageStorageException) {
                throw imageStorageException;
            }
            catch (IOException iOException) {
                throw new ImageStorageException(iOException.getMessage(), iOException);
            }
            finally {
                if (imageLoader != null) {
                    imageLoader.dispose();
                }
            }
        }
        return imageFrameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageFrame[] loadAll(String string, ImageLoadListener imageLoadListener, double d, double d2, boolean bl, float f, boolean bl2) throws ImageStorageException {
        ImageFrame[] imageFrameArray;
        block32: {
            if (string == null || string.isEmpty()) {
                throw new ImageStorageException("URL can't be null or empty");
            }
            imageFrameArray = null;
            InputStream inputStream = null;
            ImageLoader imageLoader = null;
            try {
                float f2;
                block31: {
                    f2 = 1.0f;
                    try {
                        String string2;
                        DataURI dataURI = DataURI.tryParse(string);
                        if (dataURI != null) {
                            if (!"image".equalsIgnoreCase(dataURI.getMimeType())) {
                                throw new IllegalArgumentException("Unexpected MIME type: " + dataURI.getMimeType());
                            }
                            ImageLoaderFactory imageLoaderFactory = this.loaderFactoriesByMimeSubtype.get(dataURI.getMimeSubtype().toLowerCase());
                            if (imageLoaderFactory != null) {
                                inputStream = new ByteArrayInputStream(dataURI.getData());
                                ImageLoader imageLoader2 = this.getLoaderBySignature(inputStream, imageLoadListener);
                                if (imageLoader2 != null) {
                                    PlatformLogger platformLogger;
                                    boolean bl3;
                                    boolean bl4 = bl3 = !imageLoaderFactory.getFormatDescription().getFormatName().equals(imageLoader2.getFormatDescription().getFormatName());
                                    if (bl3 && (platformLogger = Logging.getJavaFXLogger()).isLoggable(PlatformLogger.Level.WARNING)) {
                                        platformLogger.warning(String.format("Image format '%s' does not match MIME type '%s/%s' in URI '%s'", imageLoader2.getFormatDescription().getFormatName(), dataURI.getMimeType(), dataURI.getMimeSubtype(), dataURI));
                                    }
                                    imageLoader = imageLoader2;
                                } else {
                                    inputStream.close();
                                    inputStream = new ByteArrayInputStream(dataURI.getData());
                                    imageLoader = imageLoaderFactory.createImageLoader(inputStream);
                                }
                            } else {
                                PlatformLogger platformLogger;
                                ImageLoader imageLoader3 = this.tryCreateJ2DImageLoader(new ByteArrayInputStream(dataURI.getData()));
                                if (imageLoader3 == null) {
                                    throw new IllegalArgumentException("Unsupported MIME subtype: image/" + dataURI.getMimeSubtype());
                                }
                                boolean bl5 = imageLoader3.getFormatDescription().getMIMESubtypes().stream().noneMatch(dataURI.getMimeSubtype()::equals);
                                if (bl5 && (platformLogger = Logging.getJavaFXLogger()).isLoggable(PlatformLogger.Level.WARNING)) {
                                    platformLogger.warning(String.format("Image format '%s' does not match MIME type '%s/%s' in URI '%s'", imageLoader3.getFormatDescription().getFormatName(), dataURI.getMimeType(), dataURI.getMimeSubtype(), dataURI));
                                }
                                imageLoader = imageLoader3;
                            }
                            break block31;
                        }
                        for (int i = Math.round(f); i >= 2; --i) {
                            try {
                                string2 = ImageTools.getScaledImageName(string, i);
                                inputStream = ImageTools.createInputStream(string2);
                                f2 = i;
                                break;
                            }
                            catch (IOException iOException) {
                                continue;
                            }
                        }
                        IOException iOException = null;
                        if (inputStream == null) {
                            try {
                                inputStream = ImageTools.createInputStream(string);
                            }
                            catch (IOException iOException2) {
                                iOException = iOException2;
                            }
                        }
                        if (inputStream == null) {
                            try {
                                string2 = ImageTools.getScaledImageName(string, 1);
                                inputStream = ImageTools.createInputStream(string2);
                            }
                            catch (IOException iOException3) {
                                iOException.addSuppressed(iOException3);
                                throw iOException;
                            }
                        }
                        imageLoader = this.findImageLoader(inputStream, imageLoadListener);
                    }
                    catch (Exception exception) {
                        throw new ImageStorageException(exception.getMessage(), exception);
                    }
                }
                if (imageLoader != null) {
                    imageFrameArray = this.loadAll(imageLoader, d, d2, bl, f, f2, bl2);
                    break block32;
                }
                throw new ImageStorageException("No loader for image data");
            }
            finally {
                if (imageLoader != null) {
                    imageLoader.dispose();
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return imageFrameArray;
    }

    private synchronized int getMaxSignatureLength() {
        if (this.maxSignatureLength < 0) {
            this.maxSignatureLength = 0;
            for (ImageFormatDescription.Signature signature : this.loaderFactoriesBySignature.keySet()) {
                int n = signature.getLength();
                if (this.maxSignatureLength >= n) continue;
                this.maxSignatureLength = n;
            }
        }
        return this.maxSignatureLength;
    }

    private ImageFrame[] loadAll(ImageLoader imageLoader, double d, double d2, boolean bl, float f, float f2, boolean bl2) throws ImageStorageException {
        ImageFrame[] imageFrameArray = null;
        ArrayList<ImageFrame> arrayList = new ArrayList<ImageFrame>();
        int n = 0;
        ImageFrame imageFrame = null;
        while (true) {
            try {
                imageFrame = imageLoader.load(n++, d, d2, bl, bl2, f, f2);
            }
            catch (Exception exception) {
                if (n > 1) break;
                throw new ImageStorageException(exception.getMessage(), exception);
            }
            if (imageFrame == null) break;
            arrayList.add(imageFrame);
        }
        int n2 = arrayList.size();
        if (n2 > 0) {
            imageFrameArray = new ImageFrame[n2];
            arrayList.toArray(imageFrameArray);
        }
        return imageFrameArray;
    }

    private ImageLoader findImageLoader(InputStream inputStream, ImageLoadListener imageLoadListener) throws IOException {
        if (isIOS) {
            return IosImageLoaderFactory.getInstance().createImageLoader(inputStream);
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(Integer.MAX_VALUE);
        ImageLoader imageLoader = this.getLoaderBySignature(inputStream, imageLoadListener);
        if (imageLoader == null) {
            inputStream.reset();
            imageLoader = this.tryCreateJ2DImageLoader(inputStream);
        }
        return imageLoader;
    }

    private ImageLoader getLoaderBySignature(InputStream inputStream, ImageLoadListener imageLoadListener) throws IOException {
        byte[] byArray = new byte[this.getMaxSignatureLength()];
        try {
            ImageTools.readFully(inputStream, byArray);
        }
        catch (EOFException eOFException) {
            return null;
        }
        for (Map.Entry<ImageFormatDescription.Signature, ImageLoaderFactory> entry : this.loaderFactoriesBySignature.entrySet()) {
            if (!entry.getKey().matches(byArray)) continue;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream);
            ImageLoader imageLoader = entry.getValue().createImageLoader(sequenceInputStream);
            if (imageLoadListener != null) {
                imageLoader.addListener(imageLoadListener);
            }
            return imageLoader;
        }
        return null;
    }

    private synchronized ImageLoader tryCreateJ2DImageLoader(InputStream inputStream) throws IOException {
        if (this.j2dImageLoaderFactory == null) {
            try {
                Class<?> clazz = Class.forName("com.sun.javafx.iio.java2d.J2DImageLoaderFactory");
                this.j2dImageLoaderFactory = Optional.of((ImageLoaderFactory)clazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]));
            }
            catch (NoClassDefFoundError | ReflectiveOperationException throwable) {
                this.j2dImageLoaderFactory = Optional.empty();
            }
        }
        if (this.j2dImageLoaderFactory.isEmpty()) {
            return null;
        }
        return this.j2dImageLoaderFactory.get().createImageLoader(inputStream);
    }

    private static class InstanceHolder {
        static final ImageStorage INSTANCE = new ImageStorage();

        private InstanceHolder() {
        }
    }

    public static enum ImageType {
        GRAY,
        GRAY_ALPHA,
        GRAY_ALPHA_PRE,
        PALETTE,
        PALETTE_ALPHA,
        PALETTE_ALPHA_PRE,
        PALETTE_TRANS,
        RGB,
        BGR,
        RGBA,
        RGBA_PRE,
        BGRA,
        BGRA_PRE,
        ABGR,
        ABGR_PRE,
        INT_RGB,
        INT_BGR,
        INT_ARGB,
        INT_ARGB_PRE;

    }
}

