/*
 * Decompiled with CFR 0.152.
 */
package mediathek.windows;

import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.charset.StandardCharsets;

public class WindowsFileUtils {
    private static final MethodHandle SHFileOperationW;
    private static final int FO_DELETE = 3;
    private static final int FOF_ALLOWUNDO = 64;
    private static final int FOF_NOCONFIRMATION = 16;
    private static final int FOF_NO_UI = 16;
    static final GroupLayout SHFILEOPSTRUCTW_LAYOUT;

    protected static MemorySegment toUtf16MultiStringSegment(Arena arena, File ... files) {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("At least one path must be provided");
        }
        StringBuilder joined = new StringBuilder();
        for (File path : files) {
            joined.append(path.getAbsolutePath()).append('\u0000');
        }
        joined.append('\u0000');
        byte[] utf16 = joined.toString().getBytes(StandardCharsets.UTF_16LE);
        MemorySegment segment = arena.allocate(utf16.length, 2L);
        segment.copyFrom(MemorySegment.ofArray(utf16));
        return segment;
    }

    protected static void debugPrintUtf16(byte[] utf16) {
        for (int i = 0; i < utf16.length; i += 2) {
            int ch = (utf16[i + 1] & 0xFF) << 8 | utf16[i] & 0xFF;
            System.out.printf("%04x ", ch);
        }
        System.out.println();
    }

    public static void moveToTrash(File ... files) throws IOException {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment pFrom = WindowsFileUtils.toUtf16MultiStringSegment(arena, files);
            MemorySegment shfileop = arena.allocate(SHFILEOPSTRUCTW_LAYOUT);
            SHFILEOPSTRUCTW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("wFunc")).set(shfileop, 0L, 3);
            SHFILEOPSTRUCTW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("pFrom")).set(shfileop, 0L, pFrom);
            SHFILEOPSTRUCTW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("pTo")).set(shfileop, 0L, MemorySegment.NULL);
            SHFILEOPSTRUCTW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("fFlags")).set(shfileop, 0L, (short)80);
            SHFILEOPSTRUCTW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("fAnyOperationsAborted")).set(shfileop, 0L, 0);
            SHFILEOPSTRUCTW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("hNameMappings")).set(shfileop, 0L, MemorySegment.NULL);
            SHFILEOPSTRUCTW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("lpszProgressTitle")).set(shfileop, 0L, MemorySegment.NULL);
            int result = SHFileOperationW.invokeExact(shfileop);
            if (result != 0) {
                throw new IOException("Move to trash failed (code " + result + ")");
            }
            result = SHFILEOPSTRUCTW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("fAnyOperationsAborted")).get(shfileop, 0L);
            if (result != 0) {
                throw new IOException("Move to trash aborted");
            }
        }
        catch (Throwable t) {
            throw new IOException("FFM moveToTrash failed", t);
        }
    }

    static {
        SHFILEOPSTRUCTW_LAYOUT = MemoryLayout.structLayout(ValueLayout.ADDRESS.withName("hwnd"), ValueLayout.JAVA_INT.withName("wFunc"), MemoryLayout.paddingLayout(4L), ValueLayout.ADDRESS.withName("pFrom"), ValueLayout.ADDRESS.withName("pTo"), ValueLayout.JAVA_SHORT.withName("fFlags"), MemoryLayout.paddingLayout(2L), ValueLayout.JAVA_INT.withName("fAnyOperationsAborted"), ValueLayout.ADDRESS.withName("hNameMappings"), ValueLayout.ADDRESS.withName("lpszProgressTitle")).withName("SHFILEOPSTRUCTW");
        Linker linker = Linker.nativeLinker();
        SymbolLookup shell32 = SymbolLookup.libraryLookup("shell32", Arena.global());
        SHFileOperationW = linker.downcallHandle(shell32.find("SHFileOperationW").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, MemoryLayout.structLayout(SHFILEOPSTRUCTW_LAYOUT)), new Linker.Option[0]);
    }
}

