/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.affinity;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import mediathek.tool.affinity.IAffinity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lmediathek/tool/affinity/WindowsAffinity;", "Lmediathek/tool/affinity/IAffinity;", "<init>", "()V", "setDesiredCpuAffinity", "", "numCpus", "", "Companion", "MediathekView"})
@SourceDebugExtension(value={"SMAP\nWindowsAffinity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsAffinity.kt\nmediathek/tool/affinity/WindowsAffinity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1#2:60\n1803#3,3:61\n*S KotlinDebug\n*F\n+ 1 WindowsAffinity.kt\nmediathek/tool/affinity/WindowsAffinity\n*L\n29#1:61,3\n*E\n"})
public final class WindowsAffinity
implements IAffinity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LogManager.getLogger();

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDesiredCpuAffinity(int numCpus) {
        void $this$fold$iv;
        if (!(1 <= numCpus ? numCpus < 65 : false)) {
            boolean bl = false;
            String string = "numCpus must be between 1 and 64";
            throw new IllegalArgumentException(string.toString());
        }
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)numCpus);
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int element$iv;
            int n = element$iv = ((IntIterator)iterator).nextInt();
            long acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc | 1L << i;
        }
        long affinityMask = accumulator$iv;
        Linker linker = Linker.nativeLinker();
        boolean bl = false;
        SymbolLookup kernel32 = SymbolLookup.libraryLookup("kernel32.dll", Arena.global());
        MethodHandle methodHandle = linker.downcallHandle(kernel32.find("GetCurrentProcess").orElseThrow(), FunctionDescriptor.of(ValueLayout.ADDRESS, new MemoryLayout[0]), new Linker.Option[0]);
        Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"downcallHandle(...)");
        MethodHandle getCurrentProcess = methodHandle;
        MemoryLayout[] element$iv = new MemoryLayout[]{ValueLayout.ADDRESS, ValueLayout.JAVA_LONG};
        MethodHandle methodHandle2 = linker.downcallHandle(kernel32.find("SetProcessAffinityMask").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, element$iv), new Linker.Option[0]);
        Intrinsics.checkNotNullExpressionValue((Object)methodHandle2, (String)"downcallHandle(...)");
        MethodHandle setAffinity = methodHandle2;
        MemorySegment processHandle = getCurrentProcess.invoke();
        int result = setAffinity.invoke(processHandle, affinityMask);
        if (result != 0) {
            String string = Long.toString(affinityMask, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            logger.info("CPU affinity was set successfully to mask: 0x" + string);
        } else {
            logger.warn("Failed to set CPU affinity.");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lmediathek/tool/affinity/WindowsAffinity$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

