/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import kotlin.Metadata;
import mediathek.config.StandardLocations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmediathek/tool/SingleInstance;", "Ljava/io/Closeable;", "<init>", "()V", "channel", "Ljava/nio/channels/FileChannel;", "lock", "Ljava/nio/channels/FileLock;", "raf", "Ljava/io/RandomAccessFile;", "isAppAlreadyActive", "", "closeLock", "", "closeFile", "close", "MediathekView"})
public final class SingleInstance
implements Closeable {
    @Nullable
    private FileChannel channel;
    @Nullable
    private FileLock lock;
    @NotNull
    private final RandomAccessFile raf = new RandomAccessFile(StandardLocations.getLockFilePath().toFile(), "rw");

    public final boolean isAppAlreadyActive() {
        try {
            FileChannel fileChannel = this.channel = this.raf.getChannel();
            FileLock fileLock = this.lock = fileChannel != null ? fileChannel.tryLock() : null;
            if (this.lock == null) {
                this.closeLock();
                return true;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> SingleInstance.isAppAlreadyActive$lambda$0(this)));
            return false;
        }
        catch (Exception e) {
            this.close();
            return true;
        }
    }

    private final void closeLock() {
        try {
            FileLock fileLock = this.lock;
            if (fileLock != null) {
                fileLock.release();
            }
            FileChannel fileChannel = this.channel;
            if (fileChannel != null) {
                fileChannel.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void closeFile() {
        try {
            this.raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.closeLock();
        this.closeFile();
    }

    private static final void isAppAlreadyActive$lambda$0(SingleInstance this$0) {
        this$0.close();
        try {
            Files.deleteIfExists(StandardLocations.getLockFilePath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

