/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tasks;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import mediathek.config.Daten;
import mediathek.config.StandardLocations;
import mediathek.daten.DatenFilm;
import mediathek.daten.IndexedFilmList;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.FileUtils;
import mediathek.tool.LuceneDefaultAnalyzer;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.datum.DateUtil;
import mediathek.tool.datum.DatumFilm;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.jetbrains.annotations.NotNull;

public class LuceneIndexWorker
extends SwingWorker<Void, Void> {
    private static final Logger logger = LogManager.getLogger();
    private final JProgressBar progressBar;
    private final JLabel progLabel;
    private final DateFormat weekdayFormatter = new SimpleDateFormat("EEEE", Locale.GERMAN);
    private int oldProgress;

    public LuceneIndexWorker(@NotNull JLabel progLabel, @NotNull JProgressBar progressBar) {
        this.progressBar = progressBar;
        this.progLabel = progLabel;
        SwingUtilities.invokeLater(() -> {
            MediathekGui ui = MediathekGui.ui();
            ui.toggleBlacklistAction.setEnabled(false);
            ui.editBlacklistAction.setEnabled(false);
            ui.loadFilmListAction.setEnabled(false);
            progLabel.setText("Blacklist anwenden");
            progressBar.setIndeterminate(true);
        });
    }

    private void indexFilm(@NotNull IndexWriter writer, @NotNull DatenFilm film) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", Integer.toString(film.getFilmNr()), Field.Store.YES));
        doc.add((IndexableField)new StringField("neu", Boolean.toString(film.isNew()), Field.Store.NO));
        doc.add((IndexableField)new TextField("sender", film.getSender(), Field.Store.NO));
        doc.add((IndexableField)new TextField("titel", film.getTitle(), Field.Store.NO));
        doc.add((IndexableField)new TextField("thema", film.getThema(), Field.Store.NO));
        doc.add((IndexableField)new IntPoint("l\u00e4nge", new int[]{film.getFilmLength()}));
        doc.add((IndexableField)new IntPoint("gr\u00f6\u00dfe", new int[]{film.getFileSize().toInteger()}));
        doc.add((IndexableField)new TextField("beschreibung", film.getDescription(), Field.Store.NO));
        doc.add((IndexableField)new StringField("livestream", Boolean.toString(film.isLivestream()), Field.Store.NO));
        doc.add((IndexableField)new StringField("highquality", Boolean.toString(film.isHighQuality()), Field.Store.NO));
        doc.add((IndexableField)new StringField("untertitel", Boolean.toString(film.hasSubtitle() || film.hasBurnedInSubtitles()), Field.Store.NO));
        doc.add((IndexableField)new StringField("trailerteaser", Boolean.toString(film.isTrailerTeaser()), Field.Store.NO));
        doc.add((IndexableField)new StringField("audioversion", Boolean.toString(film.isAudioVersion()), Field.Store.NO));
        doc.add((IndexableField)new StringField("signlanguage", Boolean.toString(film.isSignLanguage()), Field.Store.NO));
        doc.add((IndexableField)new StringField("duplicate", Boolean.toString(film.isDuplicate()), Field.Store.NO));
        this.addSendeDatum(doc, film);
        this.addSendeZeit(doc, film);
        this.addWochentag(doc, film);
        writer.addDocument((Iterable)doc);
    }

    private void addSendeZeit(@NotNull Document doc, @NotNull DatenFilm film) {
        String startzeit = film.getSendeZeit();
        if (!startzeit.isEmpty()) {
            doc.add((IndexableField)new StringField("startzeit", startzeit, Field.Store.NO));
        }
    }

    private void addWochentag(@NotNull Document doc, @NotNull DatenFilm film) {
        DatumFilm date = film.getDatumFilm();
        if (date != DatumFilm.UNDEFINED_FILM_DATE) {
            String strDate = this.weekdayFormatter.format(date);
            doc.add((IndexableField)new TextField("wochentag", strDate, Field.Store.NO));
        }
    }

    private void addSendeDatum(@NotNull Document doc, @NotNull DatenFilm film) {
        String sendeDatumStr = DateTools.timeToString((long)DateUtil.convertFilmDateToLuceneDate(film), (DateTools.Resolution)DateTools.Resolution.DAY);
        doc.add((IndexableField)new StringField("sendedatum", sendeDatumStr, Field.Store.NO));
    }

    @Override
    protected Void doInBackground() {
        IndexedFilmList filmListe = (IndexedFilmList)Daten.getInstance().getListeFilmeNachBlackList();
        SwingUtilities.invokeLater(() -> {
            this.progLabel.setText("Indiziere Filme");
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(0);
            this.progressBar.setIndeterminate(false);
        });
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LuceneDefaultAnalyzer.buildAnalyzer());
        indexWriterConfig.setRAMBufferSizeMB(256.0);
        try (IndexWriter writer = new IndexWriter(filmListe.getLuceneDirectory(), indexWriterConfig);){
            float totalSize = filmListe.size();
            int counter = 0;
            Stopwatch watch = Stopwatch.createStarted();
            writer.deleteAll();
            for (DatenFilm film : filmListe) {
                int progress;
                this.indexFilm(writer, film);
                if ((progress = (int)(100.0f * ((float)(++counter) / totalSize))) == this.oldProgress) continue;
                this.oldProgress = progress;
                SwingUtilities.invokeLater(() -> this.progressBar.setValue(progress));
            }
            writer.commit();
            watch.stop();
            logger.trace("Lucene index creation took {}", (Object)watch);
            DirectoryReader reader = filmListe.getReader();
            if (reader != null) {
                reader.close();
            }
            reader = DirectoryReader.open((Directory)filmListe.getLuceneDirectory());
            filmListe.setReader(reader);
        }
        catch (Exception ex) {
            logger.error("Lucene film index most probably damaged, deleting it.");
            try {
                Path indexPath = StandardLocations.getFilmIndexPath();
                if (Files.exists(indexPath, new LinkOption[0])) {
                    FileUtils.deletePathRecursively(indexPath);
                }
            }
            catch (IOException e) {
                logger.error("Unable to delete lucene index path", (Throwable)e);
            }
            SwingUtilities.invokeLater(() -> {
                SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Der Filmindex ist besch\u00e4digt und wurde gel\u00f6scht.\nDas Programm wird beendet, bitte starten Sie es erneut.", ex);
                MediathekGui.ui().quitApplication();
            });
        }
        return null;
    }

    @Override
    protected void done() {
        MediathekGui ui = MediathekGui.ui();
        ui.toggleBlacklistAction.setEnabled(true);
        ui.editBlacklistAction.setEnabled(true);
        ui.loadFilmListAction.setEnabled(true);
    }
}

