/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.analysis;

import androidx.compose.compiler.plugins.kotlin.ComposeFqNames;
import androidx.compose.compiler.plugins.kotlin.analysis.Stability;
import androidx.compose.compiler.plugins.kotlin.lower.AbstractComposeLoweringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0002\u001a\u001e\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\n\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\f\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\u0010H\u0002\u001a\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"knownUnstable", "", "Landroidx/compose/compiler/plugins/kotlin/analysis/Stability;", "knownStable", "isUncertain", "isExpressible", "normalize", "forEach", "", "callback", "Lkotlin/Function1;", "hasStableMarker", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "isStableMarker", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "hasStableMarkedDescendant", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "stabilityParamBitmask", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;)Ljava/lang/Integer;", "kotlin-compose-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nStability.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Stability.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/StabilityKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,483:1\n1761#2,3:484\n1740#2,3:487\n1761#2,3:490\n1740#2,3:493\n1869#2,2:496\n1761#2,3:498\n1761#2,3:501\n*S KotlinDebug\n*F\n+ 1 Stability.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/StabilityKt\n*L\n97#1:484,3\n105#1:487,3\n113#1:490,3\n121#1:493,3\n169#1:496,2\n176#1:498,3\n183#1:501,3\n*E\n"})
public final class StabilityKt {
    public static final boolean knownUnstable(@NotNull Stability $this$knownUnstable) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)$this$knownUnstable, (String)"<this>");
            Stability stability = $this$knownUnstable;
            if (stability instanceof Stability.Certain) {
                bl = !((Stability.Certain)$this$knownUnstable).getStable();
            } else if (stability instanceof Stability.Runtime) {
                bl = false;
            } else if (stability instanceof Stability.Unknown) {
                bl = false;
            } else if (stability instanceof Stability.Parameter) {
                bl = false;
            } else if (stability instanceof Stability.Combined) {
                Iterable $this$any$iv = ((Stability.Combined)$this$knownUnstable).getElements();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Stability it = (Stability)element$iv;
                        boolean bl2 = false;
                        if (!StabilityKt.knownUnstable(it)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean knownStable(@NotNull Stability $this$knownStable) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)$this$knownStable, (String)"<this>");
            Stability stability = $this$knownStable;
            if (stability instanceof Stability.Certain) {
                bl = ((Stability.Certain)$this$knownStable).getStable();
            } else if (stability instanceof Stability.Runtime) {
                bl = false;
            } else if (stability instanceof Stability.Unknown) {
                bl = false;
            } else if (stability instanceof Stability.Parameter) {
                bl = false;
            } else if (stability instanceof Stability.Combined) {
                Iterable $this$all$iv = ((Stability.Combined)$this$knownStable).getElements();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Stability it = (Stability)element$iv;
                        boolean bl2 = false;
                        if (StabilityKt.knownStable(it)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean isUncertain(@NotNull Stability $this$isUncertain) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)$this$isUncertain, (String)"<this>");
            Stability stability = $this$isUncertain;
            if (stability instanceof Stability.Certain) {
                bl = false;
            } else if (stability instanceof Stability.Runtime) {
                bl = true;
            } else if (stability instanceof Stability.Unknown) {
                bl = true;
            } else if (stability instanceof Stability.Parameter) {
                bl = true;
            } else if (stability instanceof Stability.Combined) {
                Iterable $this$any$iv = ((Stability.Combined)$this$isUncertain).getElements();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Stability it = (Stability)element$iv;
                        boolean bl2 = false;
                        if (!StabilityKt.isUncertain(it)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean isExpressible(@NotNull Stability $this$isExpressible) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)$this$isExpressible, (String)"<this>");
            Stability stability = $this$isExpressible;
            if (stability instanceof Stability.Certain) {
                bl = true;
            } else if (stability instanceof Stability.Runtime) {
                bl = true;
            } else if (stability instanceof Stability.Unknown) {
                bl = false;
            } else if (stability instanceof Stability.Parameter) {
                bl = true;
            } else if (stability instanceof Stability.Combined) {
                Iterable $this$all$iv = ((Stability.Combined)$this$isExpressible).getElements();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Stability it = (Stability)element$iv;
                        boolean bl2 = false;
                        if (StabilityKt.isExpressible(it)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public static final Stability normalize(@NotNull Stability $this$normalize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        Stability stability = $this$normalize;
        if (stability instanceof Stability.Certain || stability instanceof Stability.Parameter || stability instanceof Stability.Runtime || stability instanceof Stability.Unknown) {
            return $this$normalize;
        }
        if (!(stability instanceof Stability.Combined)) {
            throw new NoWhenBranchMatchedException();
        }
        Set parameters = new LinkedHashSet();
        List parts = new ArrayList();
        Object[] objectArray = new Stability[]{$this$normalize};
        List stack = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)stack).isEmpty()) {
            Stability stability2 = (Stability)stack.remove(stack.size() - 1);
            if (stability2 instanceof Stability.Combined) {
                stack.addAll((Collection)((Stability.Combined)stability2).getElements());
                continue;
            }
            if (stability2 instanceof Stability.Certain) {
                if (((Stability.Certain)stability2).getStable()) continue;
                return Stability.Companion.getUnstable();
            }
            if (stability2 instanceof Stability.Parameter) {
                if (parameters.contains(((Stability.Parameter)stability2).getParameter().getSymbol())) continue;
                parameters.add(((Stability.Parameter)stability2).getParameter().getSymbol());
                parts.add(stability2);
                continue;
            }
            if (stability2 instanceof Stability.Runtime) {
                parts.add(stability2);
                continue;
            }
            if (stability2 instanceof Stability.Unknown) continue;
            throw new NoWhenBranchMatchedException();
        }
        return new Stability.Combined(parts);
    }

    public static final void forEach(@NotNull Stability $this$forEach, @NotNull Function1<? super Stability, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)$this$forEach, (String)"<this>");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if ($this$forEach instanceof Stability.Combined) {
            Iterable $this$forEach$iv = ((Stability.Combined)$this$forEach).getElements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Stability it = (Stability)element$iv;
                boolean bl = false;
                StabilityKt.forEach(it, callback);
            }
        } else {
            callback.invoke((Object)$this$forEach);
        }
    }

    public static final boolean hasStableMarker(@NotNull IrAnnotationContainer $this$hasStableMarker) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasStableMarker, (String)"<this>");
            Iterable $this$any$iv = $this$hasStableMarker.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrConstructorCall it = (IrConstructorCall)element$iv;
                    boolean bl2 = false;
                    if (!StabilityKt.isStableMarker(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isStableMarker(IrConstructorCall $this$isStableMarker) {
        IrClassSymbol irClassSymbol = AbstractComposeLoweringKt.getAnnotationClass($this$isStableMarker);
        return irClassSymbol != null && (irClassSymbol = (IrClass)irClassSymbol.getOwner()) != null ? IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irClassSymbol), (FqName)ComposeFqNames.INSTANCE.getStableMarker()) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasStableMarkedDescendant(IrClass $this$hasStableMarkedDescendant) {
        boolean bl;
        if (StabilityKt.hasStableMarker((IrAnnotationContainer)$this$hasStableMarkedDescendant)) {
            return true;
        }
        Iterable $this$any$iv = $this$hasStableMarkedDescendant.getSuperTypes();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            IrType it = (IrType)element$iv;
            boolean bl2 = false;
            if (!IrTypePredicatesKt.isAny((IrType)it)) {
                boolean bl3;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)it);
                if (irClassSymbol != null && (irClassSymbol = (IrClass)irClassSymbol.getOwner()) != null) {
                    if (StabilityKt.hasStableMarkedDescendant((IrClass)irClassSymbol)) {
                        return true;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final Integer stabilityParamBitmask(IrAnnotationContainer $this$stabilityParamBitmask) {
        IrConstructorCall irConstructorCall = AdditionalIrUtilsKt.findAnnotation((List)$this$stabilityParamBitmask.getAnnotations(), (FqName)ComposeFqNames.INSTANCE.getStabilityInferred());
        IrExpression irExpression = irConstructorCall != null ? (IrExpression)irConstructorCall.getArguments().get(0) : null;
        IrConst irConst = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        Object object = irConst != null ? irConst.getValue() : null;
        return object instanceof Integer ? (Integer)object : null;
    }

    public static final /* synthetic */ boolean access$hasStableMarkedDescendant(IrClass $receiver) {
        return StabilityKt.hasStableMarkedDescendant($receiver);
    }

    public static final /* synthetic */ Integer access$stabilityParamBitmask(IrAnnotationContainer $receiver) {
        return StabilityKt.stabilityParamBitmask($receiver);
    }
}

