/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.api.CommonApi;
import com.apicatalog.jsonld.api.ContextApi;
import com.apicatalog.jsonld.api.LoaderApi;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.ToRdfProcessor;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.rdf.RdfDataset;
import jakarta.json.JsonStructure;
import java.net.URI;

public final class ToRdfApi
implements CommonApi<ToRdfApi>,
LoaderApi<ToRdfApi>,
ContextApi<ToRdfApi> {
    private final Document document;
    private final URI documentUri;
    private JsonLdOptions options;

    public ToRdfApi(URI documentUri) {
        this.document = null;
        this.documentUri = documentUri;
        this.options = new JsonLdOptions();
    }

    public ToRdfApi(Document document) {
        this.document = document;
        this.documentUri = null;
        this.options = new JsonLdOptions();
    }

    @Override
    public ToRdfApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    @Override
    public ToRdfApi context(URI contextUri) {
        this.options.setExpandContext(contextUri);
        return this;
    }

    @Override
    public ToRdfApi context(String contextLocation) {
        URI contextUri = null;
        if (contextLocation != null && (contextUri = UriUtils.create(contextLocation)) == null) {
            throw new IllegalArgumentException("Context location must be valid URI or null but is [" + contextLocation + ".");
        }
        return this.context(contextUri);
    }

    @Override
    public ToRdfApi context(JsonStructure context) {
        this.options.setExpandContext(context != null ? JsonDocument.of(context) : null);
        return this;
    }

    @Override
    public ToRdfApi context(Document context) {
        this.options.setExpandContext(context);
        return this;
    }

    public ToRdfApi produceGeneralizedRdf(boolean enable) {
        this.options.setProduceGeneralizedRdf(enable);
        return this;
    }

    public ToRdfApi produceGeneralizedRdf() {
        return this.produceGeneralizedRdf(true);
    }

    public ToRdfApi rdfDirection(JsonLdOptions.RdfDirection direction) {
        this.options.setRdfDirection(direction);
        return this;
    }

    @Override
    public ToRdfApi mode(JsonLdVersion processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    @Override
    public ToRdfApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    @Override
    public ToRdfApi loader(DocumentLoader loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    @Override
    public ToRdfApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public RdfDataset get() throws JsonLdError {
        if (this.documentUri != null) {
            return ToRdfProcessor.toRdf(this.documentUri, this.options);
        }
        if (this.document != null) {
            return ToRdfProcessor.toRdf(this.document, this.options);
        }
        throw new IllegalArgumentException();
    }

    public ToRdfApi numericId() {
        this.options.setNumericId(true);
        return this;
    }
}

