/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.ExemplarStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.NumberDataPointMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.NumberDataPoint;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.PointData;
import java.io.IOException;
import java.util.List;

final class NumberDataPointStatelessMarshaler
implements StatelessMarshaler<PointData> {
    static final NumberDataPointStatelessMarshaler INSTANCE = new NumberDataPointStatelessMarshaler();

    private NumberDataPointStatelessMarshaler() {
    }

    public void writeTo(Serializer output, PointData point, MarshalerContext context) throws IOException {
        output.serializeFixed64(NumberDataPoint.START_TIME_UNIX_NANO, point.getStartEpochNanos());
        output.serializeFixed64(NumberDataPoint.TIME_UNIX_NANO, point.getEpochNanos());
        ProtoFieldInfo valueField = NumberDataPointMarshaler.toProtoPointValueType(point);
        if (valueField == NumberDataPoint.AS_INT) {
            output.serializeFixed64Optional(valueField, ((LongPointData)point).getValue());
        } else {
            output.serializeDoubleOptional(valueField, ((DoublePointData)point).getValue());
        }
        output.serializeRepeatedMessageWithContext(NumberDataPoint.EXEMPLARS, point.getExemplars(), (StatelessMarshaler)ExemplarStatelessMarshaler.INSTANCE, context);
        output.serializeRepeatedMessageWithContext(NumberDataPoint.ATTRIBUTES, point.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, context);
    }

    public int getBinarySerializedSize(PointData point, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)NumberDataPoint.START_TIME_UNIX_NANO, (long)point.getStartEpochNanos());
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)NumberDataPoint.TIME_UNIX_NANO, (long)point.getEpochNanos());
        ProtoFieldInfo valueField = NumberDataPointMarshaler.toProtoPointValueType(point);
        size = valueField == NumberDataPoint.AS_INT ? (size += MarshalerUtil.sizeFixed64Optional((ProtoFieldInfo)valueField, (long)((LongPointData)point).getValue())) : (size += MarshalerUtil.sizeDoubleOptional((ProtoFieldInfo)valueField, (double)((DoublePointData)point).getValue()));
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)NumberDataPoint.EXEMPLARS, (List)point.getExemplars(), (StatelessMarshaler)ExemplarStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        return size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)NumberDataPoint.ATTRIBUTES, (Attributes)point.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
    }
}

