/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.range;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.List;
import java.util.Objects;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.query.range.Range;

record ValueList<U>(List<U> values) implements Range<U>
{
    ValueList {
        Objects.requireNonNull(values, "value list is null");
        if (values.isEmpty()) {
            throw new IllegalArgumentException("value list is empty");
        }
    }

    @Override
    public Predicate toPredicate(Path<? extends U> path, CriteriaBuilder builder) {
        return path.in(this.values);
    }

    @Override
    public Class<? extends U> getType() {
        return ReflectHelper.getClass(this.values.get(0));
    }
}

