/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.remover.query;

import java.util.Map;
import java.util.Objects;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.MultipleConditionQueryRemover;
import org.keycloak.models.sessions.infinispan.entities.RemoteUserSessionEntity;
import org.keycloak.models.sessions.infinispan.query.UserSessionQueries;

public class UserSessionQueryConditionalRemover
extends MultipleConditionQueryRemover<String, RemoteUserSessionEntity> {
    @Override
    String getEntity() {
        return UserSessionQueries.USER_SESSION;
    }

    public void removeByRealmId(String realmId) {
        this.add(new RemoveByRealm(this.nextParameter(), realmId));
    }

    public void removeByUserId(String realmId, String userId) {
        this.add(new RemoveUser(this.nextParameter(), userId, this.nextParameter(), realmId));
    }

    private record RemoveByRealm(String parameter, String realmId) implements MultipleConditionQueryRemover.RemoveCondition<String, RemoteUserSessionEntity>
    {
        @Override
        public String getConditionalClause() {
            return "(realmId = :%s)".formatted(this.parameter);
        }

        @Override
        public void addParameters(Map<String, Object> parameters) {
            parameters.put(this.parameter, this.realmId);
        }

        @Override
        public boolean willRemove(String key, RemoteUserSessionEntity value) {
            return Objects.equals(this.realmId, value.getRealmId());
        }
    }

    private record RemoveUser(String userParameter, String userId, String realmParameter, String realmId) implements MultipleConditionQueryRemover.RemoveCondition<String, RemoteUserSessionEntity>
    {
        @Override
        public String getConditionalClause() {
            return "(userId = :%s && realmId = :%s)".formatted(this.userParameter, this.realmParameter);
        }

        @Override
        public void addParameters(Map<String, Object> parameters) {
            parameters.put(this.userParameter, this.userId);
            parameters.put(this.realmParameter, this.realmId);
        }

        @Override
        public boolean willRemove(String key, RemoteUserSessionEntity value) {
            return Objects.equals(value.getUserId(), this.userId) && Objects.equals(value.getRealmId(), this.realmId);
        }
    }
}

