/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.distribution.DistributionManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.infinispan.events.AuthenticationSessionAuthNoteUpdateEvent;
import org.keycloak.models.sessions.infinispan.InfinispanAuthenticationSessionProvider;
import org.keycloak.models.sessions.infinispan.changes.CacheHolder;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangesUtils;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.events.AbstractAuthSessionClusterListener;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.transaction.InfinispanTransactionProvider;
import org.keycloak.models.sessions.infinispan.util.InfinispanKeyGenerator;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.sessions.AuthenticationSessionProviderFactory;

public class InfinispanAuthenticationSessionProviderFactory
implements AuthenticationSessionProviderFactory<InfinispanAuthenticationSessionProvider>,
EnvironmentDependentProviderFactory,
ProviderEventListener {
    private static final Logger log = Logger.getLogger(InfinispanAuthenticationSessionProviderFactory.class);
    private final InfinispanKeyGenerator keyGenerator = new InfinispanKeyGenerator();
    private CacheHolder<String, RootAuthenticationSessionEntity> cacheHolder;
    private int authSessionsLimit;
    public static final String AUTH_SESSIONS_LIMIT = "authSessionsLimit";
    public static final int DEFAULT_AUTH_SESSIONS_LIMIT = 300;
    public static final String AUTHENTICATION_SESSION_EVENTS = "AUTHENTICATION_SESSION_EVENTS";
    public static final String REALM_REMOVED_AUTHSESSION_EVENT = "REALM_REMOVED_EVENT_AUTHSESSIONS";

    public void init(Config.Scope config) {
        this.authSessionsLimit = InfinispanAuthenticationSessionProviderFactory.getAuthSessionsLimit(config);
    }

    public static int getAuthSessionsLimit(Config.Scope config) {
        Integer limit = config.getInt(AUTH_SESSIONS_LIMIT, Integer.valueOf(300));
        return limit <= 0 ? 300 : limit;
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register((ProviderEventListener)this);
        try (KeycloakSession session = factory.create();){
            this.cacheHolder = InfinispanChangesUtils.createWithCache(session, "authenticationSessions", SessionTimeouts::getAuthSessionLifespanMS, SessionTimeouts::getAuthSessionMaxIdleMS);
        }
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(AUTH_SESSIONS_LIMIT).type("int").helpText("The maximum number of concurrent authentication sessions per RootAuthenticationSession.").defaultValue((Object)300).add().build();
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof PostMigrationEvent) {
            PostMigrationEvent pme = (PostMigrationEvent)event;
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)pme.getFactory(), this::registerClusterListeners);
        }
    }

    protected void registerClusterListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener(REALM_REMOVED_AUTHSESSION_EVENT, (ClusterListener)new AbstractAuthSessionClusterListener<RealmRemovedSessionEvent>(sessionFactory){

            @Override
            protected void eventReceived(InfinispanAuthenticationSessionProvider provider, RealmRemovedSessionEvent sessionEvent) {
                provider.onRealmRemovedEvent(sessionEvent.getRealmId());
            }
        });
        cluster.registerListener(AUTHENTICATION_SESSION_EVENTS, this::updateAuthNotes);
        log.debug((Object)"Registered cluster listeners");
    }

    public InfinispanAuthenticationSessionProvider create(KeycloakSession session) {
        return new InfinispanAuthenticationSessionProvider(session, this.keyGenerator, this.createTransaction(session), this.authSessionsLimit);
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(InfinispanConnectionProvider.class, InfinispanTransactionProvider.class);
    }

    private void updateAuthNotes(ClusterEvent clEvent) {
        if (!(clEvent instanceof AuthenticationSessionAuthNoteUpdateEvent)) {
            return;
        }
        AuthenticationSessionAuthNoteUpdateEvent event = (AuthenticationSessionAuthNoteUpdateEvent)clEvent;
        DistributionManager distribution = this.cacheHolder.cache().getAdvancedCache().getDistributionManager();
        if (distribution != null && !distribution.getCacheTopology().getDistribution((Object)event.getAuthSessionId()).isPrimary()) {
            return;
        }
        SessionEntityWrapper authSession = (SessionEntityWrapper)this.cacheHolder.cache().get((Object)event.getAuthSessionId());
        this.updateAuthSession(authSession, event.getTabId(), event.getAuthNotesFragment());
    }

    private void updateAuthSession(SessionEntityWrapper<RootAuthenticationSessionEntity> rootAuthSessionWrapper, String tabId, Map<String, String> authNotesFragment) {
        if (rootAuthSessionWrapper == null || rootAuthSessionWrapper.getEntity() == null) {
            return;
        }
        RootAuthenticationSessionEntity rootAuthSession = rootAuthSessionWrapper.getEntity();
        AuthenticationSessionEntity authSession = rootAuthSession.getAuthenticationSessions().get(tabId);
        if (authSession != null) {
            if (authSession.getAuthNotes() == null) {
                authSession.setAuthNotes(new ConcurrentHashMap<String, String>());
            }
            for (Map.Entry<String, String> me : authNotesFragment.entrySet()) {
                String value = me.getValue();
                if (value == null) {
                    authSession.getAuthNotes().remove(me.getKey());
                    continue;
                }
                authSession.getAuthNotes().put(me.getKey(), value);
            }
        }
        this.cacheHolder.cache().replace((Object)rootAuthSession.getId(), new SessionEntityWrapper<RootAuthenticationSessionEntity>(rootAuthSessionWrapper.getLocalMetadata(), rootAuthSession));
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isEmbeddedInfinispan();
    }

    private InfinispanChangelogBasedTransaction<String, RootAuthenticationSessionEntity> createTransaction(KeycloakSession session) {
        InfinispanChangelogBasedTransaction<String, RootAuthenticationSessionEntity> tx = new InfinispanChangelogBasedTransaction<String, RootAuthenticationSessionEntity>(session, this.cacheHolder);
        ((InfinispanTransactionProvider)session.getProvider(InfinispanTransactionProvider.class)).registerTransaction(tx);
        return tx;
    }
}

