/*
 * Decompiled with CFR 0.152.
 */
package io.setl.rdf.normalization;

import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfValue;
import java.util.Optional;

public class NQuadSerializer {
    private static final RdfResource BLANK_A = Rdf.createBlankNode((String)"_:a");
    private static final RdfResource BLANK_Z = Rdf.createBlankNode((String)"_:z");

    private static void escape(StringBuilder builder, String value) {
        value.codePoints().forEach(ch -> {
            switch (ch) {
                case 10: {
                    builder.append("\\n");
                    break;
                }
                case 13: {
                    builder.append("\\r");
                    break;
                }
                case 34: {
                    builder.append("\\\"");
                    break;
                }
                case 92: {
                    builder.append("\\\\");
                    break;
                }
                default: {
                    builder.appendCodePoint(ch);
                }
            }
        });
    }

    static String forBlank(RdfNQuad q0, RdfValue blankId) {
        RdfResource g;
        Optional<RdfResource> graph;
        RdfValue object;
        RdfResource subject = q0.getSubject();
        if (subject.isBlankNode()) {
            RdfResource rdfResource = subject = subject.equals(blankId) ? BLANK_A : BLANK_Z;
        }
        if ((object = q0.getObject()).isBlankNode()) {
            RdfResource rdfResource = object = object.equals((Object)blankId) ? BLANK_A : BLANK_Z;
        }
        if ((graph = q0.getGraphName()).isPresent() && (g = (RdfResource)graph.get()).isBlankNode()) {
            graph = Optional.of(g.equals(blankId) ? BLANK_A : BLANK_Z);
        }
        return NQuadSerializer.write(subject, q0.getPredicate(), object, graph);
    }

    private static void write(StringBuilder builder, RdfLiteral literal) {
        if (literal == null) {
            throw new IllegalArgumentException();
        }
        builder.append('\"');
        NQuadSerializer.escape(builder, literal.getValue());
        builder.append('\"');
        Optional language = literal.getLanguage();
        if (language.isPresent()) {
            builder.append('@');
            builder.append((String)language.get());
        } else if (literal.getDatatype() != null) {
            if ("http://www.w3.org/2001/XMLSchema#string".equals(literal.getDatatype())) {
                return;
            }
            builder.append("^^");
            NQuadSerializer.writeIri(builder, literal.getDatatype());
        }
    }

    public static String write(RdfNQuad nQuad) {
        return NQuadSerializer.write(nQuad.getSubject(), nQuad.getPredicate(), nQuad.getObject(), nQuad.getGraphName());
    }

    public static String write(RdfResource subject, RdfResource predicate, RdfValue object, Optional<RdfResource> graphName) {
        StringBuilder builder = new StringBuilder();
        NQuadSerializer.writeValue(builder, (RdfValue)subject);
        builder.append(' ');
        NQuadSerializer.writeValue(builder, (RdfValue)predicate);
        builder.append(' ');
        NQuadSerializer.writeValue(builder, object);
        builder.append(' ');
        if (graphName.isPresent()) {
            NQuadSerializer.writeValue(builder, (RdfValue)graphName.get());
            builder.append(' ');
        }
        builder.append(".\n");
        return builder.toString();
    }

    private static void writeIri(StringBuilder builder, String iri) {
        if (iri == null) {
            throw new IllegalArgumentException();
        }
        builder.append('<');
        builder.append(iri);
        builder.append('>');
    }

    private static void writeValue(StringBuilder builder, RdfValue object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (object.isIRI()) {
            NQuadSerializer.writeIri(builder, object.toString());
            return;
        }
        if (object.isLiteral()) {
            NQuadSerializer.write(builder, object.asLiteral());
            return;
        }
        if (object.isBlankNode()) {
            builder.append(object);
            return;
        }
        throw new IllegalStateException();
    }
}

