/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.identity;

import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.identity.IdentityColumnSupportImpl;

public class HSQLIdentityColumnSupport
extends IdentityColumnSupportImpl {
    private final DatabaseVersion dbVersion;

    public HSQLIdentityColumnSupport(DatabaseVersion dbVersion) {
        this.dbVersion = dbVersion;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public String getIdentityColumnString(int type) {
        return "generated by default as identity (start with 1)";
    }

    @Override
    public String getIdentitySelectString(String table, String column, int type) {
        return "call identity()";
    }

    @Override
    public String getIdentityInsertString() {
        return this.dbVersion.isBefore(2) ? "null" : "default";
    }
}

