/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.Profile;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.credential.UserCredentialManager;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.MembershipMetadata;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SubjectCredentialManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.entities.UserAttributeEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserGroupMembershipEntity;
import org.keycloak.models.jpa.entities.UserRequiredActionEntity;
import org.keycloak.models.jpa.entities.UserRoleMappingEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.representations.idm.MembershipType;
import org.keycloak.utils.StreamsUtil;

public class UserAdapter
implements UserModel,
JpaModel<UserEntity> {
    protected UserEntity user;
    protected EntityManager em;
    protected RealmModel realm;
    private final KeycloakSession session;

    public UserAdapter(KeycloakSession session, RealmModel realm, EntityManager em, UserEntity user) {
        this.em = em;
        this.user = user;
        this.realm = realm;
        this.session = session;
    }

    public UserEntity getEntity() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public void setUsername(String username) {
        username = KeycloakModelUtils.toLowerCaseSafe((String)username);
        this.user.setUsername(username);
    }

    public Long getCreatedTimestamp() {
        return this.user.getCreatedTimestamp();
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.user.setCreatedTimestamp(timestamp);
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
    }

    public void setSingleAttribute(String name, String value) {
        if ("firstName".equals(name)) {
            this.user.setFirstName(value);
            return;
        }
        if ("lastName".equals(name)) {
            this.user.setLastName(value);
            return;
        }
        if ("email".equals(name)) {
            this.setEmail(value);
            return;
        }
        if ("username".equals(name)) {
            this.setUsername(value);
            return;
        }
        if (value == null) {
            this.user.getAttributes().removeIf(a -> a.getName().equals(name));
        } else {
            Set<String> newEntries;
            Set oldEntries = this.getAttributeStream(name).collect(Collectors.toSet());
            if (CollectionUtil.collectionEquals(oldEntries, newEntries = Set.of(value))) {
                return;
            }
            String firstExistingAttrId = null;
            ArrayList<UserAttributeEntity> toRemove = new ArrayList<UserAttributeEntity>();
            for (UserAttributeEntity attr : this.user.getAttributes()) {
                if (!attr.getName().equals(name)) continue;
                if (firstExistingAttrId == null) {
                    attr.setValue(value);
                    firstExistingAttrId = attr.getId();
                    continue;
                }
                toRemove.add(attr);
            }
            if (firstExistingAttrId != null) {
                Query query = this.em.createNamedQuery("deleteUserAttributesByNameAndUserOtherThan");
                query.setParameter("name", (Object)name);
                query.setParameter("userId", (Object)this.user.getId());
                query.setParameter("attrId", (Object)firstExistingAttrId);
                int numUpdated = query.executeUpdate();
                this.user.getAttributes().removeAll(toRemove);
            } else {
                this.persistAttributeValue(name, value);
            }
        }
    }

    public void setAttribute(String name, List<String> values) {
        HashSet<Object> newEntries;
        String valueToSet;
        String string = valueToSet = values != null && !values.isEmpty() ? values.get(0) : null;
        if ("firstName".equals(name)) {
            this.user.setFirstName(valueToSet);
            return;
        }
        if ("lastName".equals(name)) {
            this.user.setLastName(valueToSet);
            return;
        }
        if ("email".equals(name)) {
            this.setEmail(valueToSet);
            return;
        }
        if ("username".equals(name)) {
            this.setUsername(valueToSet);
            return;
        }
        Set oldEntries = this.getAttributeStream(name).collect(Collectors.toSet());
        if (CollectionUtil.collectionEquals(oldEntries, newEntries = values == null ? new HashSet() : new HashSet<String>(values))) {
            return;
        }
        this.removeAttribute(name);
        if (values != null) {
            Iterator it = values.stream().filter(Objects::nonNull).iterator();
            while (it.hasNext()) {
                this.persistAttributeValue(name, (String)it.next());
            }
        }
    }

    private void persistAttributeValue(String name, String value) {
        UserAttributeEntity attr = new UserAttributeEntity();
        attr.setId(KeycloakModelUtils.generateId());
        attr.setName(name);
        attr.setValue(value);
        attr.setUser(this.user);
        this.em.persist((Object)attr);
        this.user.getAttributes().add(attr);
    }

    public void removeAttribute(String name) {
        ArrayList<UserAttributeEntity> customAttributesToRemove = new ArrayList<UserAttributeEntity>();
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            customAttributesToRemove.add(attr);
        }
        if (customAttributesToRemove.isEmpty()) {
            if ("firstName".equals(name)) {
                this.setFirstName(null);
            } else if ("lastName".equals(name)) {
                this.setLastName(null);
            } else if ("email".equals(name)) {
                this.setEmail(null);
            }
            return;
        }
        Query query = this.em.createNamedQuery("deleteUserAttributesByNameAndUser");
        query.setParameter("name", (Object)name);
        query.setParameter("userId", (Object)this.user.getId());
        query.executeUpdate();
        this.user.getAttributes().removeAll(customAttributesToRemove);
    }

    public String getFirstAttribute(String name) {
        if ("firstName".equals(name)) {
            return this.user.getFirstName();
        }
        if ("lastName".equals(name)) {
            return this.user.getLastName();
        }
        if ("email".equals(name)) {
            return this.user.getEmail();
        }
        if ("username".equals(name)) {
            return this.user.getUsername();
        }
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public Stream<String> getAttributeStream(String name) {
        if ("firstName".equals(name)) {
            return Stream.of(this.user.getFirstName());
        }
        if ("lastName".equals(name)) {
            return Stream.of(this.user.getLastName());
        }
        if ("email".equals(name)) {
            return Stream.of(this.user.getEmail());
        }
        if ("username".equals(name)) {
            return Stream.of(this.user.getUsername());
        }
        return this.user.getAttributes().stream().filter(attribute -> Objects.equals(attribute.getName(), name)).map(attribute -> attribute.getValue());
    }

    public Map<String, List<String>> getAttributes() {
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            result.add((Object)attr.getName(), (Object)attr.getValue());
        }
        result.add((Object)"firstName", (Object)this.user.getFirstName());
        result.add((Object)"lastName", (Object)this.user.getLastName());
        result.add((Object)"email", (Object)this.user.getEmail());
        result.add((Object)"username", (Object)this.user.getUsername());
        return result;
    }

    public Stream<String> getRequiredActionsStream() {
        return this.user.getRequiredActions().stream().map(action -> action.getAction()).distinct();
    }

    public void addRequiredAction(String actionName) {
        for (UserRequiredActionEntity attr : this.user.getRequiredActions()) {
            if (!attr.getAction().equals(actionName)) continue;
            return;
        }
        UserRequiredActionEntity attr = new UserRequiredActionEntity();
        attr.setAction(actionName);
        attr.setUser(this.user);
        this.em.persist((Object)attr);
        this.user.getRequiredActions().add(attr);
    }

    public void removeRequiredAction(String actionName) {
        Iterator<UserRequiredActionEntity> it = this.user.getRequiredActions().iterator();
        while (it.hasNext()) {
            UserRequiredActionEntity attr = it.next();
            if (!attr.getAction().equals(actionName)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        if (ObjectUtil.isBlank((CharSequence)email)) {
            email = null;
        }
        email = KeycloakModelUtils.toLowerCaseSafe((String)email);
        this.user.setEmail(email, this.realm.isDuplicateEmailsAllowed());
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
    }

    private TypedQuery<String> createGetGroupsQuery() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(UserGroupMembershipEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("user"), (Object)this.getEntity()));
        queryBuilder.select((Selection)root.get("groupId"));
        queryBuilder.where((Predicate[])predicates.toArray(Predicate[]::new));
        return this.em.createQuery(queryBuilder);
    }

    private TypedQuery<Long> createCountGroupsQuery() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(Long.class);
        Root root = queryBuilder.from(UserGroupMembershipEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("user"), (Object)this.getEntity()));
        queryBuilder.select((Selection)builder.count((Expression)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        return this.em.createQuery(queryBuilder);
    }

    public Stream<GroupModel> getGroupsStream() {
        return this.getGroupsStream(null, null, null);
    }

    public Stream<GroupModel> getGroupsStream(String search, Integer first, Integer max) {
        return this.session.groups().getGroupsStream(this.realm, StreamsUtil.closing((Stream)this.createGetGroupsQuery().getResultStream()), search, first, max);
    }

    public long getGroupsCount() {
        Long result = (Long)this.createCountGroupsQuery().getSingleResult();
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION) && result > 0L) {
            OrganizationProvider provider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
            result = result - provider.getByMember((UserModel)this).count();
        }
        return result;
    }

    public long getGroupsCountByNameContaining(String search) {
        if (search == null) {
            return this.getGroupsCount();
        }
        return this.session.groups().getGroupsCount(this.realm, StreamsUtil.closing((Stream)this.createGetGroupsQuery().getResultStream()), search);
    }

    public void joinGroup(GroupModel group) {
        this.joinGroup(group, null);
    }

    public void joinGroup(GroupModel group, MembershipMetadata metadata) {
        if (RoleUtils.isDirectMember(this.getGroupsStream(), (GroupModel)group)) {
            return;
        }
        this.joinGroupImpl(group, metadata);
    }

    protected void joinGroupImpl(GroupModel group) {
        this.joinGroupImpl(group, null);
    }

    protected void joinGroupImpl(GroupModel group, MembershipMetadata metadata) {
        UserGroupMembershipEntity entity = new UserGroupMembershipEntity();
        entity.setUser(this.getEntity());
        entity.setGroupId(group.getId());
        entity.setMembershipType(metadata == null ? MembershipType.UNMANAGED : metadata.getMembershipType());
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
        GroupModel.GroupMemberJoinEvent.fire((GroupModel)group, (UserModel)this, (KeycloakSession)this.session);
    }

    public void leaveGroup(GroupModel group) {
        if (this.user == null || group == null) {
            return;
        }
        TypedQuery<UserGroupMembershipEntity> query = this.getUserGroupMappingQuery(group);
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        List results = query.getResultList();
        if (results.isEmpty()) {
            return;
        }
        for (UserGroupMembershipEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
        GroupModel.GroupMemberLeaveEvent.fire((GroupModel)group, (KeycloakSession)this.session);
    }

    public boolean isMemberOf(GroupModel group) {
        return RoleUtils.isMember(this.getGroupsStream(), (GroupModel)group);
    }

    protected TypedQuery<UserGroupMembershipEntity> getUserGroupMappingQuery(GroupModel group) {
        TypedQuery query = this.em.createNamedQuery("userMemberOf", UserGroupMembershipEntity.class);
        query.setParameter("user", (Object)this.getEntity());
        query.setParameter("groupId", (Object)group.getId());
        return query;
    }

    public boolean hasRole(RoleModel role) {
        return RoleUtils.hasRole(this.getRoleMappingsStream(), (RoleModel)role) || RoleUtils.hasRoleFromGroup(this.getGroupsStream(), (RoleModel)role, (boolean)true);
    }

    protected TypedQuery<UserRoleMappingEntity> getUserRoleMappingEntityTypedQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("userHasRole", UserRoleMappingEntity.class);
        query.setParameter("user", (Object)this.getEntity());
        query.setParameter("roleId", (Object)role.getId());
        return query;
    }

    public void grantRole(RoleModel role) {
        if (this.hasDirectRole(role)) {
            return;
        }
        this.grantRoleImpl(role);
        RoleModel.RoleGrantedEvent.fire((RoleModel)role, (UserModel)this, (KeycloakSession)this.session);
    }

    public void grantRoleImpl(RoleModel role) {
        UserRoleMappingEntity entity = new UserRoleMappingEntity();
        entity.setUser(this.getEntity());
        entity.setRoleId(role.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public Stream<RoleModel> getRealmRoleMappingsStream() {
        return this.getRoleMappingsStream().filter(RoleUtils::isRealmRole);
    }

    public Stream<RoleModel> getRoleMappingsStream() {
        TypedQuery query = this.em.createNamedQuery("userRoleMappingIds", String.class);
        query.setParameter("user", (Object)this.getEntity());
        return StreamsUtil.closing(query.getResultStream().map(arg_0 -> ((RealmModel)this.realm).getRoleById(arg_0)).filter(Objects::nonNull));
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.user == null || role == null) {
            return;
        }
        TypedQuery<UserRoleMappingEntity> query = this.getUserRoleMappingEntityTypedQuery(role);
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        List results = query.getResultList();
        if (results.isEmpty()) {
            return;
        }
        for (UserRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
        RoleModel.RoleRevokedEvent.fire((RoleModel)role, (UserModel)this, (KeycloakSession)this.session);
    }

    public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
        return this.getRoleMappingsStream().filter(r -> RoleUtils.isClientRole((RoleModel)r, (ClientModel)app));
    }

    public String getFederationLink() {
        return this.user.getFederationLink();
    }

    public void setFederationLink(String link) {
        this.user.setFederationLink(link);
    }

    public String getServiceAccountClientLink() {
        return this.user.getServiceAccountClientLink();
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        this.user.setServiceAccountClientLink(clientInternalId);
    }

    public SubjectCredentialManager credentialManager() {
        return new UserCredentialManager(this.session, this.realm, (UserModel)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

