/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.sessions.infinispan.SessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.SessionsChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.changes.UserSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.EmbeddedClientSessionKey;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class UserSessionAdapter<T extends SessionRefreshStore & UserSessionProvider>
implements UserSessionModel {
    private static final Logger logger = Logger.getLogger(UserSessionAdapter.class);
    private final KeycloakSession session;
    private final T provider;
    private final SessionsChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx;
    private final SessionsChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionUpdateTx;
    private final RealmModel realm;
    private final UserModel user;
    private final UserSessionEntity entity;
    private final boolean offline;
    private UserSessionModel.SessionPersistenceState persistenceState;

    public UserSessionAdapter(KeycloakSession session, UserModel user, T provider, SessionsChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx, SessionsChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionUpdateTx, RealmModel realm, UserSessionEntity entity, boolean offline) {
        this.session = session;
        this.user = user;
        this.provider = provider;
        this.userSessionUpdateTx = userSessionUpdateTx;
        this.clientSessionUpdateTx = clientSessionUpdateTx;
        this.realm = realm;
        this.entity = entity;
        this.offline = offline;
    }

    public Map<String, AuthenticatedClientSessionModel> getAuthenticatedClientSessions() {
        Set<String> clientSessionEntities = this.entity.getClientSessions();
        HashMap result = new HashMap();
        LinkedList<String> removedClientUUIDS = new LinkedList<String>();
        clientSessionEntities.forEach(clientUUID -> {
            ClientModel client = this.realm.getClientById(clientUUID);
            if (client == null) {
                removedClientUUIDS.add((String)clientUUID);
                return;
            }
            AuthenticatedClientSessionModel clientSession = ((UserSessionProvider)this.provider).getClientSession((UserSessionModel)this, client, this.offline);
            if (clientSession == null) {
                return;
            }
            result.put(clientUUID, clientSession);
        });
        this.removeAuthenticatedClientSessions(removedClientUUIDS);
        return Collections.unmodifiableMap(result);
    }

    public AuthenticatedClientSessionModel getAuthenticatedClientSessionByClient(String clientUUID) {
        ClientModel client = this.realm.getClientById(clientUUID);
        if (client != null) {
            return ((UserSessionProvider)this.provider).getClientSession((UserSessionModel)this, client, this.offline);
        }
        logger.debugf("Client not found. Removing from mappings. userSessionId=%s, clientId=%s, clientSessionId=%s, offline=%s", new Object[]{this.getId(), clientUUID, new EmbeddedClientSessionKey(this.getId(), clientUUID), this.offline});
        this.removeAuthenticatedClientSessions(Collections.singleton(clientUUID));
        return null;
    }

    public void removeAuthenticatedClientSessions(final Collection<String> removedClientUUIDS) {
        if (removedClientUUIDS == null || removedClientUUIDS.isEmpty()) {
            return;
        }
        logger.debugf("Removing client sessions. clients=%s, offline=%s", removedClientUUIDS, (Object)this.offline);
        List<String> clientSessionUuids = removedClientUUIDS.stream().filter(this.entity.getClientSessions()::contains).toList();
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public void runUpdate(UserSessionEntity entity) {
                removedClientUUIDS.forEach(entity.getClientSessions()::remove);
            }

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }
        };
        this.update(task);
        clientSessionUuids.forEach(clientUUID -> this.clientSessionUpdateTx.addTask(new EmbeddedClientSessionKey(this.entity.getId(), (String)clientUUID), Tasks.removeSync(this.offline)));
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getBrokerSessionId() {
        return this.entity.getBrokerSessionId();
    }

    public String getBrokerUserId() {
        return this.entity.getBrokerUserId();
    }

    public UserModel getUser() {
        return this.user;
    }

    public String getLoginUsername() {
        if (this.entity.getLoginUsername() == null) {
            return this.getUser().getUsername();
        }
        return this.entity.getLoginUsername();
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public boolean isRememberMe() {
        return this.entity.isRememberMe();
    }

    public int getStarted() {
        return this.entity.getStarted();
    }

    public int getLastSessionRefresh() {
        return this.entity.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(final int lastSessionRefresh) {
        if (lastSessionRefresh <= this.entity.getLastSessionRefresh()) {
            return;
        }
        if (!MultiSiteUtils.isPersistentSessionsEnabled() && this.offline) {
            this.provider.getPersisterLastSessionRefreshStore().putLastSessionRefresh(this.session, this.entity.getId(), this.realm.getId(), lastSessionRefresh);
        }
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public void runUpdate(UserSessionEntity entity) {
                if (entity.getLastSessionRefresh() >= lastSessionRefresh) {
                    return;
                }
                entity.setLastSessionRefresh(lastSessionRefresh);
            }

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }

            public String toString() {
                return "setLastSessionRefresh(" + lastSessionRefresh + ")";
            }
        };
        this.update(task);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public String getNote(String name) {
        return this.entity.getNotes() != null ? this.entity.getNotes().get(name) : null;
    }

    public void setNote(final String name, final String value) {
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public void runUpdate(UserSessionEntity entity) {
                if (value == null) {
                    if (entity.getNotes().containsKey(name)) {
                        UserSessionAdapter.this.removeNote(name);
                    }
                    return;
                }
                entity.getNotes().put(name, value);
            }

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }
        };
        this.update(task);
    }

    public void removeNote(final String name) {
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public void runUpdate(UserSessionEntity entity) {
                entity.getNotes().remove(name);
            }

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }
        };
        this.update(task);
    }

    public Map<String, String> getNotes() {
        return this.entity.getNotes();
    }

    public UserSessionModel.State getState() {
        return this.entity.getState();
    }

    public void setState(final UserSessionModel.State state) {
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }

            @Override
            public void runUpdate(UserSessionEntity entity) {
                entity.setState(state);
            }
        };
        this.update(task);
    }

    public UserSessionModel.SessionPersistenceState getPersistenceState() {
        return this.persistenceState;
    }

    public void setPersistenceState(UserSessionModel.SessionPersistenceState persistenceState) {
        this.persistenceState = persistenceState;
    }

    public void restartSession(final RealmModel realm, final UserModel user, final String loginUsername, final String ipAddress, final String authMethod, final boolean rememberMe, final String brokerSessionId, final String brokerUserId) {
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }

            @Override
            public void runUpdate(UserSessionEntity entity) {
                UserSessionEntity.updateSessionEntity(entity, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
                entity.setState(null);
                entity.getNotes().clear();
                entity.getClientSessions().clear();
            }
        };
        this.update(task);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public UserSessionEntity getEntity() {
        return this.entity;
    }

    void update(UserSessionUpdateTask task) {
        this.userSessionUpdateTx.addTask(this.getId(), task);
    }
}

