/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowProvider;
import org.keycloak.models.workflow.WorkflowsManager;

public class EventBasedWorkflowProvider
implements WorkflowProvider {
    private final KeycloakSession session;
    private final ComponentModel model;
    private final WorkflowsManager manager;

    public EventBasedWorkflowProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.model = model;
        this.manager = new WorkflowsManager(session);
    }

    public List<String> getEligibleResourcesForInitialStep() {
        return List.of();
    }

    public boolean supports(ResourceType type) {
        return ResourceType.USERS.equals((Object)type);
    }

    public boolean activateOnEvent(WorkflowEvent event) {
        if (!this.supports(event.getResourceType())) {
            return false;
        }
        if (!this.isActivationEvent(event)) {
            return false;
        }
        return this.evaluate(event);
    }

    public boolean deactivateOnEvent(WorkflowEvent event) {
        if (!this.supports(event.getResourceType())) {
            return false;
        }
        List events = (List)this.model.getConfig().getOrDefault((Object)"on", List.of());
        for (String activationEvent : events) {
            ResourceOperationType a = ResourceOperationType.valueOf((String)activationEvent);
            if (!a.isDeactivationEvent(event.getEvent().getClass())) continue;
            return !this.evaluate(event);
        }
        return false;
    }

    public boolean resetOnEvent(WorkflowEvent event) {
        return this.isResetEvent(event) && this.evaluate(event);
    }

    public void close() {
    }

    protected boolean evaluate(WorkflowEvent event) {
        List conditions = (List)this.getModel().getConfig().getOrDefault((Object)"conditions", List.of());
        for (String providerId : conditions) {
            WorkflowConditionProvider condition = this.manager.getConditionProvider(providerId, this.model.getConfig());
            if (condition.evaluate(event)) continue;
            return false;
        }
        return true;
    }

    protected boolean isActivationEvent(WorkflowEvent event) {
        ResourceOperationType operation = event.getOperation();
        if (ResourceOperationType.AD_HOC.equals((Object)operation)) {
            return true;
        }
        List events = (List)this.model.getConfig().getOrDefault((Object)"on", List.of());
        return events.contains(operation.name());
    }

    protected ComponentModel getModel() {
        return this.model;
    }

    protected KeycloakSession getSession() {
        return this.session;
    }

    protected WorkflowsManager getManager() {
        return this.manager;
    }

    protected boolean isResetEvent(WorkflowEvent event) {
        return ((List)this.model.getConfig().getOrDefault((Object)"reset-on", List.of())).contains(event.getOperation().name());
    }
}

