/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.query.hql.HqlInterpretationException;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddableDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public class SqmLiteralEmbeddableType<T>
extends AbstractSqmExpression<T>
implements SqmSelectableNode<T>,
SemanticPathPart {
    final SqmEmbeddableDomainType<T> embeddableDomainType;

    public SqmLiteralEmbeddableType(SqmEmbeddableDomainType<T> embeddableDomainType, NodeBuilder nodeBuilder) {
        super(DiscriminatorHelper.getDiscriminatorType(embeddableDomainType, nodeBuilder), nodeBuilder);
        this.embeddableDomainType = embeddableDomainType;
    }

    public EmbeddableDomainType<T> getEmbeddableDomainType() {
        return this.embeddableDomainType;
    }

    @Override
    public SqmLiteralEmbeddableType<T> copy(SqmCopyContext context) {
        SqmLiteralEmbeddableType existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmLiteralEmbeddableType<T> expression = context.registerCopy(this, new SqmLiteralEmbeddableType<T>(this.embeddableDomainType, (NodeBuilder)this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public void internalApplyInferableType(SqmBindableType<?> type) {
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEmbeddableTypeLiteralExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "TYPE(" + String.valueOf(this.embeddableDomainType) + ")";
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new HqlInterpretationException("Cannot dereference an embeddable name");
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        throw new HqlInterpretationException("Cannot dereference an embeddable name");
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append(this.embeddableDomainType.getTypeName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmLiteralEmbeddableType)) return false;
        SqmLiteralEmbeddableType that = (SqmLiteralEmbeddableType)object;
        if (!Objects.equals(this.embeddableDomainType.getTypeName(), that.embeddableDomainType.getTypeName())) return false;
        return true;
    }

    public int hashCode() {
        return this.embeddableDomainType.getTypeName().hashCode();
    }
}

