/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.kubernetes.spi.Targetable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class KubernetesInitContainerBuildItem
extends MultiBuildItem
implements Targetable {
    private static final String DEFAULT_IMAGE_PULL_POLICY = "Always";
    private final String name;
    private final String target;
    private final String image;
    private final String imagePullPolicy;
    private final List<String> command;
    private final List<String> arguments;
    private final Map<String, String> envVars;
    private final boolean sharedEnvironment;
    private final boolean sharedFilesystem;

    public static KubernetesInitContainerBuildItem create(String name, String image) {
        return KubernetesInitContainerBuildItem.create(name, image, DEFAULT_IMAGE_PULL_POLICY);
    }

    public static KubernetesInitContainerBuildItem create(String name, String image, String imagePullPolicy) {
        return new KubernetesInitContainerBuildItem(name, null, image, DEFAULT_IMAGE_PULL_POLICY, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), false, false);
    }

    @Deprecated(forRemoval=true, since="3.18")
    public KubernetesInitContainerBuildItem(String name, String target, String image, List<String> command, List<String> arguments, Map<String, String> envVars, boolean sharedEnvironment, boolean sharedFilesystem) {
        this(name, target, image, DEFAULT_IMAGE_PULL_POLICY, command, arguments, envVars, sharedEnvironment, sharedFilesystem);
    }

    private KubernetesInitContainerBuildItem(String name, String target, String image, String imagePullPolicy, List<String> command, List<String> arguments, Map<String, String> envVars, boolean sharedEnvironment, boolean sharedFilesystem) {
        this.name = name;
        this.target = target;
        this.image = image;
        this.imagePullPolicy = imagePullPolicy;
        this.command = command;
        this.arguments = arguments;
        this.envVars = envVars;
        this.sharedEnvironment = sharedEnvironment;
        this.sharedFilesystem = sharedFilesystem;
    }

    public String getName() {
        return this.name;
    }

    public KubernetesInitContainerBuildItem withName(String name) {
        return new KubernetesInitContainerBuildItem(name, this.target, this.image, this.imagePullPolicy, this.command, this.arguments, this.envVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    public KubernetesInitContainerBuildItem withTarget(String target) {
        return new KubernetesInitContainerBuildItem(this.name, target, this.image, this.imagePullPolicy, this.command, this.arguments, this.envVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public String getImage() {
        return this.image;
    }

    public KubernetesInitContainerBuildItem withImage(String image) {
        return new KubernetesInitContainerBuildItem(this.name, this.target, image, this.imagePullPolicy, this.command, this.arguments, this.envVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public KubernetesInitContainerBuildItem withImagePullPolicy(String imagePullPolicy) {
        return new KubernetesInitContainerBuildItem(this.name, this.target, this.image, imagePullPolicy, this.command, this.arguments, this.envVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public List<String> getCommand() {
        return this.command;
    }

    public KubernetesInitContainerBuildItem withCommand(List<String> command) {
        return new KubernetesInitContainerBuildItem(this.name, this.target, this.image, this.imagePullPolicy, command, this.arguments, this.envVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public KubernetesInitContainerBuildItem withArguments(List<String> arguments) {
        return new KubernetesInitContainerBuildItem(this.name, this.target, this.image, this.imagePullPolicy, this.command, arguments, this.envVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public KubernetesInitContainerBuildItem withEnvVars(Map<String, String> envVars) {
        return new KubernetesInitContainerBuildItem(this.name, this.target, this.image, this.imagePullPolicy, this.command, this.arguments, envVars, this.sharedEnvironment, this.sharedFilesystem);
    }

    public boolean isSharedEnvironment() {
        return this.sharedEnvironment;
    }

    public KubernetesInitContainerBuildItem withSharedEnvironment(boolean sharedEnvironment) {
        return new KubernetesInitContainerBuildItem(this.name, this.target, this.image, this.imagePullPolicy, this.command, this.arguments, this.envVars, sharedEnvironment, this.sharedFilesystem);
    }

    public boolean isSharedFilesystem() {
        return this.sharedFilesystem;
    }

    public KubernetesInitContainerBuildItem withSharedFilesystem(boolean sharedFilesystem) {
        return new KubernetesInitContainerBuildItem(this.name, this.target, this.image, this.imagePullPolicy, this.command, this.arguments, this.envVars, this.sharedEnvironment, sharedFilesystem);
    }
}

