/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.kafka.common.TopicIdPartition;

public interface PartitionMaxBytesStrategy {
    public LinkedHashMap<TopicIdPartition, Integer> maxBytes(int var1, Set<TopicIdPartition> var2, int var3);

    public static PartitionMaxBytesStrategy type(StrategyType type) {
        if (type == null) {
            throw new IllegalArgumentException("Strategy type cannot be null");
        }
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UNIFORM: 
        }
        return PartitionMaxBytesStrategy::uniformPartitionMaxBytes;
    }

    private static LinkedHashMap<TopicIdPartition, Integer> uniformPartitionMaxBytes(int requestMaxBytes, Set<TopicIdPartition> partitions, int acquiredPartitionsSize) {
        PartitionMaxBytesStrategy.checkValidArguments(requestMaxBytes, partitions, acquiredPartitionsSize);
        LinkedHashMap<TopicIdPartition, Integer> partitionMaxBytes = new LinkedHashMap<TopicIdPartition, Integer>();
        partitions.forEach(partition -> partitionMaxBytes.put((TopicIdPartition)partition, requestMaxBytes / acquiredPartitionsSize));
        return partitionMaxBytes;
    }

    public static void checkValidArguments(int requestMaxBytes, Set<TopicIdPartition> partitions, int acquiredPartitionsSize) {
        if (partitions == null || partitions.isEmpty()) {
            throw new IllegalArgumentException("Partitions to generate max bytes is null or empty");
        }
        if (requestMaxBytes <= 0) {
            throw new IllegalArgumentException("Request max bytes must be greater than 0");
        }
        if (acquiredPartitionsSize <= 0) {
            throw new IllegalArgumentException("Acquired partitions size must be greater than 0");
        }
    }

    public static enum StrategyType {
        UNIFORM;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

