/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.antlr.AntlrTask;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class AntlrSpecFactory {
    public AntlrSpec create(AntlrTask antlrTask, Set<File> grammarFiles, FileCollection sourceSetDirectories) {
        File outputDirectory = antlrTask.getOutputDirectory();
        LinkedList arguments = Lists.newLinkedList(antlrTask.getArguments());
        if (antlrTask.isTrace() && !arguments.contains("-trace")) {
            arguments.add("-trace");
        }
        if (antlrTask.isTraceLexer() && !arguments.contains("-traceLexer")) {
            arguments.add("-traceLexer");
        }
        if (antlrTask.isTraceParser() && !arguments.contains("-traceParser")) {
            arguments.add("-traceParser");
        }
        if (antlrTask.isTraceTreeWalker() && !arguments.contains("-traceTreeWalker")) {
            arguments.add("-traceTreeWalker");
        }
        if (antlrTask.getArguments().contains("-package")) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)"Setting the '-package' argument directly on AntlrTask").withAdvice("Use the 'packageName' property of the AntlrTask to specify the package name instead of using the '-package' argument.")).willBecomeAnErrorInGradle10().withDslReference(AntlrTask.class, "packageName")).nagUser();
        }
        if (antlrTask.getPackageName().isPresent()) {
            if (!arguments.contains("-package")) {
                arguments.add("-package");
                arguments.add((String)antlrTask.getPackageName().get());
                outputDirectory = new File(outputDirectory, ((String)antlrTask.getPackageName().get()).replace('.', '/'));
            } else {
                throw new IllegalStateException("The package has been set both in the arguments (i.e. '-package') and via the 'packageName' property.  Please set the package only using the 'packageName' property.");
            }
        }
        Set sourceSetDirectoriesFiles = sourceSetDirectories == null ? Collections.emptySet() : sourceSetDirectories.getFiles();
        return new AntlrSpec(arguments, grammarFiles, sourceSetDirectoriesFiles, outputDirectory, antlrTask.getMaxHeapSize());
    }
}

