/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

class KeyHasher<K> {
    private final Serializer<K> serializer;
    private final MessageDigestStream digestStream = new MessageDigestStream();
    private final KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)this.digestStream);

    public KeyHasher(Serializer<K> serializer) {
        this.serializer = serializer;
    }

    long getHashCode(K key) throws Exception {
        this.serializer.write((Encoder)this.encoder, key);
        this.encoder.flush();
        return this.digestStream.getChecksum();
    }

    private static class MessageDigestStream
    extends OutputStream {
        MessageDigest messageDigest;

        private MessageDigestStream() {
            try {
                this.messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.messageDigest.update((byte)b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.messageDigest.update(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.messageDigest.update(b, off, len);
        }

        long getChecksum() {
            byte[] digest = this.messageDigest.digest();
            assert (digest.length == 16);
            return new BigInteger(digest).longValue();
        }
    }
}

