/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GuiGridLayout {
    private final GridBagLayout _layout;
    private final GridBagConstraints _constraints;
    private final JPanel _panel;
    private final int _numColumns;
    private double[] _colWeights = null;
    private boolean[] _rightAligns = null;
    private int _x = 0;
    private int _y = 0;

    public GuiGridLayout(JPanel jPanel) {
        this(jPanel, null, null);
    }

    public GuiGridLayout(JPanel jPanel, double[] dArray, boolean[] blArray) {
        this._panel = jPanel;
        this._layout = new GridBagLayout();
        this._constraints = new GridBagConstraints();
        this._colWeights = dArray;
        this._rightAligns = blArray;
        if (this._colWeights == null || this._rightAligns == null || this._colWeights.length != this._rightAligns.length || this._colWeights.length < 2) {
            this._colWeights = new double[]{0.5, 1.0};
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = true;
            this._rightAligns = blArray2;
        }
        this._numColumns = this._colWeights.length;
        this._constraints.weightx = 1.0;
        this._constraints.weighty = 0.0;
        this._constraints.ipadx = 10;
        this._constraints.ipady = 1;
        this._constraints.insets = new Insets(1, 5, 1, 5);
        this._panel.setLayout(this._layout);
    }

    public void setYPadding(int n) {
        this._constraints.ipady = n;
    }

    public void add(JComponent jComponent) {
        this.add(jComponent, 1, false);
    }

    public void add(JComponent jComponent, boolean bl) {
        this.add(jComponent, 1, bl);
    }

    public void add(JComponent jComponent, int n, boolean bl) {
        this._constraints.gridx = this._x;
        this._constraints.gridy = this._y;
        this._constraints.weightx = this._colWeights[this._x];
        this._constraints.gridwidth = n;
        this._constraints.anchor = this._rightAligns[this._x] ? 22 : 21;
        this._constraints.fill = bl ? 2 : 0;
        this._layout.setConstraints(jComponent, this._constraints);
        this._panel.add(jComponent);
        this._x += n;
        if (this._x >= this._numColumns) {
            this.nextRow();
        }
    }

    public void nextRow() {
        this._x = 0;
        ++this._y;
    }

    public void addVerticalGap(int n) {
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(10, n));
        this.add(jLabel);
        this.nextRow();
    }
}

