/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.RGBColorValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class LABColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.LABColorValue {
    private static final long serialVersionUID = 2L;
    private final LABColorImpl labColor;

    public LABColorValue() {
        this(new LABColorImpl(BaseColor.Space.CIE_Lab, "lab"));
    }

    LABColorValue(LABColorImpl color) {
        this.labColor = color;
    }

    LABColorValue(LABColorValue copied) {
        super(copied);
        this.labColor = copied.labColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LAB;
    }

    @Override
    void set(StyleValue value) {
        super.set(value);
        LABColorValue setfrom = (LABColorValue)value;
        this.labColor.set(setfrom.labColor);
    }

    @Override
    public String getCssText() {
        return this.labColor.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyValue) {
        return this.labColor.toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        this.labColor.writeCssText(wri);
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        return this.labColor.item(index);
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        this.labColor.setComponent(index, (PrimitiveValue)component);
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean clamp) throws DOMException {
        double[] rgb = this.labColor.toSRGB(clamp);
        ColorValue.CSSRGBColor color = new ColorValue.CSSRGBColor();
        color.setColorComponents(rgb);
        color.setAlpha(this.labColor.getAlpha().clone());
        return color;
    }

    @Override
    public LABColorValue toLABColorValue() {
        return this;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        if (!this.labColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float a = ((CSSTypedValue)((Object)this.labColor.getA())).getFloatValue((short)0);
        float b = ((CSSTypedValue)((Object)this.labColor.getB())).getFloatValue((short)0);
        float c = (float)Math.sqrt(a * a + b * b);
        float h = (float)(Math.atan2(b, a) * 180.0 / Math.PI);
        if (h < 0.0f) {
            h += 360.0f;
        }
        NumberValue chroma = NumberValue.createCSSNumberValue((short)0, c);
        NumberValue hue = NumberValue.createCSSNumberValue((short)80, h);
        chroma.setAbsolutizedUnit();
        hue.setAbsolutizedUnit();
        LCHColorValue lch = new LCHColorValue();
        lch.setComponent(0, this.labColor.getAlpha().clone());
        lch.setComponent(1, this.labColor.getLightness().clone());
        lch.setComponent(2, chroma);
        lch.setComponent(3, hue);
        return lch;
    }

    @Override
    public LABColor getColor() {
        return this.labColor;
    }

    LABColorImpl getLABColorImpl() {
        return this.labColor;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.labColor.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue color) {
        LABColor lab;
        if (!this.labColor.hasConvertibleComponents() || !((ColorValue)color).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (color.getColorModel()) {
            case LAB: {
                lab = (LABColor)color.getColor();
                if (!"oklab".equals(lab.getColorSpace())) break;
                lab = color.toLABColorValue().getColor();
                break;
            }
            case LCH: {
                lab = color.toLABColorValue().getColor();
                break;
            }
            case RGB: {
                RGBColor rgbcolor = (RGBColor)color.getColor();
                LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                rgbcolor.toLABColor(labColor);
                lab = labColor;
                break;
            }
            case XYZ: {
                XYZColorImpl xyz = (XYZColorImpl)color.getColor();
                LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                xyz.toLABColor(labColor);
                lab = labColor;
                break;
            }
            default: {
                RGBAColor rgb = color.toRGBColor(false);
                RGBColorValue rgbValue = new RGBColorValue();
                rgbValue.setComponent(0, (StyleValue)((Object)rgb.getAlpha()));
                rgbValue.setComponent(1, (StyleValue)((Object)rgb.getRed()));
                rgbValue.setComponent(2, (StyleValue)((Object)rgb.getGreen()));
                rgbValue.setComponent(3, (StyleValue)((Object)rgb.getBlue()));
                lab = rgbValue.toLABColorValue().getColor();
            }
        }
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)((Object)this.labColor.getLightness())).getFloatValue((short)0), ((CSSTypedValue)((Object)this.labColor.getA())).getFloatValue((short)0), ((CSSTypedValue)((Object)this.labColor.getB())).getFloatValue((short)0), ((CSSTypedValue)lab.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lab.getA()).getFloatValue((short)0), ((CSSTypedValue)lab.getB()).getFloatValue((short)0));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.labColor.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LABColorValue other = (LABColorValue)obj;
        return this.labColor.equals(other.labColor);
    }

    @Override
    public LABColorValue clone() {
        return new LABColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(LABColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            try {
                if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.LABCOLOR) {
                    throw new DOMException(13, "No lab() value: " + lunit.toString());
                }
                this.setLexicalLAB(lunit);
            }
            catch (DOMException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DOMException(12, "Bad value: " + lunit.toString());
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void setLexicalLAB(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            PrimitiveValue primilight = factory.createCSSPrimitiveValue(lu, true);
            lu = lu.getNextLexicalUnit();
            PrimitiveValue primia = factory.createCSSPrimitiveValue(lu, true);
            lu = lu.getNextLexicalUnit();
            PrimitiveValue primib = factory.createCSSPrimitiveValue(lu, true);
            if ((lu = lu.getNextLexicalUnit()) != null) {
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    throw new DOMException(12, "Expected slash in: " + lunit.toString());
                }
                lu = lu.getNextLexicalUnit();
                PrimitiveValue alpha = factory.createCSSPrimitiveValue(lu, true);
                LABColorValue.this.labColor.setAlpha(alpha);
                lu = lu.getNextLexicalUnit();
                if (lu != null) {
                    throw new DOMException(12, "Bad value: " + lunit.toString());
                }
            }
            LABColorValue.this.labColor.setLightness(primilight);
            LABColorValue.this.labColor.setA(primia);
            LABColorValue.this.labColor.setB(primib);
        }
    }
}

