/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorFunction;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.DOMException;

class BaseProfiledColor
extends BaseColor {
    private static final long serialVersionUID = 1L;
    private String profileName;
    private PrimitiveValue[] components;

    BaseProfiledColor(String colorSpace) {
        this(colorSpace, new PrimitiveValue[0]);
    }

    BaseProfiledColor(String colorSpace, PrimitiveValue[] components) {
        this.profileName = colorSpace;
        this.components = components;
    }

    BaseProfiledColor(BaseProfiledColor copyMe) {
        this.alpha = copyMe.alpha.clone();
        this.profileName = copyMe.profileName;
        this.components = new PrimitiveValue[copyMe.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = copyMe.components[i].clone();
        }
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.PROFILE;
    }

    @Override
    public String getColorSpace() {
        return this.profileName;
    }

    @Override
    BaseColor.Space getSpace() {
        return BaseColor.Space.OTHER;
    }

    @Override
    void set(BaseColor color) {
        super.set(color);
        BaseProfiledColor setfrom = (BaseProfiledColor)color;
        if (setfrom.components.length != this.components.length) {
            throw new DOMException(13, "This value can only be set to a color in the " + (Object)((Object)this.getColorModel()) + " color model with " + this.components.length + " components.");
        }
        this.components = new PrimitiveValue[setfrom.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = setfrom.components[i].clone();
        }
        this.profileName = color.getColorSpace();
    }

    @Override
    public PrimitiveValue item(int index) {
        if (index == 0) {
            return this.getAlpha();
        }
        try {
            return this.components[index - 1];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int getLength() {
        return this.components.length + 1;
    }

    @Override
    public boolean hasConvertibleComponents() {
        for (PrimitiveValue comp : this.components) {
            if (BaseProfiledColor.isConvertibleComponent(comp)) continue;
            return false;
        }
        return true;
    }

    @Override
    void setComponent(int index, PrimitiveValue component) {
        if (index == 0) {
            this.setAlpha(component);
        } else {
            try {
                this.components[index - 1] = component;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    void setColorComponents(double[] components) {
        int i;
        if (components.length > this.components.length) {
            this.components = new PrimitiveValue[components.length];
        }
        for (i = 0; i < components.length; ++i) {
            double comp = components[i];
            NumberValue c = new NumberValue();
            c.setFloatValue((short)0, (float)comp);
            c.setSubproperty(true);
            c.setAbsolutizedUnit();
            c.setMaximumFractionDigits(6);
            this.components[i] = c;
        }
        for (i = components.length; i < this.components.length; ++i) {
            NumberValue c = NumberValue.createCSSNumberValue((short)0, 0.0f);
            c.setSubproperty(true);
            this.components[i] = c;
        }
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] comps = new double[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            comps[i] = ColorUtil.floatNumber((TypedValue)this.components[i]);
        }
        return comps;
    }

    @Override
    double[] toSRGB(boolean clamp) {
        throw new DOMException(9, "Cannot convert profiled colors.");
    }

    @Override
    public double[] toXYZ(Illuminant white) {
        throw new DOMException(9, "Cannot convert profiled colors.");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.components);
        result = 31 * result + Objects.hash(this.profileName);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseProfiledColor other = (BaseProfiledColor)obj;
        return Arrays.equals(this.components, other.components) && Objects.equals(this.profileName, other.profileName);
    }

    @Override
    public ColorValue packInValue() {
        return new ColorFunction(this);
    }

    @Override
    public BaseProfiledColor clone() {
        return new BaseProfiledColor(this);
    }
}

