/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.LexicalValue;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class TextDecorationManager
extends AbstractValueManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 18;
    }

    @Override
    public String getPropertyName() {
        return "text-decoration";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                ListValue listValue = new ListValue(' ');
                LexicalUnit lexicalUnit2 = lexicalUnit;
                do {
                    switch (lexicalUnit2.getLexicalUnitType()) {
                        case IDENT: {
                            String string = lexicalUnit2.getStringValue().toLowerCase(Locale.ROOT).intern();
                            Object object = values.get(string);
                            if (object == null) {
                                throw this.createInvalidIdentifierDOMException(lexicalUnit2.getStringValue());
                            }
                            listValue.append((Value)object);
                            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                            break;
                        }
                        case VAR: 
                        case ATTR: {
                            return new LexicalValue(lexicalUnit);
                        }
                        default: {
                            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                        }
                    }
                } while (lexicalUnit2 != null);
                return listValue;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return new LexicalValue(lexicalUnit);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String string, CSSEngine cSSEngine) throws DOMException {
        if (type != CSSValue.Type.IDENT) {
            throw this.createInvalidStringTypeDOMException(type);
        }
        if (!string.equalsIgnoreCase("none")) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        return ValueConstants.NONE_VALUE;
    }

    static {
        values.put("blink", ValueConstants.BLINK_VALUE);
        values.put("line-through", ValueConstants.LINE_THROUGH_VALUE);
        values.put("overline", ValueConstants.OVERLINE_VALUE);
        values.put("underline", ValueConstants.UNDERLINE_VALUE);
    }
}

