/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.common.os.Clock;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.GlyphShape;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class AnimGroup
extends Group {
    private static final boolean DEBUG = false;
    public static final float POS_EPS = 5.9604645E-4f;
    public static final float ROT_EPS = FloatUtil.adegToRad(0.5f);
    private volatile long tstart_us = 0L;
    private volatile long tlast_us = 0L;
    private volatile long tpause_us = 0L;
    private volatile float fixed_frame_period = 0.0f;
    private volatile float duration_s = 0.0f;
    private volatile boolean tickOnDraw = true;
    private volatile boolean tickPaused = false;
    private long frame_count = 0L;
    private final List<Set> animSets = new ArrayList<Set>();

    public AnimGroup(Group.Layout layout) {
        super(layout);
    }

    public Set getAnimSet(int n) {
        if (n < this.animSets.size()) {
            return this.animSets.get(n);
        }
        return null;
    }

    public final void removeAllAnimSets(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        for (Set set : this.animSets) {
            set.remove(this, gL2ES2, regionRenderer);
        }
        this.animSets.clear();
    }

    public final void removeAnimSet(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Set set) {
        if (null != set) {
            set.remove(this, gL2ES2, regionRenderer);
            this.animSets.remove(set);
        }
    }

    public final void removeAnimSets(GL2ES2 gL2ES2, RegionRenderer regionRenderer, List<Set> list) {
        for (Set set : list) {
            if (null == set) continue;
            set.remove(this, gL2ES2, regionRenderer);
            this.animSets.remove(set);
        }
    }

    public Set addAnimSet(float f, GLProfile gLProfile, PMVMatrix4f pMVMatrix4f, Recti recti, float f2, float f3, float f4, float f5, LerpFunc lerpFunc, Shape shape) {
        shape.validate(gLProfile);
        pMVMatrix4f.pushMv();
        shape.applyMatToMv(pMVMatrix4f);
        Set set = new Set(f, shape.getPixelPerShapeUnit(pMVMatrix4f, recti, new float[2]), shape, f2, f3, f4, f5, new ArrayList(), new AABBox(), lerpFunc);
        pMVMatrix4f.popMv();
        this.animSets.add(set);
        return set;
    }

    public final Set addGlyphSet(float f, GLProfile gLProfile, PMVMatrix4f pMVMatrix4f, Recti recti, int n, Font font, char c, CharSequence charSequence, float f2, float f3, float f4, float f5, float f6, LerpFunc lerpFunc, ShapeSetup shapeSetup) {
        ArrayList<ShapeData> arrayList = new ArrayList<ShapeData>();
        Object object = AnimGroup.processString(arrayList, n, font, f2, charSequence);
        GlyphShape glyphShape = new GlyphShape(n, font, c, 0.0f, 0.0f);
        glyphShape.setScale(f2, f2, 1.0f);
        glyphShape.validate(gLProfile);
        pMVMatrix4f.pushMv();
        glyphShape.applyMatToMv(pMVMatrix4f);
        Set set = new Set(f, glyphShape.getPixelPerShapeUnit(pMVMatrix4f, recti, new float[2]), glyphShape, f3, f4, f5, f6, arrayList, (AABBox)object, lerpFunc);
        pMVMatrix4f.popMv();
        this.animSets.add(set);
        for (int i = 0; i < set.allShapes.size(); ++i) {
            object = set.allShapes.get(i);
            shapeSetup.setup(set, i, (ShapeData)object);
            super.addShape(((ShapeData)object).shape);
        }
        this.resetAnimation();
        return set;
    }

    private static final AABBox processString(final List<ShapeData> list, final int n, Font font, final float f, CharSequence charSequence) {
        Font.GlyphVisitor glyphVisitor = new Font.GlyphVisitor(){

            @Override
            public void visit(Font.Glyph glyph, AffineTransform affineTransform) {
                if (!glyph.isNonContour()) {
                    GlyphShape glyphShape = new GlyphShape(n, glyph, affineTransform.getTranslateX(), affineTransform.getTranslateY());
                    glyphShape.setScale(f, f, 1.0f);
                    glyphShape.moveTo(glyphShape.getOrigPos().x() * f, glyphShape.getOrigPos().y() * f, glyphShape.getOrigPos().z());
                    list.add(new ShapeData(glyphShape));
                }
            }
        };
        return font.processString(glyphVisitor, null, charSequence, new AffineTransform(), new AffineTransform());
    }

    public final Set addGlyphSetRandom01(float f, GLProfile gLProfile, PMVMatrix4f pMVMatrix4f, Recti recti, int n2, Font font, CharSequence charSequence, float f2, Vec4f vec4f, float f3, float f4, float f5, float f6, AABBox aABBox, boolean bl, Random random, LerpFunc lerpFunc) {
        return this.addGlyphSet(f, gLProfile, pMVMatrix4f, recti, n2, font, 'X', charSequence, f2, f3, f4, f5, f6, lerpFunc, (set, n, shapeData) -> {
            shapeData.shape.setColor(vec4f);
            shapeData.targetPos.add(aABBox.getMinX(), 0.0f, 0.0f);
            Vec3f vec3f = shapeData.targetPos;
            shapeData.startPos.set(bl ? vec3f.x() : aABBox.getMinX() + random.nextFloat() * aABBox.getWidth(), bl ? vec3f.y() : aABBox.getMinY() + random.nextFloat() * aABBox.getHeight(), 0.0f + random.nextFloat() * aABBox.getHeight() * 1.0f);
            shapeData.shape.moveTo(shapeData.startPos);
        });
    }

    public final Set addGlyphSetHorizScroll01(float f, GLProfile gLProfile, PMVMatrix4f pMVMatrix4f, Recti recti, int n2, Font font, CharSequence charSequence, float f2, Vec4f vec4f, float f3, AABBox aABBox, float f4) {
        return this.addGlyphSet(f, gLProfile, pMVMatrix4f, recti, n2, font, 'X', charSequence, f2, 0.0f, f3, 0.0f, 0.0f, new ScrollLerp(aABBox), (set, n, shapeData) -> {
            shapeData.shape.setColor(vec4f);
            shapeData.targetPos.set(aABBox.getMinX(), f4, 0.0f);
            shapeData.startPos.set(shapeData.startPos.x() + aABBox.getMaxX(), shapeData.targetPos.y(), shapeData.targetPos.z());
            shapeData.shape.moveTo(shapeData.startPos);
        });
    }

    public final void setTickOnDraw(boolean bl) {
        this.tickOnDraw = bl;
    }

    public final boolean getTickOnDraw() {
        return this.tickOnDraw;
    }

    public final void setTickPaused(boolean bl) {
        if (this.tickPaused == bl) {
            return;
        }
        if (bl) {
            this.tickPaused = true;
            this.tpause_us = Clock.currentNanos() / 1000L;
        } else {
            long l = Clock.currentNanos() / 1000L;
            long l2 = l - this.tpause_us;
            this.tstart_us += l2;
            this.tlast_us += l2;
            this.tickPaused = false;
        }
    }

    public final boolean getTickPaused() {
        return this.tickPaused;
    }

    @Override
    public void draw(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        if (this.tickOnDraw && !this.tickPaused) {
            this.tickImpl();
        }
        super.draw(gL2ES2, regionRenderer);
    }

    public final void resetAnimation() {
        this.tlast_us = this.tstart_us = Clock.currentNanos() / 1000L;
        this.duration_s = 0.0f;
        this.frame_count = 0L;
    }

    public final void restartAnimation() {
        super.runSynced(() -> {
            for (Set set : this.animSets) {
                set.setAnimationActive(true);
            }
        });
        this.resetAnimation();
    }

    public void stopAnimation() {
        super.runSynced(() -> {
            for (Set set : this.animSets) {
                set.setAnimationActive(false);
            }
        });
    }

    public final boolean isAnimationActive() {
        for (Set set : this.animSets) {
            if (!set.isAnimationActive()) continue;
            return true;
        }
        return false;
    }

    public final void setFixedPeriod(float f) {
        this.fixed_frame_period = f;
    }

    public final float getFixedPeriod() {
        return this.fixed_frame_period;
    }

    public final float getDuration() {
        return this.duration_s;
    }

    public final void tick() {
        if (!this.tickPaused) {
            super.runSynced(() -> this.tickImpl());
        }
    }

    private final void tickImpl() {
        float f;
        float f2;
        long l = Clock.currentNanos() / 1000L;
        if (FloatUtil.isZero(this.fixed_frame_period)) {
            f2 = (float)(l - this.tlast_us) / 1000000.0f;
            this.duration_s = f = (float)(l - this.tstart_us) / 1000000.0f;
        } else {
            f2 = this.fixed_frame_period;
            this.duration_s += f2;
            f = this.duration_s;
        }
        this.tlast_us = l;
        for (Set set : this.animSets) {
            if (!set.isAnimationActive()) continue;
            if (!FloatUtil.isZero(set.accel)) {
                set.velocity += set.accel * f2;
                set.velocity_obj += set.accel_obj * f2;
            }
            if (!FloatUtil.isZero(set.ang_accel)) {
                set.ang_velo += set.ang_accel * f2;
            }
            for (int i = 0; i < set.allShapes.size(); ++i) {
                ShapeData shapeData = set.allShapes.get(i);
                if (set.lerp.eval(this.frame_count, set, i, shapeData, f, f2)) continue;
                shapeData.active = false;
            }
        }
        ++this.frame_count;
    }

    public static interface LerpFunc {
        public boolean eval(long var1, Set var3, int var4, ShapeData var5, float var6, float var7);
    }

    public static class ScrollLerp
    implements LerpFunc {
        final AABBox clip;

        public ScrollLerp(AABBox aABBox) {
            this.clip = aABBox;
        }

        @Override
        public boolean eval(long l, Set set, int n, ShapeData shapeData, float f, float f2) {
            boolean bl;
            float f3 = set.velocity_obj * f2;
            Vec3f vec3f = shapeData.shape.getPosition().copy();
            Vec3f vec3f2 = shapeData.targetPos.minus(vec3f);
            float f4 = vec3f2.length();
            boolean bl2 = bl = f4 <= f3 || f4 <= 5.9604645E-4f;
            if (bl) {
                if (0 == n) {
                    set.velocity = set.start_velocity;
                    set.velocity_obj = set.start_velocity_obj;
                    set.ang_velo = set.start_ang_velo;
                    ShapeData shapeData2 = set.allShapes.get(set.allShapes.size() - 1);
                    Vec3f vec3f3 = shapeData2.shape.getPosition().minus(shapeData.startPos);
                    float f5 = Vec3f.UNIT_X.angle(vec3f3);
                    if (f5 >= 1.5707964f) {
                        vec3f.set(shapeData.startPos);
                    } else {
                        vec3f.set(shapeData2.shape.getPosition()).add(Vec3f.UNIT_X.mul(shapeData2.shape.getScaledWidth() * 2.0f));
                    }
                } else {
                    ShapeData shapeData3 = set.allShapes.get(n - 1);
                    Vec3f vec3f4 = shapeData.startPos.minus(shapeData3.startPos);
                    vec3f.set(shapeData3.shape.getPosition()).add(vec3f4);
                }
            } else {
                vec3f.add(vec3f2.normalize().scale(f3));
            }
            if (this.clip.intersects2DRegion(vec3f.x(), vec3f.y(), shapeData.shape.getScaledWidth(), shapeData.shape.getScaledHeight())) {
                shapeData.shape.setVisible(true);
            } else {
                shapeData.shape.setVisible(false);
            }
            shapeData.shape.moveTo(vec3f);
            return true;
        }
    }

    public static final class Set {
        public final float pixPerMM;
        public final Vec2f pixPerShapeUnit;
        public final Shape refShape;
        public final float accel;
        public final float accel_obj;
        public final float start_velocity;
        public final float start_velocity_obj;
        public float velocity;
        public float velocity_obj;
        public final float ang_accel;
        public final float start_ang_velo;
        public float ang_velo;
        public final LerpFunc lerp;
        public final List<ShapeData> allShapes;
        public final AABBox sourceBounds;

        private Set(float f, float[] fArray, Shape shape, float f2, float f3, float f4, float f5, List<ShapeData> list, AABBox aABBox, LerpFunc lerpFunc) {
            this.pixPerMM = f;
            this.pixPerShapeUnit = new Vec2f(fArray);
            this.refShape = shape;
            this.accel = f2;
            this.start_velocity = f3;
            this.velocity = f3;
            float f6 = f2 * 1000.0f * f;
            this.accel_obj = f6 / this.pixPerShapeUnit.x();
            float f7 = f3 * 1000.0f * f;
            this.velocity_obj = this.start_velocity_obj = f7 / this.pixPerShapeUnit.x();
            this.ang_accel = f4;
            this.start_ang_velo = f5;
            this.ang_velo = f5;
            this.lerp = lerpFunc;
            this.allShapes = list;
            this.sourceBounds = aABBox;
        }

        public ShapeData addShape(AnimGroup animGroup, Shape shape, ShapeSetup shapeSetup) {
            ShapeData shapeData = new ShapeData(shape);
            int n = this.allShapes.size();
            this.allShapes.add(shapeData);
            this.sourceBounds.resize(shapeData.shape.getBounds());
            shapeSetup.setup(this, n, shapeData);
            animGroup.addShape(shapeData.shape);
            return shapeData;
        }

        public void removeShape(AnimGroup animGroup, GL2ES2 gL2ES2, RegionRenderer regionRenderer, ShapeData shapeData) {
            animGroup.removeShape(gL2ES2, regionRenderer, shapeData.shape);
            shapeData.active = false;
            this.allShapes.remove(shapeData);
        }

        public void removeShapes(AnimGroup animGroup, GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
            for (ShapeData shapeData : this.allShapes) {
                animGroup.removeShape(gL2ES2, regionRenderer, shapeData.shape);
                shapeData.active = false;
            }
            this.allShapes.clear();
        }

        private void remove(AnimGroup animGroup, GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
            this.removeShapes(animGroup, gL2ES2, regionRenderer);
            this.refShape.destroy(gL2ES2, regionRenderer);
        }

        public void setAnimationActive(boolean bl) {
            for (ShapeData shapeData : this.allShapes) {
                shapeData.active = bl;
            }
        }

        public boolean isAnimationActive() {
            for (ShapeData shapeData : this.allShapes) {
                if (!shapeData.active) continue;
                return true;
            }
            return false;
        }
    }

    public static final class ShapeData {
        public boolean active = true;
        public final Vec3f startPos;
        public final Vec3f targetPos;
        public final Shape shape;
        public Object user;

        public ShapeData(Shape shape) {
            this.startPos = new Vec3f(shape.getPosition());
            this.targetPos = this.startPos.copy();
            this.shape = shape;
            this.user = null;
        }
    }

    public static interface ShapeSetup {
        public void setup(Set var1, int var2, ShapeData var3);
    }

    public static class SineLerp
    implements LerpFunc {
        final Vec3f sineDir;
        final float sineScale;
        final float shapeStep;
        static final boolean methodB = true;

        public SineLerp(Vec3f vec3f, float f, float f2) {
            this.sineDir = vec3f;
            this.sineScale = f;
            this.shapeStep = f2;
        }

        @Override
        public boolean eval(long l, Set set, int n, ShapeData shapeData, float f, float f2) {
            boolean bl;
            Vec3f vec3f;
            float f3 = set.velocity_obj * f2;
            float f4 = set.ang_velo * (f + (float)n * this.shapeStep * f2);
            Vec3f vec3f2 = shapeData.shape.getPosition().copy();
            if (0L == l) {
                shapeData.user = null;
            } else if (null != shapeData.user) {
                vec3f = (Vec3f)shapeData.user;
                vec3f2.sub(vec3f);
            }
            vec3f = shapeData.targetPos.minus(vec3f2);
            float f5 = vec3f.length();
            boolean bl2 = bl = f5 <= f3 || f5 <= 5.9604645E-4f;
            if (bl) {
                shapeData.shape.moveTo(shapeData.targetPos);
                shapeData.shape.setInteractive(false);
                return false;
            }
            float f6 = shapeData.shape.getScale().y();
            Vec3f vec3f3 = shapeData.targetPos.minus(shapeData.startPos);
            float f7 = f5 / vec3f3.length();
            float f8 = FloatUtil.sin(f4) * f7 * f6 * this.sineScale;
            Vec3f vec3f4 = this.sineDir.copy().scale(f8);
            shapeData.user = vec3f4;
            shapeData.shape.moveTo(vec3f2.add(vec3f.normalize().scale(f3)).add(vec3f4));
            return true;
        }
    }

    public static class TargetLerp
    implements LerpFunc {
        final Vec3f rotAxis;

        public TargetLerp(Vec3f vec3f) {
            this.rotAxis = vec3f;
        }

        @Override
        public boolean eval(long l, Set set, int n, ShapeData shapeData, float f, float f2) {
            boolean bl;
            float f3 = set.velocity_obj * f2;
            float f4 = set.ang_velo * f2;
            float f5 = shapeData.shape.getScale().y();
            Vec3f vec3f = shapeData.shape.getPosition().copy();
            Vec3f vec3f2 = shapeData.targetPos.minus(vec3f);
            float f6 = vec3f2.length();
            Quaternion quaternion = shapeData.shape.getRotation().copy();
            float f7 = quaternion.toEuler(new Vec3f()).length();
            float f8 = Math.min(Math.abs(f7), (float)Math.PI * 2 - Math.abs(f7));
            boolean bl2 = f6 <= 5.9604645E-4f;
            boolean bl3 = bl2 || f6 <= shapeData.shape.getBounds().getSize() * f5 * 2.0f;
            boolean bl4 = bl = bl3 && (f4 < ROT_EPS || f8 <= ROT_EPS || f8 <= f4 * 2.0f);
            if (bl2 && bl) {
                shapeData.shape.moveTo(shapeData.targetPos);
                quaternion.setIdentity();
                shapeData.shape.setRotation(quaternion);
                shapeData.shape.setInteractive(false);
                return false;
            }
            if (!bl2) {
                if (f6 <= f3 || f6 <= 5.9604645E-4f) {
                    shapeData.shape.moveTo(shapeData.targetPos);
                } else {
                    vec3f.add(vec3f2.normalize().scale(f3));
                    shapeData.shape.moveTo(vec3f);
                }
                if (!bl) {
                    if (bl3) {
                        quaternion.rotateByAngleNormalAxis(f4 * 2.0f, this.rotAxis);
                    } else {
                        quaternion.rotateByAngleNormalAxis(f4, this.rotAxis);
                    }
                    shapeData.shape.setRotation(quaternion);
                }
            } else {
                if (bl || f8 <= f4 * 3.0f) {
                    quaternion.setIdentity();
                } else {
                    quaternion.rotateByAngleNormalAxis(f4 * 3.0f, this.rotAxis);
                }
                shapeData.shape.setRotation(quaternion);
            }
            return true;
        }
    }
}

