/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.property.KeywordValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.URIValueWrapper;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMException;

public abstract class ValueList
extends StyleValue
implements CSSValueList<StyleValue> {
    private static final long serialVersionUID = 1L;
    protected final List<StyleValue> valueList;

    private ValueList() {
        this.valueList = new ArrayList<StyleValue>();
    }

    private ValueList(ValueList valueList) {
        this.valueList = new ArrayList<StyleValue>(valueList.valueList);
    }

    @Override
    public int getLength() {
        return this.valueList.size();
    }

    @Override
    public StyleValue item(int n) {
        if (n < 0 || n >= this.valueList.size()) {
            return null;
        }
        return this.valueList.get(n);
    }

    @Override
    public Iterator<StyleValue> iterator() {
        return this.valueList.iterator();
    }

    @Override
    public boolean add(StyleValue styleValue) {
        if (styleValue == null) {
            throw new NullPointerException("Null value added to ValueList");
        }
        return this.valueList.add(styleValue);
    }

    public boolean addAll(ValueList valueList) {
        if (valueList == null) {
            throw new NullPointerException("Null list added to ValueList");
        }
        if (this.isCommaSeparated() != valueList.isCommaSeparated() || this.isBracketList() != valueList.isBracketList()) {
            throw new DOMException(13, "Attempted to add lists of different types");
        }
        return this.valueList.addAll(valueList.valueList);
    }

    @Override
    public StyleValue remove(int n) {
        return this.valueList.remove(n);
    }

    @Override
    public StyleValue set(int n, StyleValue styleValue) {
        if (styleValue == null) {
            throw new NullPointerException("Null value set to ValueList");
        }
        return this.valueList.set(n, styleValue);
    }

    @Override
    public boolean isEmpty() {
        return this.valueList.isEmpty();
    }

    @Override
    public void clear() {
        this.valueList.clear();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode() * 31;
        if (this.valueList != null) {
            for (CSSValue cSSValue : this.valueList) {
                n2 = 31 * n2 + (cSSValue == null ? 0 : cSSValue.hashCode());
            }
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ValueList valueList = (ValueList)object;
        if (this.valueList.isEmpty()) {
            return valueList.valueList.isEmpty();
        }
        if (this.valueList.size() != valueList.valueList.size()) {
            return false;
        }
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            CSSValue cSSValue = this.valueList.get(i);
            CSSValue cSSValue2 = valueList.valueList.get(i);
            if (!(cSSValue == null ? cSSValue2 != null : !cSSValue.equals(cSSValue2))) continue;
            return false;
        }
        return true;
    }

    public void setSubproperty(boolean bl) {
        if (this.valueList != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                StyleValue styleValue = this.item(i);
                CSSValue.CssType cssType = styleValue.getCssValueType();
                if (cssType == CSSValue.CssType.TYPED || cssType == CSSValue.CssType.PROXY) {
                    ((PrimitiveValue)styleValue).setSubproperty(true);
                    continue;
                }
                if (cssType == CSSValue.CssType.KEYWORD) {
                    this.set(i, ((KeywordValue)styleValue).asSubproperty());
                    continue;
                }
                if (cssType != CSSValue.CssType.LIST) continue;
                ((ValueList)styleValue).setSubproperty(true);
            }
        }
    }

    @Override
    public boolean isSubproperty() {
        if (this.valueList != null) {
            for (StyleValue styleValue : this.valueList) {
                if (styleValue.isSubproperty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "This value has to be modified by accessing its elements.");
    }

    public abstract boolean isCommaSeparated();

    public boolean isBracketList() {
        return false;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        CSSValueSyntax.Match match = CSSValueSyntax.Match.FALSE;
        if (!this.isEmpty() && cSSValueSyntax != null) {
            if (this.getLength() == 1) {
                return this.item(0).matches(cSSValueSyntax);
            }
            if (cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            do {
                CSSValueSyntax.Match match2;
                CSSValueSyntax.Multiplier multiplier;
                if ((multiplier = cSSValueSyntax.getMultiplier()) == CSSValueSyntax.Multiplier.NUMBER) {
                    if (!this.isCommaSeparated() && cSSValueSyntax.getCategory() != CSSValueSyntax.Category.transformList) continue;
                    match2 = ValueList.valuesMatch(this.iterator(), cSSValueSyntax);
                    if (match2 == CSSValueSyntax.Match.TRUE) {
                        return CSSValueSyntax.Match.TRUE;
                    }
                    if (match != CSSValueSyntax.Match.FALSE) continue;
                    match = match2;
                    continue;
                }
                if (multiplier != CSSValueSyntax.Multiplier.PLUS && cSSValueSyntax.getCategory() != CSSValueSyntax.Category.transformList || this.isCommaSeparated()) continue;
                match2 = ValueList.valuesMatch(this.iterator(), cSSValueSyntax);
                if (match2 == CSSValueSyntax.Match.TRUE) {
                    return CSSValueSyntax.Match.TRUE;
                }
                if (match != CSSValueSyntax.Match.FALSE) continue;
                match = match2;
            } while ((cSSValueSyntax = cSSValueSyntax.getNext()) != null);
        }
        return match;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        CSSValueSyntax.Multiplier multiplier = cSSValueSyntax.getMultiplier();
        if (multiplier == CSSValueSyntax.Multiplier.NUMBER ? this.isCommaSeparated() || this.getLength() == 1 || cSSValueSyntax.getCategory() == CSSValueSyntax.Category.transformList : (multiplier == CSSValueSyntax.Multiplier.PLUS || cSSValueSyntax.getCategory() == CSSValueSyntax.Category.transformList) && !this.isCommaSeparated()) {
            return ValueList.valuesMatch(this.iterator(), cSSValueSyntax);
        }
        return CSSValueSyntax.Match.FALSE;
    }

    static CSSValueSyntax.Match valuesMatch(Iterator<StyleValue> iterator, CSSValueSyntax cSSValueSyntax) {
        CSSValueSyntax.Match match = CSSValueSyntax.Match.TRUE;
        while (iterator.hasNext()) {
            StyleValue styleValue = iterator.next();
            if (styleValue.getCssValueType() == CSSValue.CssType.LIST && cSSValueSyntax.getCategory() != CSSValueSyntax.Category.transformList) {
                return CSSValueSyntax.Match.FALSE;
            }
            CSSValueSyntax.Match match2 = styleValue.matchesComponent(cSSValueSyntax);
            if (match2 == CSSValueSyntax.Match.FALSE) {
                return CSSValueSyntax.Match.FALSE;
            }
            if (match2 != CSSValueSyntax.Match.PENDING) continue;
            match = CSSValueSyntax.Match.PENDING;
        }
        return match;
    }

    @Override
    public abstract ValueList clone();

    public static ValueList createCSValueList() {
        return new CSValueList();
    }

    public static ValueList createWSValueList() {
        return new WSValueList();
    }

    public static ValueList createBracketValueList() {
        return new BracketValueList();
    }

    public abstract ValueList wrap(String var1, String var2);

    private static class BracketValueList
    extends ValueList {
        private static final long serialVersionUID = 1L;

        private BracketValueList() {
        }

        private BracketValueList(BracketValueList bracketValueList) {
            super(bracketValueList);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "[]";
            }
            BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(this.valueList.size() * 24 + 18);
            try {
                this.writeCssText((SimpleWriter)bufferSimpleWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bufferSimpleWriter.toString();
        }

        @Override
        public String getMinifiedCssText(String string) {
            if (this.valueList.isEmpty()) {
                return "[]";
            }
            StringBuilder stringBuilder = new StringBuilder(this.valueList.size() * 24 + 16);
            stringBuilder.append('[').append(((StyleValue)this.item(0)).getMinifiedCssText(string));
            int n = this.valueList.size();
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(' ').append(((StyleValue)this.item(i)).getMinifiedCssText(string));
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        @Override
        public void writeCssText(SimpleWriter simpleWriter) throws IOException {
            if (!this.valueList.isEmpty()) {
                simpleWriter.write('[');
                ((StyleValue)this.valueList.get(0)).writeCssText(simpleWriter);
                int n = this.valueList.size();
                for (int i = 1; i < n; ++i) {
                    simpleWriter.write(' ');
                    ((StyleValue)this.valueList.get(i)).writeCssText(simpleWriter);
                }
                simpleWriter.write(']');
            } else {
                simpleWriter.write((CharSequence)"[]");
            }
        }

        @Override
        public boolean isBracketList() {
            return true;
        }

        @Override
        public boolean isCommaSeparated() {
            return false;
        }

        @Override
        public ValueList clone() {
            return new BracketValueList(this);
        }

        @Override
        public ValueList wrap(String string, String string2) {
            return new BracketValueListWrapper(this, string, string2);
        }

        public static class BracketValueListWrapper
        extends WSValueList.WSValueListWrapper {
            private static final long serialVersionUID = 1L;

            BracketValueListWrapper(ValueList valueList, String string, String string2) {
                super(valueList, string, string2);
            }

            @Override
            public ValueList clone() {
                return new BracketValueListWrapper(super.clone(), this.oldHrefContext, this.getParentSheetHref());
            }
        }
    }

    private static class CSValueList
    extends ValueList {
        private static final long serialVersionUID = 1L;

        private CSValueList() {
        }

        private CSValueList(ValueList valueList) {
            super(valueList);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "";
            }
            BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(this.valueList.size() * 24 + 16);
            try {
                this.writeCssText((SimpleWriter)bufferSimpleWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bufferSimpleWriter.toString();
        }

        @Override
        public String getMinifiedCssText(String string) {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(this.valueList.size() * 24 + 16);
            stringBuilder.append(((StyleValue)this.item(0)).getMinifiedCssText(string));
            int n = this.valueList.size();
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(',').append(((StyleValue)this.item(i)).getMinifiedCssText(string));
            }
            return stringBuilder.toString();
        }

        @Override
        public void writeCssText(SimpleWriter simpleWriter) throws IOException {
            if (!this.valueList.isEmpty()) {
                ((StyleValue)this.valueList.get(0)).writeCssText(simpleWriter);
                int n = this.valueList.size();
                for (int i = 1; i < n; ++i) {
                    simpleWriter.write(',');
                    simpleWriter.write(' ');
                    ((StyleValue)this.valueList.get(i)).writeCssText(simpleWriter);
                }
            }
        }

        @Override
        public boolean isCommaSeparated() {
            return true;
        }

        @Override
        public ValueList clone() {
            return new CSValueList(this);
        }

        @Override
        public ValueList wrap(String string, String string2) {
            return new CSValueListWrapper(this, string, string2);
        }

        public static class CSValueListWrapper
        extends CSValueList
        implements WrappedValue {
            private static final long serialVersionUID = 1L;
            private final String oldHrefContext;
            private final String parentSheetHref;

            CSValueListWrapper(ValueList valueList, String string, String string2) {
                super(valueList);
                this.parentSheetHref = string2;
                this.oldHrefContext = string;
            }

            @Override
            public String getParentSheetHref() {
                return this.parentSheetHref;
            }

            @Override
            public StyleValue item(int n) {
                CSSValue cSSValue = super.item(n);
                if (cSSValue != null && cSSValue.getPrimitiveType() == CSSValue.Type.URI) {
                    return new URIValueWrapper((URIValue)cSSValue, this.oldHrefContext, this.parentSheetHref);
                }
                return cSSValue;
            }

            @Override
            public ValueList clone() {
                return new CSValueListWrapper(super.clone(), this.oldHrefContext, this.parentSheetHref);
            }
        }
    }

    private static class WSValueList
    extends ValueList {
        private static final long serialVersionUID = 1L;

        private WSValueList() {
        }

        private WSValueList(ValueList valueList) {
            super(valueList);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "";
            }
            BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(this.valueList.size() * 24 + 16);
            try {
                this.writeCssText((SimpleWriter)bufferSimpleWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bufferSimpleWriter.toString();
        }

        @Override
        public String getMinifiedCssText(String string) {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(this.valueList.size() * 24 + 16);
            stringBuilder.append(((StyleValue)this.item(0)).getMinifiedCssText(string));
            int n = this.valueList.size();
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(' ').append(((StyleValue)this.item(i)).getMinifiedCssText(string));
            }
            return stringBuilder.toString();
        }

        @Override
        public void writeCssText(SimpleWriter simpleWriter) throws IOException {
            if (!this.valueList.isEmpty()) {
                ((StyleValue)this.valueList.get(0)).writeCssText(simpleWriter);
                int n = this.valueList.size();
                for (int i = 1; i < n; ++i) {
                    simpleWriter.write(' ');
                    ((StyleValue)this.valueList.get(i)).writeCssText(simpleWriter);
                }
            }
        }

        @Override
        public boolean isCommaSeparated() {
            return false;
        }

        @Override
        public ValueList clone() {
            return new WSValueList(this);
        }

        @Override
        public ValueList wrap(String string, String string2) {
            return new WSValueListWrapper(this, string, string2);
        }

        public static class WSValueListWrapper
        extends WSValueList
        implements WrappedValue {
            private static final long serialVersionUID = 1L;
            private final String parentSheetHref;
            final String oldHrefContext;

            WSValueListWrapper(ValueList valueList, String string, String string2) {
                super(valueList);
                this.parentSheetHref = string2;
                this.oldHrefContext = string;
            }

            @Override
            public String getParentSheetHref() {
                return this.parentSheetHref;
            }

            @Override
            public StyleValue item(int n) {
                CSSValue cSSValue = super.item(n);
                if (cSSValue != null && cSSValue.getPrimitiveType() == CSSValue.Type.URI) {
                    return new URIValueWrapper((URIValue)cSSValue, this.oldHrefContext, this.parentSheetHref);
                }
                return cSSValue;
            }

            @Override
            public ValueList clone() {
                return new WSValueListWrapper(super.clone(), this.oldHrefContext, this.parentSheetHref);
            }
        }
    }
}

