/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.style.css.CSSGroupingRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.SheetHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public abstract class GroupingRule
extends BaseCSSRule
implements CSSGroupingRule {
    private static final long serialVersionUID = 1L;
    CSSRuleArrayList cssRules;

    protected GroupingRule(AbstractCSSStyleSheet abstractCSSStyleSheet, short s, byte by) {
        super(abstractCSSStyleSheet, s, by);
        this.cssRules = new CSSRuleArrayList();
    }

    protected GroupingRule(AbstractCSSStyleSheet abstractCSSStyleSheet, GroupingRule groupingRule) {
        super(abstractCSSStyleSheet, groupingRule.getType(), groupingRule.getOrigin());
        if (groupingRule.getPrecedingComments() != null) {
            this.setPrecedingComments(new LinkedStringList());
            this.getPrecedingComments().addAll(groupingRule.getPrecedingComments());
        }
        this.cssRules = new CSSRuleArrayList(groupingRule.getCssRules().getLength());
        for (AbstractCSSRule abstractCSSRule : groupingRule.getCssRules()) {
            AbstractCSSRule abstractCSSRule2 = abstractCSSRule.clone(abstractCSSStyleSheet);
            abstractCSSRule2.setParentRule(this);
            this.cssRules.add(abstractCSSRule2);
        }
    }

    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String string, int n) throws DOMException {
        if (n < 0 || n > this.cssRules.size()) {
            throw new DOMException(1, "Index out of bounds in rule list");
        }
        StringReader stringReader = new StringReader(string);
        RuleHandler ruleHandler = new RuleHandler();
        ruleHandler.setCurrentInsertionIndex(n);
        BaseCSSRule.AllowWarningsRuleErrorHandler allowWarningsRuleErrorHandler = new BaseCSSRule.AllowWarningsRuleErrorHandler();
        CSSParser cSSParser = (CSSParser)this.createSACParser();
        cSSParser.setDocumentHandler(ruleHandler);
        cSSParser.setErrorHandler(allowWarningsRuleErrorHandler);
        try {
            this.parseRule((Reader)stringReader, cSSParser);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return n;
    }

    @Override
    public void deleteRule(int n) throws DOMException {
        if (n < 0 || n >= this.cssRules.size()) {
            throw new DOMException(1, "Could not delete rule in rule list: index out of bounds.");
        }
        this.cssRules.remove(n);
    }

    int insertRule(AbstractCSSRule abstractCSSRule, int n) {
        abstractCSSRule.setParentRule(this);
        return this.cssRules.insertRule(abstractCSSRule, n);
    }

    int addRule(AbstractCSSRule abstractCSSRule) {
        int n = this.cssRules.getLength();
        this.cssRules.add(abstractCSSRule);
        abstractCSSRule.setParentRule(this);
        return n;
    }

    @Override
    void setRule(AbstractCSSRule abstractCSSRule) {
        GroupingRule groupingRule = (GroupingRule)abstractCSSRule;
        this.setGroupingRule(groupingRule);
        this.setPrecedingComments(groupingRule.getPrecedingComments());
        this.setTrailingComments(groupingRule.getTrailingComments());
        this.cssRules.clear();
        this.cssRules.addAll(groupingRule.getCssRules());
        for (AbstractCSSRule abstractCSSRule2 : this.cssRules) {
            abstractCSSRule2.setParentRule(this);
        }
    }

    @Override
    void clear() {
        this.cssRules.clear();
        this.resetComments();
    }

    protected abstract void setGroupingRule(GroupingRule var1) throws DOMException;

    @Override
    boolean hasErrorsOrWarnings() {
        for (AbstractCSSRule abstractCSSRule : this.cssRules) {
            if (!abstractCSSRule.hasErrorsOrWarnings()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.cssRules == null ? 0 : this.cssRules.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GroupingRule)) {
            return false;
        }
        GroupingRule groupingRule = (GroupingRule)object;
        return !(this.cssRules == null ? groupingRule.cssRules != null : !this.cssRules.equals(groupingRule.cssRules));
    }

    private class RuleHandler
    extends SheetHandler {
        private AbstractCSSRule currentRule;
        private int currentInsertionIndex;

        private RuleHandler() {
            super((BaseCSSStyleSheet)GroupingRule.this.getParentStyleSheet(), GroupingRule.this.getOrigin(), (short)0);
            this.currentRule = null;
            this.currentInsertionIndex = 0;
        }

        public void setCurrentInsertionIndex(int n) {
            this.currentInsertionIndex = n;
        }

        @Override
        public void parseStart(ParserControl parserControl) {
            super.parseStart(parserControl);
            this.currentRule = null;
        }

        @Override
        public void importStyle(String string, MediaQueryList mediaQueryList, String string2) {
        }

        @Override
        protected void addLocalRule(AbstractCSSRule abstractCSSRule) throws DOMException {
            if (this.currentRule != null) {
                throw new DOMException(13, "Attempted to parse more than one rule inside this one");
            }
            this.currentRule = abstractCSSRule;
            this.currentInsertionIndex = GroupingRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
        }
    }
}

