/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.renderable;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.Light;
import io.sf.carte.echosvg.ext.awt.image.PadMode;
import io.sf.carte.echosvg.ext.awt.image.renderable.AbstractColorInterpolationRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.SpecularLightingRable;
import io.sf.carte.echosvg.ext.awt.image.rendered.AffineRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.BumpMap;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.PadRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.SpecularLightingRed;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.util.Map;

public class SpecularLightingRable8Bit
extends AbstractColorInterpolationRable
implements SpecularLightingRable {
    private double surfaceScale;
    private double ks;
    private double specularExponent;
    private Light light;
    private Rectangle2D litRegion;
    private float[] kernelUnitLength = null;

    public SpecularLightingRable8Bit(Filter filter, Rectangle2D rectangle2D, Light light, double d, double d2, double d3, double[] dArray) {
        super(filter, (Map<String, Object>)null);
        this.setLight(light);
        this.setKs(d);
        this.setSpecularExponent(d2);
        this.setSurfaceScale(d3);
        this.setLitRegion(rectangle2D);
        this.setKernelUnitLength(dArray);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.litRegion.clone();
    }

    @Override
    public Rectangle2D getLitRegion() {
        return this.getBounds2D();
    }

    @Override
    public void setLitRegion(Rectangle2D rectangle2D) {
        this.touch();
        this.litRegion = rectangle2D;
    }

    @Override
    public Light getLight() {
        return this.light;
    }

    @Override
    public void setLight(Light light) {
        this.touch();
        this.light = light;
    }

    @Override
    public double getSurfaceScale() {
        return this.surfaceScale;
    }

    @Override
    public void setSurfaceScale(double d) {
        this.touch();
        this.surfaceScale = d;
    }

    @Override
    public double getKs() {
        return this.ks;
    }

    @Override
    public void setKs(double d) {
        this.touch();
        this.ks = d;
    }

    @Override
    public double getSpecularExponent() {
        return this.specularExponent;
    }

    @Override
    public void setSpecularExponent(double d) {
        this.touch();
        this.specularExponent = d;
    }

    @Override
    public double[] getKernelUnitLength() {
        if (this.kernelUnitLength == null) {
            return null;
        }
        double[] dArray = new double[]{this.kernelUnitLength[0], this.kernelUnitLength[1]};
        return dArray;
    }

    @Override
    public void setKernelUnitLength(double[] dArray) {
        this.touch();
        if (dArray == null) {
            this.kernelUnitLength = null;
            return;
        }
        if (this.kernelUnitLength == null) {
            this.kernelUnitLength = new float[2];
        }
        this.kernelUnitLength[0] = (float)dArray[0];
        this.kernelUnitLength[1] = (float)dArray[1];
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = this.getBounds2D();
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        Rectangle2D.intersect(rectangle2D, this.getBounds2D(), rectangle2D);
        AffineTransform affineTransform = renderContext.getTransform();
        Rectangle rectangle = affineTransform.createTransformedShape(rectangle2D).getBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return null;
        }
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getScaleY();
        double d3 = affineTransform.getShearX();
        double d4 = affineTransform.getShearY();
        double d5 = affineTransform.getTranslateX();
        double d6 = affineTransform.getTranslateY();
        double d7 = Math.sqrt(d * d + d4 * d4);
        double d8 = Math.sqrt(d2 * d2 + d3 * d3);
        if (d7 == 0.0 || d8 == 0.0) {
            return null;
        }
        if (this.kernelUnitLength != null) {
            if (d7 >= (double)(1.0f / this.kernelUnitLength[0])) {
                d7 = 1.0f / this.kernelUnitLength[0];
            }
            if (d8 >= (double)(1.0f / this.kernelUnitLength[1])) {
                d8 = 1.0f / this.kernelUnitLength[1];
            }
        }
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(d7, d8);
        rectangle = affineTransform2.createTransformedShape(rectangle2D).getBounds();
        rectangle2D.setRect(rectangle2D.getX() - 2.0 / d7, rectangle2D.getY() - 2.0 / d8, rectangle2D.getWidth() + 4.0 / d7, rectangle2D.getHeight() + 4.0 / d8);
        renderContext = (RenderContext)renderContext.clone();
        renderContext.setAreaOfInterest(rectangle2D);
        renderContext.setTransform(affineTransform2);
        CachableRed cachableRed = GraphicsUtil.wrap(this.getSource().createRendering(renderContext));
        BumpMap bumpMap = new BumpMap(cachableRed, this.surfaceScale, d7, d8);
        cachableRed = new SpecularLightingRed(this.ks, this.specularExponent, this.light, bumpMap, rectangle, 1.0 / d7, 1.0 / d8, this.isColorSpaceLinear());
        AffineTransform affineTransform3 = new AffineTransform(d / d7, d4 / d7, d3 / d8, d2 / d8, d5, d6);
        if (!affineTransform3.isIdentity()) {
            RenderingHints renderingHints = renderContext.getRenderingHints();
            Rectangle rectangle2 = new Rectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            cachableRed = new PadRed(cachableRed, rectangle2, PadMode.REPLICATE, renderingHints);
            cachableRed = new AffineRed(cachableRed, affineTransform3, renderingHints);
        }
        return cachableRed;
    }
}

