/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Loop;
import org.mozilla.javascript.ast.NodeVisitor;

public class ForInLoop
extends Loop {
    protected AstNode iterator;
    protected AstNode iteratedObject;
    protected int inPosition = -1;
    protected int eachPosition = -1;
    protected boolean isForEach;
    protected boolean isForOf;

    public ForInLoop() {
        this.type = 123;
    }

    public ForInLoop(int n) {
        super(n);
        this.type = 123;
    }

    public ForInLoop(int n, int n2) {
        super(n, n2);
        this.type = 123;
    }

    public AstNode getIterator() {
        return this.iterator;
    }

    public void setIterator(AstNode astNode) {
        this.assertNotNull(astNode);
        this.iterator = astNode;
        astNode.setParent(this);
    }

    public AstNode getIteratedObject() {
        return this.iteratedObject;
    }

    public void setIteratedObject(AstNode astNode) {
        this.assertNotNull(astNode);
        this.iteratedObject = astNode;
        astNode.setParent(this);
    }

    public boolean isForEach() {
        return this.isForEach;
    }

    public void setIsForEach(boolean bl) {
        this.isForEach = bl;
    }

    public boolean isForOf() {
        return this.isForOf;
    }

    public void setIsForOf(boolean bl) {
        this.isForOf = bl;
    }

    public int getInPosition() {
        return this.inPosition;
    }

    public void setInPosition(int n) {
        this.inPosition = n;
    }

    public int getEachPosition() {
        return this.eachPosition;
    }

    public void setEachPosition(int n) {
        this.eachPosition = n;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("for ");
        if (this.isForEach()) {
            stringBuilder.append("each ");
        }
        stringBuilder.append("(");
        stringBuilder.append(this.iterator.toSource(0));
        if (this.isForOf) {
            stringBuilder.append(" of ");
        } else {
            stringBuilder.append(" in ");
        }
        stringBuilder.append(this.iteratedObject.toSource(0));
        stringBuilder.append(") ");
        if (this.body.getType() == 133) {
            stringBuilder.append(this.body.toSource(n).trim()).append("\n");
        } else {
            stringBuilder.append("\n").append(this.body.toSource(n + 1));
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.iterator.visit(nodeVisitor);
            this.iteratedObject.visit(nodeVisitor);
            this.body.visit(nodeVisitor);
        }
    }
}

