/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt;

import io.sf.carte.echosvg.ext.awt.color.ColorContext;
import io.sf.carte.echosvg.gvt.PaintShapePainter;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class StrokeShapePainter
extends PaintShapePainter {
    protected Shape strokedShape;
    protected Stroke stroke;

    public StrokeShapePainter(Shape shape, ColorContext colorContext) {
        super(shape, colorContext);
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.strokedShape = null;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    @Override
    public Paint getPaint() {
        return super.getPaint();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.stroke != null && this.paint != null) {
            graphics2D.setPaint(this.getPaint());
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(this.shape);
        }
    }

    @Override
    public Shape getPaintedArea() {
        if (this.paint == null || this.stroke == null) {
            return null;
        }
        if (this.strokedShape == null) {
            this.strokedShape = this.stroke.createStrokedShape(this.shape);
        }
        return this.strokedShape;
    }

    @Override
    public Rectangle2D getPaintedBounds2D() {
        Shape shape = this.getPaintedArea();
        if (shape == null) {
            return null;
        }
        return shape.getBounds2D();
    }

    @Override
    public boolean inPaintedArea(Point2D point2D) {
        Shape shape = this.getPaintedArea();
        if (shape == null) {
            return false;
        }
        return shape.contains(point2D);
    }

    @Override
    public Shape getSensitiveArea() {
        if (this.stroke == null) {
            return null;
        }
        if (this.strokedShape == null) {
            this.strokedShape = this.stroke.createStrokedShape(this.shape);
        }
        return this.strokedShape;
    }

    @Override
    public Rectangle2D getSensitiveBounds2D() {
        Shape shape = this.getSensitiveArea();
        if (shape == null) {
            return null;
        }
        return shape.getBounds2D();
    }

    @Override
    public boolean inSensitiveArea(Point2D point2D) {
        Shape shape = this.getSensitiveArea();
        if (shape == null) {
            return false;
        }
        return shape.contains(point2D);
    }

    @Override
    public void setShape(Shape shape) {
        super.setShape(shape);
        this.strokedShape = null;
    }
}

