/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.text.format.FloatFormat;

public class ExponentFormat
extends FloatFormat {
    @Override
    public String format(Object object) {
        if (!(object instanceof Double) && !(object instanceof Float)) {
            throw new IllegalArgumentException("Object must be an Double or a Float");
        }
        return this.roundExpNumber((Number)object);
    }

    private String roundExpNumber(Number number) {
        double d = Math.log(10.0);
        double d2 = number.doubleValue();
        int n = (int)Math.floor(Math.log(Math.abs(d2)) / d);
        double d3 = Math.pow(10.0, -n);
        d2 *= d3;
        long l = this.getRoundingFactor();
        String string = (d2 = (double)Math.round(d2 * (double)l) / (double)l) < 0.0 ? "-" : (this.signpre ? "+" : "");
        char c = n < 0 ? (char)'-' : '+';
        String string2 = Integer.toString(Math.abs(n)).trim();
        if (string2.length() == 1) {
            string2 = '0' + string2;
        }
        String string3 = Double.toString(Math.abs(d2));
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(string).append(string3);
        for (int i = string3.length() - 2; i < this.precision; ++i) {
            stringBuilder.append('0');
        }
        if (this.tipo == 'e') {
            stringBuilder.append('e').append(c).append(string2);
        } else {
            stringBuilder.append('E').append(c).append(string2);
        }
        String string4 = stringBuilder.toString();
        string4 = this.ralign ? (this.zeropadding ? this.expandLeftToWidth(string4, '0') : this.expandLeftToWidth(string4, ' ')) : this.expandRightToWidth(string4);
        return string4;
    }
}

