/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.xml.dtd;

import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import io.sf.carte.doc.xml.dtd.DocumentTypeDeclaration;
import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenHandler;
import io.sf.carte.uparser.TokenHandler2;
import io.sf.carte.uparser.TokenProducer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class ContentModel {
    private static final Map<String, ContentModel> contentModelMap = new HashMap<String, ContentModel>();
    private final Set<String> emptyElements;
    private static final int DTD_SIZE_LIMIT = 0x100000;

    private ContentModel(Set<String> set) {
        this.emptyElements = set;
    }

    private static Set<String> emptyElementsFromDTD(DocumentType documentType, EntityResolver2 entityResolver2) throws SAXException, IOException {
        InputSource inputSource = entityResolver2.resolveEntity(documentType.getName(), documentType.getPublicId(), documentType.getBaseURI(), documentType.getSystemId());
        if (inputSource == null) {
            throw new IllegalArgumentException("Unable to resolve declaration " + documentType.toString());
        }
        Set<String> set = ContentModel.parseDTD(inputSource.getCharacterStream());
        HashSet<String> hashSet = new HashSet<String>(set);
        set.clear();
        return hashSet;
    }

    private static Set<String> emptyElementsFromDTD(DocumentTypeDeclaration documentTypeDeclaration, EntityResolver2 entityResolver2) throws SAXException, IOException {
        InputSource inputSource = entityResolver2.resolveEntity(documentTypeDeclaration.getName(), documentTypeDeclaration.getPublicId(), null, documentTypeDeclaration.getSystemId());
        if (inputSource == null) {
            throw new IllegalArgumentException("Unable to resolve declaration " + documentTypeDeclaration.toString());
        }
        Set<String> set = ContentModel.parseDTD(inputSource.getCharacterStream());
        HashSet<String> hashSet = new HashSet<String>(set);
        set.clear();
        return hashSet;
    }

    private static Set<String> parseDTD(Reader reader) throws IOException {
        HashSet<String> hashSet = new HashSet<String>(32);
        DTDTokenHandler dTDTokenHandler = new DTDTokenHandler(hashSet);
        int[] nArray = new int[]{60, 33};
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)dTDTokenHandler, nArray, 0x100000);
        tokenProducer.parse(reader, "<!--", "-->");
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentModel getModel(DocumentType documentType) throws SAXException, IOException {
        String string = documentType.getPublicId();
        if (string == null && (string = documentType.getSystemId()) == null) {
            string = documentType.getName();
        }
        Map<String, ContentModel> map = contentModelMap;
        synchronized (map) {
            if (string != null && !contentModelMap.containsKey(string)) {
                ContentModel contentModel;
                DefaultEntityResolver defaultEntityResolver = new DefaultEntityResolver();
                try {
                    contentModel = new ContentModel(ContentModel.emptyElementsFromDTD(documentType, (EntityResolver2)defaultEntityResolver));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                contentModelMap.put(string, contentModel);
            }
        }
        return contentModelMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentModel getModel(String string) throws SAXException, IOException {
        DocumentTypeDeclaration documentTypeDeclaration = DocumentTypeDeclaration.parse(string);
        String string2 = documentTypeDeclaration.getPublicId();
        if (string2 == null && (string2 = documentTypeDeclaration.getSystemId()) == null) {
            string2 = documentTypeDeclaration.getName();
        }
        Map<String, ContentModel> map = contentModelMap;
        synchronized (map) {
            if (string2 != null && !contentModelMap.containsKey(string2)) {
                ContentModel contentModel;
                DefaultEntityResolver defaultEntityResolver = new DefaultEntityResolver();
                try {
                    contentModel = new ContentModel(ContentModel.emptyElementsFromDTD(documentTypeDeclaration, (EntityResolver2)defaultEntityResolver));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                contentModelMap.put(string2, contentModel);
            }
        }
        return contentModelMap.get(string2);
    }

    public static ContentModel getXHTML1TransitionalModel() {
        try {
            return ContentModel.getModel("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        }
        catch (IOException | SAXException exception) {
            throw new IllegalStateException();
        }
    }

    public boolean isEmpty(String string) {
        return this.emptyElements.contains(string);
    }

    private static class DTDTokenHandler
    implements TokenHandler {
        private final Set<String> emptySet;
        private byte stage = 0;
        private String currentElement = null;

        DTDTokenHandler(Set<String> set) {
            this.emptySet = set;
        }

        public void tokenStart(TokenControl tokenControl) {
        }

        public void word(int n, CharSequence charSequence) {
            if ("<!ELEMENT".contentEquals(charSequence)) {
                this.stage = 1;
            } else if (this.stage == 1) {
                this.currentElement = charSequence.toString();
                this.stage = (byte)2;
            } else {
                this.stage = this.stage == 2 && "EMPTY".contentEquals(charSequence) ? (byte)3 : (byte)-1;
            }
        }

        public void separator(int n, int n2) {
        }

        public void quoted(int n, CharSequence charSequence, int n2) {
            this.stage = (byte)-1;
        }

        public void quotedWithControl(int n, CharSequence charSequence, int n2) {
            this.stage = (byte)-1;
        }

        public void quotedNewlineChar(int n, int n2) {
            this.stage = (byte)-1;
        }

        public void openGroup(int n, int n2) {
            this.stage = (byte)-1;
        }

        public void closeGroup(int n, int n2) {
            this.stage = (byte)-1;
        }

        public void character(int n, int n2) {
            if (n2 == 62) {
                if (this.stage == 3) {
                    this.emptySet.add(this.currentElement);
                }
                this.stage = 0;
            } else {
                this.stage = (byte)-1;
            }
        }

        public void escaped(int n, int n2) {
            this.stage = (byte)-1;
        }

        public void control(int n, int n2) {
        }

        public void commented(int n, int n2, String string) {
        }

        public void endOfStream(int n) {
        }

        public void error(int n, byte by, CharSequence charSequence) {
        }
    }
}

