/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt;

import io.sf.carte.echosvg.ext.awt.RenderingHintsKeyExt;
import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.renderable.ClipRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.gvt.CompositeGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.RootGraphicsNode;
import io.sf.carte.echosvg.gvt.event.GraphicsNodeChangeEvent;
import io.sf.carte.echosvg.gvt.event.GraphicsNodeChangeListener;
import io.sf.carte.echosvg.gvt.filter.GraphicsNodeRable;
import io.sf.carte.echosvg.gvt.filter.GraphicsNodeRable8Bit;
import io.sf.carte.echosvg.gvt.filter.Mask;
import io.sf.carte.echosvg.util.HaltingThread;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.renderable.RenderableImage;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public abstract class AbstractGraphicsNode
implements GraphicsNode {
    protected EventListenerList listeners;
    protected AffineTransform transform;
    protected AffineTransform inverseTransform;
    protected Composite composite;
    protected boolean isVisible = true;
    protected ClipRable clip;
    protected RenderingHints hints;
    protected CompositeGraphicsNode parent;
    protected RootGraphicsNode root;
    protected Mask mask;
    protected Filter filter;
    protected int pointerEventType = 0;
    protected WeakReference<GraphicsNodeRable> graphicsNodeRable;
    protected WeakReference<GraphicsNodeRable> enableBackgroundGraphicsNodeRable;
    protected WeakReference<AbstractGraphicsNode> weakRef;
    private Rectangle2D bounds;
    protected GraphicsNodeChangeEvent changeStartedEvent = null;
    protected GraphicsNodeChangeEvent changeCompletedEvent = null;
    static double EPSILON = 1.0E-6;

    protected AbstractGraphicsNode() {
    }

    @Override
    public WeakReference<AbstractGraphicsNode> getWeakReference() {
        if (this.weakRef == null) {
            this.weakRef = new WeakReference<AbstractGraphicsNode>(this);
        }
        return this.weakRef;
    }

    @Override
    public int getPointerEventType() {
        return this.pointerEventType;
    }

    @Override
    public void setPointerEventType(int n) {
        this.pointerEventType = n;
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.fireGraphicsNodeChangeStarted();
        this.transform = affineTransform;
        if (this.transform.getDeterminant() != 0.0) {
            try {
                this.inverseTransform = this.transform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new RuntimeException(noninvertibleTransformException.getMessage());
            }
        } else {
            this.inverseTransform = this.transform;
        }
        if (this.parent != null) {
            this.parent.invalidateGeometryCache();
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public AffineTransform getInverseTransform() {
        return this.inverseTransform;
    }

    @Override
    public AffineTransform getGlobalTransform() {
        AffineTransform affineTransform = new AffineTransform();
        for (AbstractGraphicsNode abstractGraphicsNode = this; abstractGraphicsNode != null; abstractGraphicsNode = abstractGraphicsNode.getParent()) {
            if (abstractGraphicsNode.getTransform() == null) continue;
            affineTransform.preConcatenate(abstractGraphicsNode.getTransform());
        }
        return affineTransform;
    }

    @Override
    public void setComposite(Composite composite) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.composite = composite;
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setVisible(boolean bl) {
        this.fireGraphicsNodeChangeStarted();
        this.isVisible = bl;
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setClip(ClipRable clipRable) {
        if (clipRable == null && this.clip == null) {
            return;
        }
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.clip = clipRable;
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public ClipRable getClip() {
        return this.clip;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.fireGraphicsNodeChangeStarted();
        if (this.hints == null) {
            this.hints = new RenderingHints(key, object);
        } else {
            this.hints.put(key, object);
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public void setRenderingHints(Map<RenderingHints.Key, Object> map) {
        this.fireGraphicsNodeChangeStarted();
        if (this.hints == null) {
            this.hints = new RenderingHints(map);
        } else {
            this.hints.putAll(map);
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public void setRenderingHints(RenderingHints renderingHints) {
        this.fireGraphicsNodeChangeStarted();
        this.hints = renderingHints;
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    @Override
    public void setMask(Mask mask) {
        if (mask == null && this.mask == null) {
            return;
        }
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.mask = mask;
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public Mask getMask() {
        return this.mask;
    }

    @Override
    public void setFilter(Filter filter) {
        if (filter == null && this.filter == null) {
            return;
        }
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.filter = filter;
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Filter getGraphicsNodeRable(boolean bl) {
        GraphicsNodeRable graphicsNodeRable = null;
        if (this.graphicsNodeRable != null && (graphicsNodeRable = (GraphicsNodeRable)this.graphicsNodeRable.get()) != null) {
            return graphicsNodeRable;
        }
        if (bl) {
            graphicsNodeRable = new GraphicsNodeRable8Bit(this);
            this.graphicsNodeRable = new WeakReference<GraphicsNodeRable>(graphicsNodeRable);
        }
        return graphicsNodeRable;
    }

    @Override
    public Filter getEnableBackgroundGraphicsNodeRable(boolean bl) {
        GraphicsNodeRable graphicsNodeRable = null;
        if (this.enableBackgroundGraphicsNodeRable != null && (graphicsNodeRable = (GraphicsNodeRable)this.enableBackgroundGraphicsNodeRable.get()) != null) {
            return graphicsNodeRable;
        }
        if (bl) {
            graphicsNodeRable = new GraphicsNodeRable8Bit(this);
            graphicsNodeRable.setUsePrimitivePaint(false);
            this.enableBackgroundGraphicsNodeRable = new WeakReference<GraphicsNodeRable>(graphicsNodeRable);
        }
        return graphicsNodeRable;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        Rectangle2D rectangle2D;
        Object object;
        if (this.composite != null && this.composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)this.composite)).getAlpha() < 0.001f) {
            return;
        }
        object = this.getBounds();
        if (object == null) {
            return;
        }
        Composite composite = null;
        AffineTransform affineTransform = null;
        RenderingHints renderingHints = null;
        Graphics2D graphics2D2 = null;
        if (this.clip != null) {
            graphics2D2 = graphics2D;
            graphics2D = (Graphics2D)graphics2D.create();
            if (this.hints != null) {
                graphics2D.addRenderingHints(this.hints);
            }
            if (this.transform != null) {
                graphics2D.transform(this.transform);
            }
            if (this.composite != null) {
                graphics2D.setComposite(this.composite);
            }
            graphics2D.clip(this.clip.getClipPath());
        } else {
            if (this.hints != null) {
                renderingHints = graphics2D.getRenderingHints();
                graphics2D.addRenderingHints(this.hints);
            }
            if (this.transform != null) {
                affineTransform = graphics2D.getTransform();
                graphics2D.transform(this.transform);
            }
            if (this.composite != null) {
                composite = graphics2D.getComposite();
                graphics2D.setComposite(this.composite);
            }
        }
        Shape shape = graphics2D.getClip();
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_AREA_OF_INTEREST, shape);
        boolean bl = true;
        Shape shape2 = shape;
        if (shape2 != null && !((Rectangle2D)object).intersects((rectangle2D = shape2.getBounds2D()).getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight())) {
            bl = false;
        }
        if (bl) {
            boolean bl2 = false;
            if (this.clip != null && this.clip.getUseAntialiasedClip()) {
                bl2 = this.isAntialiasedClip(graphics2D.getTransform(), graphics2D.getRenderingHints(), this.clip.getClipPath());
            }
            boolean bl3 = this.isOffscreenBufferNeeded();
            if (!(bl3 |= bl2)) {
                this.primitivePaint(graphics2D);
            } else {
                Filter filter = null;
                filter = this.filter == null ? this.getGraphicsNodeRable(true) : this.filter;
                if (this.mask != null) {
                    if (this.mask.getSource() != filter) {
                        this.mask.setSource(filter);
                    }
                    filter = this.mask;
                }
                if (this.clip != null && bl2) {
                    if (this.clip.getSource() != filter) {
                        this.clip.setSource(filter);
                    }
                    filter = this.clip;
                }
                if (graphics2D2 == null) {
                    graphics2D2 = graphics2D;
                    graphics2D = (Graphics2D)graphics2D.create();
                }
                if (bl2) {
                    graphics2D.setClip(null);
                }
                Rectangle2D rectangle2D2 = filter.getBounds2D();
                graphics2D.clip(rectangle2D2);
                GraphicsUtil.drawImage((Graphics2D)graphics2D, (RenderableImage)filter);
                graphics2D.dispose();
                graphics2D = graphics2D2;
                graphics2D2 = null;
            }
        }
        if (graphics2D2 != null) {
            graphics2D.dispose();
        } else {
            if (renderingHints != null) {
                graphics2D.setRenderingHints(renderingHints);
            }
            if (affineTransform != null) {
                graphics2D.setTransform(affineTransform);
            }
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
        }
    }

    private void traceFilter(Filter filter, String string) {
        System.out.println(string + filter.getClass().getName());
        System.out.println(string + filter.getBounds2D());
        Vector vector = filter.getSources();
        int n = vector != null ? vector.size() : 0;
        string = string + "\t";
        for (int i = 0; i < n; ++i) {
            Filter filter2 = (Filter)vector.get(i);
            this.traceFilter(filter2, string);
        }
        System.out.flush();
    }

    protected boolean isOffscreenBufferNeeded() {
        return this.filter != null || this.mask != null || this.composite != null && !AlphaComposite.SrcOver.equals(this.composite);
    }

    protected boolean isAntialiasedClip(AffineTransform affineTransform, RenderingHints renderingHints, Shape shape) {
        if (shape == null) {
            return false;
        }
        Object object = renderingHints.get(RenderingHintsKeyExt.KEY_TRANSCODING);
        if (object == "Printing" || object == "Vector") {
            return false;
        }
        return !(shape instanceof Rectangle2D) || affineTransform.getShearX() != 0.0 || affineTransform.getShearY() != 0.0;
    }

    public void fireGraphicsNodeChangeStarted(GraphicsNode graphicsNode) {
        if (this.changeStartedEvent == null) {
            this.changeStartedEvent = new GraphicsNodeChangeEvent(this, 9800);
        }
        this.changeStartedEvent.setChangeSrc(graphicsNode);
        this.fireGraphicsNodeChangeStarted(this.changeStartedEvent);
        this.changeStartedEvent.setChangeSrc(null);
    }

    public void fireGraphicsNodeChangeStarted() {
        if (this.changeStartedEvent == null) {
            this.changeStartedEvent = new GraphicsNodeChangeEvent(this, 9800);
        } else {
            this.changeStartedEvent.setChangeSrc(null);
        }
        this.fireGraphicsNodeChangeStarted(this.changeStartedEvent);
    }

    public void fireGraphicsNodeChangeStarted(GraphicsNodeChangeEvent graphicsNodeChangeEvent) {
        RootGraphicsNode rootGraphicsNode = this.getRoot();
        if (rootGraphicsNode == null) {
            return;
        }
        List<GraphicsNodeChangeListener> list = rootGraphicsNode.getTreeGraphicsNodeChangeListeners();
        if (list == null) {
            return;
        }
        for (GraphicsNodeChangeListener graphicsNodeChangeListener : list) {
            graphicsNodeChangeListener.changeStarted(graphicsNodeChangeEvent);
        }
    }

    public void fireGraphicsNodeChangeCompleted() {
        RootGraphicsNode rootGraphicsNode;
        if (this.changeCompletedEvent == null) {
            this.changeCompletedEvent = new GraphicsNodeChangeEvent(this, 9801);
        }
        if ((rootGraphicsNode = this.getRoot()) == null) {
            return;
        }
        List<GraphicsNodeChangeListener> list = rootGraphicsNode.getTreeGraphicsNodeChangeListeners();
        if (list == null) {
            return;
        }
        for (GraphicsNodeChangeListener graphicsNodeChangeListener : list) {
            graphicsNodeChangeListener.changeCompleted(this.changeCompletedEvent);
        }
    }

    @Override
    public CompositeGraphicsNode getParent() {
        return this.parent;
    }

    @Override
    public RootGraphicsNode getRoot() {
        return this.root;
    }

    protected void setRoot(RootGraphicsNode rootGraphicsNode) {
        this.root = rootGraphicsNode;
    }

    protected void setParent(CompositeGraphicsNode compositeGraphicsNode) {
        this.parent = compositeGraphicsNode;
    }

    protected void invalidateGeometryCache() {
        if (this.parent != null) {
            this.parent.invalidateGeometryCache();
        }
        this.bounds = null;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = this.filter == null ? this.getPrimitiveBounds() : this.filter.getBounds2D();
            if (this.bounds != null) {
                Rectangle2D rectangle2D;
                if (this.clip != null && (rectangle2D = this.clip.getClipPath().getBounds2D()).intersects(this.bounds)) {
                    Rectangle2D.intersect(this.bounds, rectangle2D, this.bounds);
                }
                if (this.mask != null && (rectangle2D = this.mask.getBounds2D()).intersects(this.bounds)) {
                    Rectangle2D.intersect(this.bounds, rectangle2D, this.bounds);
                }
            }
            this.bounds = this.normalizeRectangle(this.bounds);
            if (HaltingThread.hasBeenHalted()) {
                this.invalidateGeometryCache();
            }
        }
        return this.bounds;
    }

    @Override
    public Rectangle2D getTransformedBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        Rectangle2D rectangle2D = null;
        rectangle2D = this.filter == null ? this.getTransformedPrimitiveBounds(affineTransform) : affineTransform2.createTransformedShape(this.filter.getBounds2D()).getBounds2D();
        if (rectangle2D != null) {
            if (this.clip != null) {
                Rectangle2D.intersect(rectangle2D, affineTransform2.createTransformedShape(this.clip.getClipPath()).getBounds2D(), rectangle2D);
            }
            if (this.mask != null) {
                Rectangle2D.intersect(rectangle2D, affineTransform2.createTransformedShape(this.mask.getBounds2D()).getBounds2D(), rectangle2D);
            }
        }
        return rectangle2D;
    }

    @Override
    public Rectangle2D getTransformedPrimitiveBounds(AffineTransform affineTransform) {
        Rectangle2D rectangle2D = this.getPrimitiveBounds();
        if (rectangle2D == null) {
            return null;
        }
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        return affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
    }

    @Override
    public Rectangle2D getTransformedGeometryBounds(AffineTransform affineTransform) {
        Rectangle2D rectangle2D = this.getGeometryBounds();
        if (rectangle2D == null) {
            return null;
        }
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        return affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
    }

    @Override
    public Rectangle2D getTransformedSensitiveBounds(AffineTransform affineTransform) {
        Rectangle2D rectangle2D = this.getSensitiveBounds();
        if (rectangle2D == null) {
            return null;
        }
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        return affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
    }

    @Override
    public boolean contains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getSensitiveBounds();
        if (rectangle2D == null || !rectangle2D.contains(point2D)) {
            return false;
        }
        switch (this.pointerEventType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.isVisible;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        if (rectangle2D2 == null) {
            return false;
        }
        return rectangle2D2.intersects(rectangle2D);
    }

    @Override
    public GraphicsNode nodeHitAt(Point2D point2D) {
        return this.contains(point2D) ? this : null;
    }

    protected Rectangle2D normalizeRectangle(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        if (rectangle2D.getWidth() < EPSILON) {
            if (rectangle2D.getHeight() < EPSILON) {
                AffineTransform affineTransform = this.getGlobalTransform();
                double d = Math.sqrt(affineTransform.getDeterminant());
                return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), EPSILON / d, EPSILON / d);
            }
            double d = rectangle2D.getHeight() * EPSILON;
            if (d < rectangle2D.getWidth()) {
                d = rectangle2D.getWidth();
            }
            return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d, rectangle2D.getHeight());
        }
        if (rectangle2D.getHeight() < EPSILON) {
            double d = rectangle2D.getWidth() * EPSILON;
            if (d < rectangle2D.getHeight()) {
                d = rectangle2D.getHeight();
            }
            return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d);
        }
        return rectangle2D;
    }
}

