/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedPoints;
import io.sf.carte.echosvg.anim.dom.SVGOMPolygonElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.SVGDecoratedShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.parser.AWTPolygonProducer;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPoint;

public class SVGPolygonElementBridge
extends SVGDecoratedShapeElementBridge {
    @Override
    public String getLocalName() {
        return "polygon";
    }

    @Override
    public Bridge getInstance() {
        return new SVGPolygonElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        Object object;
        SVGOMPolygonElement sVGOMPolygonElement = (SVGOMPolygonElement)element;
        SVGOMAnimatedPoints sVGOMAnimatedPoints = sVGOMPolygonElement.getSVGOMAnimatedPoints();
        short s = sVGOMAnimatedPoints.check();
        if (s >= 0) {
            if (s == 0) {
                shapeNode.setShape(EMPTY_SHAPE);
                shapeNode.setVisible(false);
                return;
            }
            object = new LiveAttributeException(element, element.getLocalName(), s, sVGOMAnimatedPoints.getPoints().toString());
            BridgeException bridgeException = new BridgeException(bridgeContext, (LiveAttributeException)((Object)object));
            SVGPolygonElementBridge.displayErrorOrThrow(bridgeContext, bridgeException);
        }
        try {
            object = sVGOMAnimatedPoints.getAnimatedPoints();
            int n = object.getNumberOfItems();
            if (n == 0) {
                shapeNode.setShape(EMPTY_SHAPE);
                shapeNode.setVisible(false);
            } else {
                AWTPolygonProducer aWTPolygonProducer = new AWTPolygonProducer();
                aWTPolygonProducer.setWindingRule(CSSUtilities.convertFillRule(element));
                aWTPolygonProducer.startPoints();
                for (int i = 0; i < n; ++i) {
                    SVGPoint sVGPoint = object.getItem(i);
                    aWTPolygonProducer.point(sVGPoint.getX(), sVGPoint.getY());
                }
                aWTPolygonProducer.endPoints();
                shapeNode.setVisible(CSSUtilities.convertVisibility(element));
                shapeNode.setShape(aWTPolygonProducer.getShape());
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        String string;
        if (animatedLiveAttributeValue.getNamespaceURI() == null && (string = animatedLiveAttributeValue.getLocalName()).equals("points")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    @Override
    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 16: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }
}

