/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.DocumentLoader;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.URIResolver;
import io.sf.carte.echosvg.bridge.UnitProcessor;
import io.sf.carte.echosvg.bridge.ViewBox;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.dom.AbstractNode;
import io.sf.carte.echosvg.dom.util.XLinkSupport;
import io.sf.carte.echosvg.ext.awt.image.PadMode;
import io.sf.carte.echosvg.ext.awt.image.renderable.AffineRable8Bit;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.PadRable8Bit;
import io.sf.carte.echosvg.ext.awt.image.spi.BrokenLinkProvider;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageTagRegistry;
import io.sf.carte.echosvg.parser.UnitProcessor;
import io.sf.carte.echosvg.util.ParsedURL;
import io.sf.carte.echosvg.util.Platform;
import io.sf.carte.echosvg.util.SVGConstants;
import io.sf.carte.echosvg.util.SoftReferenceCache;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class CursorManager
implements SVGConstants,
ErrorConstants {
    protected static Map<String, Cursor> cursorMap;
    public static final Cursor DEFAULT_CURSOR;
    public static final Cursor ANCHOR_CURSOR;
    public static final Cursor TEXT_CURSOR;
    public static final int DEFAULT_PREFERRED_WIDTH = 32;
    public static final int DEFAULT_PREFERRED_HEIGHT = 32;
    protected BridgeContext ctx;
    protected CursorCache cursorCache = new CursorCache();

    public CursorManager(BridgeContext bridgeContext) {
        this.ctx = bridgeContext;
    }

    public static Cursor getPredefinedCursor(String string) {
        return cursorMap.get(string);
    }

    public Cursor convertCursor(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 9);
        String string = "auto";
        if (value != null) {
            if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
                string = value.getIdentifierValue();
                return this.convertBuiltInCursor(element, string);
            }
            if (value.getCssValueType() == CSSValue.CssType.LIST) {
                int n = value.getLength();
                if (n == 1) {
                    if ((value = value.item(0)).getPrimitiveType() == CSSValue.Type.IDENT) {
                        string = value.getIdentifierValue();
                        return this.convertBuiltInCursor(element, string);
                    }
                } else if (n > 1) {
                    return this.convertSVGCursor(element, value);
                }
            }
        }
        return this.convertBuiltInCursor(element, string);
    }

    public Cursor convertBuiltInCursor(Element element, String string) {
        Cursor cursor = null;
        if (string.charAt(0) == 'a') {
            String string2 = element.getNamespaceURI();
            if ("http://www.w3.org/2000/svg".equals(string2)) {
                String string3 = element.getLocalName();
                if ("a".equals(string3)) {
                    cursor = ANCHOR_CURSOR;
                } else if ("text".equals(string3) || "tspan".equals(string3) || "tref".equals(string3)) {
                    cursor = TEXT_CURSOR;
                } else {
                    if ("image".equals(string3)) {
                        return null;
                    }
                    cursor = DEFAULT_CURSOR;
                }
            } else {
                cursor = DEFAULT_CURSOR;
            }
        } else {
            cursor = CursorManager.getPredefinedCursor(string);
        }
        return cursor;
    }

    public Cursor convertSVGCursor(Element element, Value value) {
        Object object;
        int n = value.getLength();
        Element element2 = null;
        for (int i = 0; i < n - 1; ++i) {
            Cursor cursor;
            String string;
            block4: {
                object = value.item(i);
                if (object.getPrimitiveType() != CSSValue.Type.URI) continue;
                String string2 = object.getURIValue();
                try {
                    element2 = this.ctx.getReferencedElement(element, string2);
                }
                catch (BridgeException bridgeException) {
                    if ("uri.badTarget".equals(bridgeException.getCode())) break block4;
                    throw bridgeException;
                }
            }
            if (element2 == null || !"http://www.w3.org/2000/svg".equals(string = element2.getNamespaceURI()) || !"cursor".equals(element2.getLocalName()) || (cursor = this.convertSVGCursorElement(element2)) == null) continue;
            return cursor;
        }
        Value value2 = value.item(n - 1);
        object = "auto";
        if (value2.getPrimitiveType() == CSSValue.Type.IDENT) {
            object = value2.getIdentifierValue();
        }
        return this.convertBuiltInCursor(element, (String)object);
    }

    public Cursor convertSVGCursorElement(Element element) {
        CursorDescriptor cursorDescriptor;
        Cursor cursor;
        String string = XLinkSupport.getXLinkHref((Element)element);
        if (string.length() == 0) {
            throw new BridgeException(this.ctx, element, "attribute.missing", new Object[]{"xlink:href"});
        }
        String string2 = AbstractNode.getBaseURI((Node)element);
        ParsedURL parsedURL = string2 == null ? new ParsedURL(string) : new ParsedURL(string2, string);
        UnitProcessor.Context context = UnitProcessor.createContext(this.ctx, element);
        String string3 = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string3.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string3, "x", context);
        }
        string3 = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string3.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string3, "y", context);
        }
        if ((cursor = this.cursorCache.getCursor(cursorDescriptor = new CursorDescriptor(parsedURL, f, f2))) != null) {
            return cursor;
        }
        Point2D.Float float_ = new Point2D.Float(f, f2);
        Filter filter = this.cursorHrefToFilter(element, parsedURL, float_);
        if (filter == null) {
            this.cursorCache.clearCursor(cursorDescriptor);
            return null;
        }
        Rectangle rectangle = filter.getBounds2D().getBounds();
        RenderedImage renderedImage = filter.createScaledRendering(rectangle.width, rectangle.height, null);
        Image image = null;
        image = renderedImage instanceof Image ? (Image)((Object)renderedImage) : this.renderedImageToImage(renderedImage);
        float_.x = float_.x < 0.0f ? 0.0f : float_.x;
        float_.y = float_.y < 0.0f ? 0.0f : float_.y;
        float_.x = float_.x > (float)(rectangle.width - 1) ? (float)(rectangle.width - 1) : float_.x;
        float_.y = float_.y > (float)(rectangle.height - 1) ? (float)(rectangle.height - 1) : float_.y;
        Cursor cursor2 = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(Math.round(float_.x), Math.round(float_.y)), parsedURL.toString());
        this.cursorCache.putCursor(cursorDescriptor, cursor2);
        return cursor2;
    }

    protected Filter cursorHrefToFilter(Element element, ParsedURL parsedURL, Point2D point2D) {
        Object object;
        Object object2;
        Object object3;
        AffineRable8Bit affineRable8Bit = null;
        String string = parsedURL.toString();
        Dimension dimension = null;
        DocumentLoader documentLoader = this.ctx.getDocumentLoader();
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        URIResolver uRIResolver = this.ctx.createURIResolver(sVGDocument, documentLoader);
        try {
            object3 = null;
            object2 = uRIResolver.getNode(string, element);
            if (object2.getNodeType() != 9) {
                throw new BridgeException(this.ctx, element, "uri.image.invalid", new Object[]{string});
            }
            object = (SVGDocument)object2;
            this.ctx.initializeDocument((Document)object);
            object3 = object.getRootElement();
            object = this.ctx.getGVTBuilder().build(this.ctx, (Element)object3);
            if (object == null) {
                return null;
            }
            float f = 32.0f;
            float f2 = 32.0f;
            UnitProcessor.Context context = UnitProcessor.createContext(this.ctx, (Element)object3);
            String string2 = object3.getAttribute("width");
            if (string2.length() != 0) {
                f = UnitProcessor.svgHorizontalLengthToUserSpace(string2, "width", context);
            }
            if ((string2 = object3.getAttribute("height")).length() != 0) {
                f2 = UnitProcessor.svgVerticalLengthToUserSpace(string2, "height", context);
            }
            dimension = Toolkit.getDefaultToolkit().getBestCursorSize(Math.round(f), Math.round(f2));
            AffineTransform affineTransform = ViewBox.getPreserveAspectRatioTransform((Element)object3, dimension.width, dimension.height, this.ctx);
            if (affineTransform == null) {
                return null;
            }
            Filter filter = object.getGraphicsNodeRable(true);
            affineRable8Bit = new AffineRable8Bit(filter, affineTransform);
        }
        catch (BridgeException bridgeException) {
            throw bridgeException;
        }
        catch (SecurityException securityException) {
            throw new BridgeException(this.ctx, element, securityException, "uri.unsecure", new Object[]{string});
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (affineRable8Bit == null) {
            object3 = ImageTagRegistry.getRegistry();
            object2 = object3.readURL(parsedURL);
            if (object2 == null) {
                return null;
            }
            if (BrokenLinkProvider.hasBrokenLinkProperty((Filter)object2)) {
                return null;
            }
            object = object2.getBounds2D().getBounds();
            dimension = Toolkit.getDefaultToolkit().getBestCursorSize(object.width, object.height);
            if (object != null && object.width > 0 && object.height > 0) {
                AffineTransform affineTransform = new AffineTransform();
                if ((object.width > dimension.width || object.height > dimension.height) && (affineTransform = ViewBox.getPreserveAspectRatioTransform(new float[]{0.0f, 0.0f, object.width, object.height}, (short)2, true, (float)dimension.width, dimension.height)) == null) {
                    return null;
                }
                affineRable8Bit = new AffineRable8Bit((Filter)object2, affineTransform);
            } else {
                return null;
            }
        }
        object3 = affineRable8Bit.getAffine();
        ((AffineTransform)object3).transform(point2D, point2D);
        object2 = new Rectangle(0, 0, dimension.width, dimension.height);
        object = new PadRable8Bit(affineRable8Bit, (Rectangle2D)object2, PadMode.ZERO_PAD);
        return object;
    }

    protected Image renderedImageToImage(RenderedImage renderedImage) {
        int n = renderedImage.getMinX();
        int n2 = renderedImage.getMinY();
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, new Point(n, n2));
        renderedImage.copyData(writableRaster);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    static {
        Object object;
        DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
        ANCHOR_CURSOR = Cursor.getPredefinedCursor(12);
        TEXT_CURSOR = Cursor.getPredefinedCursor(2);
        cursorMap = new HashMap<String, Cursor>();
        cursorMap.put("crosshair", Cursor.getPredefinedCursor(1));
        cursorMap.put("default", Cursor.getPredefinedCursor(0));
        cursorMap.put("pointer", Cursor.getPredefinedCursor(12));
        cursorMap.put("e-resize", Cursor.getPredefinedCursor(11));
        cursorMap.put("ne-resize", Cursor.getPredefinedCursor(7));
        cursorMap.put("nw-resize", Cursor.getPredefinedCursor(6));
        cursorMap.put("n-resize", Cursor.getPredefinedCursor(8));
        cursorMap.put("se-resize", Cursor.getPredefinedCursor(5));
        cursorMap.put("sw-resize", Cursor.getPredefinedCursor(4));
        cursorMap.put("s-resize", Cursor.getPredefinedCursor(9));
        cursorMap.put("w-resize", Cursor.getPredefinedCursor(10));
        cursorMap.put("text", Cursor.getPredefinedCursor(2));
        cursorMap.put("wait", Cursor.getPredefinedCursor(3));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor cursor = Cursor.getPredefinedCursor(13);
        if (Platform.isOSX()) {
            try {
                object = toolkit.createImage(CursorManager.class.getResource("resources/move.gif"));
                cursor = toolkit.createCustomCursor((Image)object, new Point(11, 11), "move");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cursorMap.put("move", cursor);
        try {
            Image image = toolkit.createImage(CursorManager.class.getResource("resources/help.gif"));
            object = toolkit.createCustomCursor(image, new Point(1, 3), "help");
        }
        catch (Exception exception) {
            object = Cursor.getPredefinedCursor(12);
        }
        cursorMap.put("help", (Cursor)object);
    }

    static class CursorCache
    extends SoftReferenceCache {
        public Cursor getCursor(CursorDescriptor cursorDescriptor) {
            return (Cursor)this.requestImpl(cursorDescriptor);
        }

        public void putCursor(CursorDescriptor cursorDescriptor, Cursor cursor) {
            this.putImpl(cursorDescriptor, cursor);
        }

        public void clearCursor(CursorDescriptor cursorDescriptor) {
            this.clearImpl(cursorDescriptor);
        }
    }

    static class CursorDescriptor {
        ParsedURL purl;
        float x;
        float y;
        String desc;

        public CursorDescriptor(ParsedURL parsedURL, float f, float f2) {
            if (parsedURL == null) {
                throw new IllegalArgumentException();
            }
            this.purl = parsedURL;
            this.x = f;
            this.y = f2;
            this.desc = this.getClass().getName() + "\n\t:[" + this.purl + "]\n\t:[" + f + "]:[" + f2 + "]";
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof CursorDescriptor)) {
                return false;
            }
            CursorDescriptor cursorDescriptor = (CursorDescriptor)object;
            boolean bl = this.purl.equals((Object)cursorDescriptor.purl) && this.x == cursorDescriptor.x && this.y == cursorDescriptor.y;
            return bl;
        }

        public String toString() {
            return this.desc;
        }

        public int hashCode() {
            return this.desc.hashCode();
        }
    }
}

