/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractErrorHandler;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class LogErrorHandler
extends AbstractErrorHandler {
    private static final long serialVersionUID = 1L;
    static Logger log = LoggerFactory.getLogger((String)LogErrorHandler.class.getName());
    private boolean cserrors = false;
    private boolean errors = false;
    private boolean warnings = false;

    @Override
    public boolean hasComputedStyleErrors() {
        return this.cserrors;
    }

    @Override
    public boolean hasErrors() {
        return this.errors || super.hasErrors();
    }

    @Override
    public boolean hasWarnings() {
        return this.warnings || super.hasWarnings();
    }

    @Override
    public void linkedStyleError(Node node, String string) {
        log.error("Error processing linked style: " + string);
        this.errors = true;
    }

    @Override
    public void mediaQueryError(Node node, CSSMediaException cSSMediaException) {
        log.error("Error parsing media text.", (Throwable)cSSMediaException);
        this.errors = true;
    }

    @Override
    public void linkedSheetError(Exception exception, CSSStyleSheet<? extends CSSRule> cSSStyleSheet) {
        String string = cSSStyleSheet.getHref();
        if (string != null) {
            log.error("Error parsing sheet at " + string);
        }
        log.error(((AbstractCSSStyleSheet)cSSStyleSheet).toStyleString(), (Throwable)exception);
        this.errors = true;
    }

    @Override
    public void inlineStyleError(CSSElement cSSElement, Exception exception, String string) {
        log.error(string, (Throwable)exception);
        this.errors = true;
    }

    @Override
    public void computedStyleError(CSSElement cSSElement, String string, CSSPropertyValueException cSSPropertyValueException) {
        log.error("Computed style error [" + string + "]: " + cSSPropertyValueException.getMessage());
        this.cserrors = true;
    }

    @Override
    public void presentationalHintError(CSSElement cSSElement, DOMException dOMException) {
        log.error("Presentational hint error (element " + cSSElement.getTagName() + ")", (Throwable)dOMException);
        this.errors = true;
    }

    @Override
    public void resetComputedStyleErrors() {
        this.cserrors = false;
    }

    @Override
    public void reset() {
        this.errors = true;
        this.warnings = false;
        this.resetComputedStyleErrors();
        super.reset();
    }
}

