/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseBoxShorthandBuilder;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BorderImageBuilder;
import io.sf.carte.doc.style.css.om.PendingValue;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.BufferSimpleWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class BorderBuilder
extends BaseBoxShorthandBuilder {
    private boolean fullBorderImage = false;
    private boolean hasBorderImage = false;
    private boolean borderImageDone = false;
    private final Set<String> unusedSet = new HashSet<String>();

    BorderBuilder(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super("border", baseCSSStyleDeclaration);
    }

    @Override
    protected int getMinimumSetSize() {
        return 3;
    }

    @Override
    protected void appendMinifiedIndividualProperties(StringBuilder stringBuilder) {
        super.appendMinifiedIndividualProperties(stringBuilder);
        if (!this.borderImageDone && this.isAnyBorderImagePropertySet()) {
            this.appendBorderImage(stringBuilder);
        }
    }

    private void appendBorderImage(StringBuilder stringBuilder) {
        BorderImageBuilder borderImageBuilder = new BorderImageBuilder(this.getParentStyle());
        this.assignBorderImageProperty(borderImageBuilder, "border-image-source");
        this.assignBorderImageProperty(borderImageBuilder, "border-image-slice");
        this.assignBorderImageProperty(borderImageBuilder, "border-image-width");
        this.assignBorderImageProperty(borderImageBuilder, "border-image-outset");
        this.assignBorderImageProperty(borderImageBuilder, "border-image-repeat");
        borderImageBuilder.appendMinifiedCssText(stringBuilder);
        this.borderImageDone = true;
    }

    private void assignBorderImageProperty(BorderImageBuilder borderImageBuilder, String string) {
        BaseCSSStyleDeclaration baseCSSStyleDeclaration = this.getParentStyle();
        if (baseCSSStyleDeclaration.isPropertySet(string)) {
            boolean bl = baseCSSStyleDeclaration.isPropertyImportant(string);
            borderImageBuilder.addAssignedProperty(string, bl);
        }
    }

    @Override
    byte checkValuesForInherit(Set<String> set) {
        byte by = this.checkValuesForInherit("border-width", set);
        byte by2 = this.checkValuesForInherit("border-style", set);
        byte by3 = this.checkValuesForInherit("border-color", set);
        if (by == 1 && by2 == 1 && by3 == 1 && this.fullBorderImage) {
            return 1;
        }
        if (by == 2 || by2 == 2 || by3 == 2) {
            return 2;
        }
        return by == 1 || by2 == 1 || by3 == 1 ? (byte)3 : 0;
    }

    @Override
    byte checkValuesForType(CSSValue.Type type, Set<String> set) {
        byte by = this.checkValuesForType(type, "border-width", set);
        byte by2 = this.checkValuesForType(type, "border-style", set);
        byte by3 = this.checkValuesForType(type, "border-color", set);
        if (by == 1 && by2 == 1 && by3 == 1 && this.fullBorderImage) {
            return 1;
        }
        if (by == 2 || by2 == 2 || by3 == 2) {
            return 2;
        }
        return by == 1 || by2 == 1 || by3 == 1 ? (byte)3 : 0;
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        this.setBorderImageState(bl);
        if (this.hasPropertiesToExclude(set)) {
            return 1;
        }
        short s = this.appendWithInternals(stringBuilder, set, bl);
        if (s != 0) {
            return s;
        }
        if (set.size() == 12 || !bl && this.getTotalSetSize() == 12) {
            byte by = this.keywordCheck(stringBuilder, set, bl);
            if (by != 0) {
                return by == 1 ? 0 : 1;
            }
            boolean bl2 = false;
            PropertyValueScore propertyValueScore = new PropertyValueScore(set);
            propertyValueScore.score();
            byte by2 = this.bestState(propertyValueScore);
            int n = propertyValueScore.getScore(by2);
            if (n == -1) {
                bl2 = true;
                propertyValueScore.setEquivalentScores();
                by2 = this.bestState(propertyValueScore);
                n = propertyValueScore.getScore(by2);
                this.buildUnusedSet(set);
            }
            if (this.fullBorderImage) {
                boolean bl3 = this.appendFullSet(stringBuilder, set, propertyValueScore, n, by2, bl);
                if (bl2) {
                    this.appendUnused(stringBuilder, bl);
                }
                if (bl3) {
                    return 0;
                }
            }
            this.appendBorderWidthText(stringBuilder, set, false, propertyValueScore, propertyValueScore.getSameWidthScore(), null, bl);
            this.appendBorderStyleText(stringBuilder, set, false, propertyValueScore, propertyValueScore.getSameStyleScore(), null, bl);
            this.appendBorderColorText(stringBuilder, set, false, propertyValueScore, propertyValueScore.getSameColorScore(), null, bl);
            if (this.hasBorderImage && !this.borderImageDone) {
                this.appendBorderImage(stringBuilder);
            }
            return 0;
        }
        if (this.hasBorderImage && !this.borderImageDone) {
            this.appendBorderImage(stringBuilder);
        }
        PropertyCount propertyCount = new PropertyCount();
        propertyCount.count(set, bl);
        if (set.size() < 3 && (bl || !this.isInShadowedSet(set, propertyCount))) {
            return 1;
        }
        PropertyValueScore propertyValueScore = new PropertyValueScore(set);
        propertyValueScore.score(propertyCount);
        return this.appendPartialShorthands(stringBuilder, set, propertyValueScore, propertyCount, bl);
    }

    private short appendWithInternals(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.fullBorderImage) {
            for (String string : stringArray = this.getLonghandProperties("border-image")) {
                StyleValue styleValue;
                if (this.getParentStyle().isPropertyImportant(string) != bl || (styleValue = this.getCSSValue(string)).getPrimitiveType() != CSSValue.Type.INTERNAL) continue;
                bl2 = true;
                String string2 = ((PendingValue)styleValue).getShorthandName();
                hashSet.add(string2);
                if (!string2.equals(this.getShorthandName())) continue;
                bl3 = true;
            }
        }
        stringArray = set.iterator();
        while (stringArray.hasNext()) {
            String string = (String)stringArray.next();
            StyleValue styleValue = this.getCSSValue(string);
            if (styleValue.getPrimitiveType() != CSSValue.Type.INTERNAL) continue;
            bl2 = true;
            String string3 = ((PendingValue)styleValue).getShorthandName();
            if (!string3.equals(this.getShorthandName())) continue;
            stringArray.remove();
            bl3 = true;
        }
        if (bl2) {
            if (!bl3) {
                return 2;
            }
        } else {
            return 0;
        }
        ShorthandValue shorthandValue = (ShorthandValue)this.getCSSValue(this.getShorthandName());
        this.getParentStyle().appendShorthandMinifiedCssText(stringBuilder, this.getShorthandName(), shorthandValue);
        return 2;
    }

    private byte keywordCheck(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        byte by = this.checkValuesForInherit(set);
        if (by == 1) {
            stringBuilder.append("border:inherit");
            this.appendPriority(stringBuilder, bl);
            if (this.hasBorderImage && !this.borderImageDone && !this.isBorderImageSetToKeyword(CSSValue.Type.INHERIT)) {
                this.appendBorderImage(stringBuilder);
            }
            return 1;
        }
        if (by == 2) {
            return 2;
        }
        byte by2 = this.checkValuesForType(CSSValue.Type.REVERT, set);
        if (by2 == 1) {
            stringBuilder.append("border:revert");
            this.appendPriority(stringBuilder, bl);
            if (this.hasBorderImage && !this.borderImageDone && !this.isBorderImageSetToKeyword(CSSValue.Type.REVERT)) {
                this.appendBorderImage(stringBuilder);
            }
            return 1;
        }
        if (by2 == 2) {
            return 2;
        }
        return 0;
    }

    private boolean isInShadowedSet(Set<String> set, PropertyCount propertyCount) {
        for (String string : set) {
            if (this.isInShadowedSet(string, propertyCount)) continue;
            return false;
        }
        return true;
    }

    private boolean isInShadowedSet(String string, PropertyCount propertyCount) {
        BaseCSSStyleDeclaration baseCSSStyleDeclaration = this.getParentStyle();
        return "border-top-width".equals(string) ? propertyCount.countBWidth == 4 || baseCSSStyleDeclaration.isPropertySet("border-top-style") && baseCSSStyleDeclaration.isPropertySet("border-top-color") : ("border-top-style".equals(string) ? propertyCount.countBStyle == 4 || baseCSSStyleDeclaration.isPropertySet("border-top-width") && baseCSSStyleDeclaration.isPropertySet("border-top-color") : ("border-top-color".equals(string) ? propertyCount.countBColor == 4 || baseCSSStyleDeclaration.isPropertySet("border-top-width") && baseCSSStyleDeclaration.isPropertySet("border-top-style") : ("border-right-width".equals(string) ? propertyCount.countBWidth == 4 || baseCSSStyleDeclaration.isPropertySet("border-right-style") && baseCSSStyleDeclaration.isPropertySet("border-right-color") : ("border-right-style".equals(string) ? propertyCount.countBStyle == 4 || baseCSSStyleDeclaration.isPropertySet("border-right-width") && baseCSSStyleDeclaration.isPropertySet("border-right-color") : ("border-right-color".equals(string) ? propertyCount.countBColor == 4 || baseCSSStyleDeclaration.isPropertySet("border-right-width") && baseCSSStyleDeclaration.isPropertySet("border-right-style") : ("border-bottom-width".equals(string) ? propertyCount.countBWidth == 4 || baseCSSStyleDeclaration.isPropertySet("border-bottom-style") && baseCSSStyleDeclaration.isPropertySet("border-bottom-color") : ("border-bottom-style".equals(string) ? propertyCount.countBStyle == 4 || baseCSSStyleDeclaration.isPropertySet("border-bottom-width") && baseCSSStyleDeclaration.isPropertySet("border-bottom-color") : ("border-bottom-color".equals(string) ? propertyCount.countBColor == 4 || baseCSSStyleDeclaration.isPropertySet("border-bottom-width") && baseCSSStyleDeclaration.isPropertySet("border-bottom-style") : ("border-left-width".equals(string) ? propertyCount.countBWidth == 4 || baseCSSStyleDeclaration.isPropertySet("border-left-style") && baseCSSStyleDeclaration.isPropertySet("border-left-color") : ("border-left-style".equals(string) ? propertyCount.countBStyle == 4 || baseCSSStyleDeclaration.isPropertySet("border-left-width") && baseCSSStyleDeclaration.isPropertySet("border-left-color") : "border-left-color".equals(string) && (propertyCount.countBColor == 4 || baseCSSStyleDeclaration.isPropertySet("border-left-width") && baseCSSStyleDeclaration.isPropertySet("border-left-style"))))))))))));
    }

    private byte bestState(PropertyValueScore propertyValueScore) {
        int n = 0;
        int n2 = propertyValueScore.getWidthState().getBestState() + propertyValueScore.getStyleState().getBestState() + propertyValueScore.getColorState().getBestState();
        int n3 = n2 % 5;
        if (n3 > 1) {
            n = 1;
        } else if (n2 > 7) {
            n = 5;
        }
        return (byte)n;
    }

    private boolean appendFullSet(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, int n, byte by, boolean bl) {
        if (n == 63) {
            Set set2 = propertyValueScore.getEquivWidthSet(propertyValueScore.getSameWidthScore());
            Set set3 = propertyValueScore.getEquivStyleSet(propertyValueScore.getSameStyleScore());
            Set set4 = propertyValueScore.getEquivColorSet(propertyValueScore.getSameColorScore());
            this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, set2, set3, set4, bl);
            if (this.mustSerializeBorderImage(by)) {
                this.appendBorderImage(stringBuilder);
            }
            this.borderImageDone = true;
            return true;
        }
        if (propertyValueScore.getSameStyleScore() == propertyValueScore.getSameWidthScore() && propertyValueScore.getSameColorScore() == propertyValueScore.getSameWidthScore()) {
            if (propertyValueScore.getSameWidthScore() == 21) {
                this.appendFullBorderWithWidthStyleColor(stringBuilder, set, propertyValueScore, by, bl);
                return true;
            }
            if (this.appendFullBorderPlusSide(stringBuilder, set, propertyValueScore, by, bl)) {
                return true;
            }
        }
        this.appendFullBorderPlusMore(stringBuilder, set, propertyValueScore, by, bl);
        if (this.mustSerializeBorderImage(by)) {
            this.appendBorderImage(stringBuilder);
        }
        this.borderImageDone = true;
        return true;
    }

    private void appendFullBorderWithWidthStyleColor(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, boolean bl) {
        Set set2 = propertyValueScore.getEquivWidthSet(propertyValueScore.getSameWidthScore());
        Set set3 = propertyValueScore.getEquivStyleSet(propertyValueScore.getSameStyleScore());
        Set set4 = propertyValueScore.getEquivColorSet(propertyValueScore.getSameColorScore());
        int n = set2.size();
        if (n == 3 || n == 2) {
            set2 = null;
        }
        if ((n = set3.size()) == 3 || n == 2) {
            set3 = null;
        }
        if ((n = set4.size()) == 3 || n == 2) {
            set4 = null;
        }
        this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, set2, set3, set4, bl);
        if (propertyValueScore.getWidthState().getBestState() != by || propertyValueScore.getSameWidthScore() != 21) {
            this.appendBorderWidthText(stringBuilder, set, false, propertyValueScore, propertyValueScore.getSameWidthScore(), null, bl);
        }
        if (propertyValueScore.getStyleState().getBestState() != by || propertyValueScore.getSameStyleScore() != 21) {
            this.appendBorderStyleText(stringBuilder, set, false, propertyValueScore, propertyValueScore.getSameStyleScore(), null, bl);
        }
        if (propertyValueScore.getColorState().getBestState() != by || propertyValueScore.getSameColorScore() != 21) {
            this.appendBorderColorText(stringBuilder, set, false, propertyValueScore, propertyValueScore.getSameColorScore(), null, bl);
        }
        if (this.mustSerializeBorderImage(by)) {
            this.appendBorderImage(stringBuilder);
        }
        this.borderImageDone = true;
    }

    private boolean appendFullBorderPlusSide(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, boolean bl) {
        int n = propertyValueScore.getSameWidthScore();
        if (n == 17) {
            Set set2 = propertyValueScore.getEquivWidthSet(n);
            Set set3 = propertyValueScore.getEquivStyleSet(n);
            Set set4 = propertyValueScore.getEquivColorSet(n);
            this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, set2, set3, set4, bl);
            this.appendBorderBottomText(stringBuilder, set, propertyValueScore, by, bl);
            if (this.mustSerializeBorderImage(by)) {
                this.appendBorderImage(stringBuilder);
            }
            this.borderImageDone = true;
            return true;
        }
        if (n == 5) {
            Set set5 = propertyValueScore.getEquivWidthSet(n);
            Set set6 = propertyValueScore.getEquivStyleSet(n);
            Set set7 = propertyValueScore.getEquivColorSet(n);
            this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, set5, set6, set7, bl);
            this.appendBorderRightText(stringBuilder, set, propertyValueScore, by, bl);
            if (this.mustSerializeBorderImage(by)) {
                this.appendBorderImage(stringBuilder);
            }
            this.borderImageDone = true;
            return true;
        }
        if (n == 16) {
            if (this.equivalentProperties("border-right-width", "border-bottom-width", propertyValueScore.getWidthState().getBestState()) && this.equivalentProperties("border-right-style", "border-bottom-style", propertyValueScore.getStyleState().getBestState()) && this.equivalentProperties("border-right-color", "border-bottom-color", propertyValueScore.getColorState().getBestState())) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add("border-right-width");
                hashSet.add("border-left-width");
                HashSet<String> hashSet2 = new HashSet<String>();
                hashSet2.add("border-right-style");
                hashSet2.add("border-left-style");
                HashSet<String> hashSet3 = new HashSet<String>();
                hashSet3.add("border-right-color");
                hashSet3.add("border-left-color");
                this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, hashSet, hashSet2, hashSet3, bl);
                this.appendBorderTopText(stringBuilder, set, propertyValueScore, by, bl);
            } else {
                Set set8 = propertyValueScore.getEquivWidthSet(n);
                Set set9 = propertyValueScore.getEquivStyleSet(n);
                Set set10 = propertyValueScore.getEquivColorSet(n);
                this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, set8, set9, set10, bl);
                this.appendBorderTopText(stringBuilder, set, propertyValueScore, by, bl);
                this.appendBorderBottomText(stringBuilder, set, propertyValueScore, by, bl);
            }
            if (this.mustSerializeBorderImage(by)) {
                this.appendBorderImage(stringBuilder);
            }
            this.borderImageDone = true;
            return true;
        }
        if (n == 4) {
            if (this.equivalentProperties("border-right-width", "border-bottom-width", propertyValueScore.getWidthState().getBestState()) && this.equivalentProperties("border-right-style", "border-bottom-style", propertyValueScore.getStyleState().getBestState()) && this.equivalentProperties("border-right-color", "border-bottom-color", propertyValueScore.getColorState().getBestState())) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add("border-top-width");
                hashSet.add("border-bottom-width");
                HashSet<String> hashSet4 = new HashSet<String>();
                hashSet4.add("border-top-style");
                hashSet4.add("border-bottom-style");
                HashSet<String> hashSet5 = new HashSet<String>();
                hashSet5.add("border-top-color");
                hashSet5.add("border-bottom-color");
                this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, hashSet, hashSet4, hashSet5, bl);
                this.appendBorderLeftText(stringBuilder, set, propertyValueScore, by, bl);
            } else {
                Set set11 = propertyValueScore.getEquivWidthSet(n);
                Set set12 = propertyValueScore.getEquivStyleSet(n);
                Set set13 = propertyValueScore.getEquivColorSet(n);
                this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, set11, set12, set13, bl);
                this.appendBorderRightText(stringBuilder, set, propertyValueScore, by, bl);
                this.appendBorderLeftText(stringBuilder, set, propertyValueScore, by, bl);
            }
            if (this.mustSerializeBorderImage(by)) {
                this.appendBorderImage(stringBuilder);
            }
            this.borderImageDone = true;
            return true;
        }
        if (n == 1) {
            Set set14 = propertyValueScore.getEquivWidthSet(n);
            Set set15 = propertyValueScore.getEquivStyleSet(n);
            Set set16 = propertyValueScore.getEquivColorSet(n);
            this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, set14, set15, set16, bl);
            this.appendBorderRightText(stringBuilder, set, propertyValueScore, by, bl);
            this.appendBorderBottomText(stringBuilder, set, propertyValueScore, by, bl);
            if (this.mustSerializeBorderImage(by)) {
                this.appendBorderImage(stringBuilder);
            }
            this.borderImageDone = true;
            return true;
        }
        if (this.equivalentProperties("border-right-width", "border-top-width", propertyValueScore.getWidthState().getBestState()) && this.equivalentProperties("border-right-style", "border-top-style", propertyValueScore.getStyleState().getBestState()) && this.equivalentProperties("border-right-color", "border-top-color", propertyValueScore.getColorState().getBestState())) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("border-top-width");
            hashSet.add("border-right-width");
            HashSet<String> hashSet6 = new HashSet<String>();
            hashSet6.add("border-top-style");
            hashSet6.add("border-right-style");
            HashSet<String> hashSet7 = new HashSet<String>();
            hashSet7.add("border-top-color");
            hashSet7.add("border-right-color");
            this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, hashSet, hashSet6, hashSet7, bl);
            this.appendBorderBottomText(stringBuilder, set, propertyValueScore, by, bl);
            this.appendBorderLeftText(stringBuilder, set, propertyValueScore, by, bl);
            if (this.mustSerializeBorderImage(by)) {
                this.appendBorderImage(stringBuilder);
            }
            this.borderImageDone = true;
            return true;
        }
        if (this.equivalentProperties("border-left-width", "border-bottom-width", propertyValueScore.getWidthState().getBestState()) && this.equivalentProperties("border-left-style", "border-bottom-style", propertyValueScore.getStyleState().getBestState()) && this.equivalentProperties("border-left-color", "border-bottom-color", propertyValueScore.getColorState().getBestState())) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("border-bottom-width");
            hashSet.add("border-left-width");
            HashSet<String> hashSet8 = new HashSet<String>();
            hashSet8.add("border-bottom-style");
            hashSet8.add("border-left-style");
            HashSet<String> hashSet9 = new HashSet<String>();
            hashSet9.add("border-bottom-color");
            hashSet9.add("border-left-color");
            this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, hashSet, hashSet8, hashSet9, bl);
            this.appendBorderTopText(stringBuilder, set, propertyValueScore, by, bl);
            this.appendBorderRightText(stringBuilder, set, propertyValueScore, by, bl);
            if (this.mustSerializeBorderImage(by)) {
                this.appendBorderImage(stringBuilder);
            }
            this.borderImageDone = true;
            return true;
        }
        return false;
    }

    private void appendBorderTopText(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, boolean bl) {
        if (set.contains("border-top-width") && set.contains("border-top-style") && set.contains("border-top-color")) {
            stringBuilder.append("border-top:");
            this.appendBorderSideText(stringBuilder, set, propertyValueScore, by, "border-top-width", "border-top-style", "border-top-color", bl);
        }
    }

    private void appendBorderRightText(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, boolean bl) {
        if (set.contains("border-right-width") && set.contains("border-right-style") && set.contains("border-right-color")) {
            stringBuilder.append("border-right:");
            this.appendBorderSideText(stringBuilder, set, propertyValueScore, by, "border-right-width", "border-right-style", "border-right-color", bl);
        }
    }

    private void appendBorderBottomText(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, boolean bl) {
        if (set.contains("border-bottom-width") && set.contains("border-bottom-style") && set.contains("border-bottom-color")) {
            stringBuilder.append("border-bottom:");
            this.appendBorderSideText(stringBuilder, set, propertyValueScore, by, "border-bottom-width", "border-bottom-style", "border-bottom-color", bl);
        }
    }

    private void appendBorderLeftText(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, boolean bl) {
        if (set.contains("border-left-width") && set.contains("border-left-style") && set.contains("border-left-color")) {
            stringBuilder.append("border-left:");
            this.appendBorderSideText(stringBuilder, set, propertyValueScore, by, "border-left-width", "border-left-style", "border-left-color", bl);
        }
    }

    private void buildUnusedSet(Set<String> set) {
        this.unusedSet.clear();
        for (String string : set) {
            this.unusedSet.add(string);
        }
    }

    private boolean isAnyBorderImagePropertySet() {
        BaseCSSStyleDeclaration baseCSSStyleDeclaration = this.getParentStyle();
        return baseCSSStyleDeclaration.isPropertySet("border-image-source") || baseCSSStyleDeclaration.isPropertySet("border-image-slice") || baseCSSStyleDeclaration.isPropertySet("border-image-width") || baseCSSStyleDeclaration.isPropertySet("border-image-outset") || baseCSSStyleDeclaration.isPropertySet("border-image-repeat");
    }

    private void setBorderImageState(boolean bl) {
        boolean bl2 = this.isPropertyAssigned("border-image-source");
        boolean bl3 = this.isPropertyAssigned("border-image-slice");
        boolean bl4 = this.isPropertyAssigned("border-image-width");
        boolean bl5 = this.isPropertyAssigned("border-image-outset");
        boolean bl6 = this.isPropertyAssigned("border-image-repeat");
        this.fullBorderImage = bl2 && bl3 && bl4 && bl5 && bl6;
        this.hasBorderImage = bl2 || bl3 || bl4 || bl5 || bl6;
    }

    private boolean mustSerializeBorderImage(byte by) {
        switch (by) {
            case 0: {
                return !this.isBorderImageSetToInitial();
            }
            case 1: {
                return !this.isBorderImageSetToKeyword(CSSValue.Type.INHERIT);
            }
            case 5: {
                return !this.isBorderImageSetToKeyword(CSSValue.Type.REVERT);
            }
        }
        return true;
    }

    private boolean isBorderImageSetToInitial() {
        return this.isInitialValue("border-image-source") && this.isInitialValue("border-image-slice") && this.isInitialValue("border-image-width") && this.isInitialValue("border-image-outset") && this.isInitialValue("border-image-repeat");
    }

    private boolean isBorderImageSetToKeyword(CSSValue.Type type) {
        return this.isValueOfType(type, "border-image-source") && this.isValueOfType(type, "border-image-slice") && this.isValueOfType(type, "border-image-width") && this.isValueOfType(type, "border-image-outset") && this.isValueOfType(type, "border-image-repeat");
    }

    private int appendPartialShorthands(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, PropertyCount propertyCount, boolean bl) {
        boolean bl2;
        if (propertyValueScore.hasMixedStates()) {
            propertyValueScore.setEquivalentScores();
        }
        this.appendSideProperties(stringBuilder, !(bl2 = this.appendPartialProperties(stringBuilder, set, propertyValueScore, false, propertyCount, bl)), propertyCount, bl);
        this.appendUnused(stringBuilder, bl);
        return 0;
    }

    private boolean appendPartialProperties(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, boolean bl, PropertyCount propertyCount, boolean bl2) {
        boolean bl3 = false;
        if (propertyCount.countBColor == 4) {
            this.appendBorderColorText(stringBuilder, set, bl, propertyValueScore, propertyValueScore.getSameColorScore(), propertyCount, bl2);
            bl3 = true;
        }
        if (propertyCount.countBStyle == 4) {
            this.appendBorderStyleText(stringBuilder, set, bl, propertyValueScore, propertyValueScore.getSameStyleScore(), propertyCount, bl2);
            bl3 = true;
        }
        if (propertyCount.countBWidth == 4) {
            this.appendBorderWidthText(stringBuilder, set, bl, propertyValueScore, propertyValueScore.getSameWidthScore(), propertyCount, bl2);
            bl3 = true;
        }
        return bl3;
    }

    private void appendSideProperties(StringBuilder stringBuilder, boolean bl, PropertyCount propertyCount, boolean bl2) {
        if (propertyCount.countBTop == 3 && this.appendBorderTopText(stringBuilder, bl)) {
            this.appendPriority(stringBuilder, bl2);
        }
        if (propertyCount.countBRight == 3 && this.appendBorderRightText(stringBuilder, bl)) {
            this.appendPriority(stringBuilder, bl2);
        }
        if (propertyCount.countBBottom == 3 && this.appendBorderBottomText(stringBuilder, bl)) {
            this.appendPriority(stringBuilder, bl2);
        }
        if (propertyCount.countBLeft == 3 && this.appendBorderLeftText(stringBuilder, bl)) {
            this.appendPriority(stringBuilder, bl2);
        }
    }

    private void appendUnused(StringBuilder stringBuilder, boolean bl) {
        if (!this.unusedSet.isEmpty()) {
            for (String string : this.unusedSet) {
                stringBuilder.append(string).append(':').append(this.getCSSValue(string).getMinifiedCssText(string));
                this.appendPriority(stringBuilder, bl);
            }
        }
    }

    private void appendFullBorderPlusMore(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, boolean bl) {
        boolean bl2 = propertyValueScore.getWidthState().getBestState() != by;
        boolean bl3 = propertyValueScore.getStyleState().getBestState() != by;
        boolean bl4 = propertyValueScore.getColorState().getBestState() != by;
        int n = propertyValueScore.getSameWidthScore();
        int n2 = propertyValueScore.getSameStyleScore();
        int n3 = propertyValueScore.getSameColorScore();
        boolean bl5 = n != 21;
        boolean bl6 = n2 != 21;
        boolean bl7 = n3 != 21;
        Set set2 = bl5 ? null : propertyValueScore.getEquivWidthSet(n);
        Set set3 = bl6 ? null : propertyValueScore.getEquivStyleSet(n2);
        Set set4 = bl7 ? null : propertyValueScore.getEquivColorSet(n3);
        StringBuilder stringBuilder2 = new StringBuilder(80);
        if (bl2) {
            this.appendBorderWidthText(stringBuilder2, set, false, propertyValueScore, n, null, bl);
        } else if (bl5) {
            if (n == 17) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-bottom-width");
                set2 = propertyValueScore.getEquivWidthSet(17);
            } else if (n == 16 && this.equivalentProperties("border-right-width", "border-bottom-width", propertyValueScore.getWidthState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-top-width");
                set2 = propertyValueScore.getEquivWidthSet(15);
            } else if (n == 5) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-right-width");
                set2 = propertyValueScore.getEquivWidthSet(5);
            } else if (n == 4 && this.equivalentProperties("border-top-width", "border-right-width", propertyValueScore.getWidthState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-left-width");
                set2 = propertyValueScore.getEquivWidthSet(4);
            } else {
                this.appendBorderWidthText(stringBuilder2, set, false, propertyValueScore, n, null, bl);
            }
        }
        if (bl3) {
            this.appendBorderStyleText(stringBuilder2, set, false, propertyValueScore, n2, null, bl);
        } else if (bl6) {
            if (n2 == 17) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-bottom-style");
                set3 = propertyValueScore.getEquivStyleSet(17);
            } else if (n2 == 16 && this.equivalentProperties("border-right-style", "border-bottom-style", propertyValueScore.getStyleState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-top-style");
                set3 = propertyValueScore.getEquivStyleSet(15);
            } else if (n2 == 5) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-right-style");
                set3 = propertyValueScore.getEquivStyleSet(5);
            } else if (n2 == 4 && this.equivalentProperties("border-top-style", "border-right-style", propertyValueScore.getStyleState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-left-style");
                set3 = propertyValueScore.getEquivStyleSet(4);
            } else {
                this.appendBorderStyleText(stringBuilder2, set, false, propertyValueScore, n2, null, bl);
            }
        }
        if (bl4) {
            this.appendBorderColorText(stringBuilder2, set, false, propertyValueScore, n3, null, bl);
        } else if (bl7) {
            if (n3 == 17) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-bottom-color");
                set4 = propertyValueScore.getEquivColorSet(17);
            } else if (n3 == 16 && this.equivalentProperties("border-right-color", "border-bottom-color", propertyValueScore.getColorState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-top-color");
                set4 = propertyValueScore.getEquivColorSet(15);
            } else if (n3 == 5) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-right-color");
                set4 = propertyValueScore.getEquivColorSet(5);
            } else if (n3 == 4 && this.equivalentProperties("border-top-color", "border-right-color", propertyValueScore.getColorState().getBestState())) {
                this.appendStandAlonePropertyAndPriority(stringBuilder2, set, bl, "border-left-color");
                set4 = propertyValueScore.getEquivColorSet(4);
            } else {
                this.appendBorderColorText(stringBuilder2, set, false, propertyValueScore, n3, null, bl);
            }
        }
        this.appendFullBorderText(stringBuilder, set, propertyValueScore, by, set2, set3, set4, bl);
        stringBuilder.append((CharSequence)stringBuilder2);
    }

    private void appendFullBorderText(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, Set<String> set2, Set<String> set3, Set<String> set4, boolean bl) {
        StyleValue styleValue;
        String string;
        StyleValue styleValue2;
        String string2;
        StyleValue styleValue3;
        String string3;
        if (set2 != null && (string3 = this.liveMember(set, set2, propertyValueScore, by)) != null) {
            styleValue3 = this.getCSSValue(string3);
        } else {
            string3 = "border-top-width";
            styleValue3 = null;
        }
        if (set3 != null && (string2 = this.liveMember(set, set3, propertyValueScore, by)) != null) {
            styleValue2 = this.getCSSValue(string2);
        } else {
            string2 = "border-top-style";
            styleValue2 = null;
        }
        if (set4 != null && (string = this.liveMember(set, set4, propertyValueScore, by)) != null) {
            styleValue = this.getCSSValue(string);
        } else {
            string = "border-top-color";
            styleValue = null;
        }
        stringBuilder.append("border:");
        this.appendBorderText(stringBuilder, set, propertyValueScore, by, string3, styleValue3, string2, styleValue2, string, styleValue, bl);
        this.removeFromUnused(set2);
        this.removeFromUnused(set3);
        this.removeFromUnused(set4);
    }

    private void removeFromUnused(Set<String> set) {
        if (set != null) {
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                this.unusedSet.remove(iterator.next());
            }
        }
    }

    private String liveMember(Set<String> set, Set<String> set2, PropertyValueScore propertyValueScore, byte by) {
        for (String string : set2) {
            if (!set.contains(string) || !this.isLiveProperty(string, by)) continue;
            return string;
        }
        return null;
    }

    private void appendBorderSideText(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, String string, String string2, String string3, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>(3);
        if (set.contains(string)) {
            hashSet.add(string);
        }
        if (set.contains(string2)) {
            hashSet.add(string2);
        }
        if (set.contains(string3)) {
            hashSet.add(string3);
        }
        StyleValue styleValue = this.getCSSValue(string);
        StyleValue styleValue2 = this.getCSSValue(string2);
        StyleValue styleValue3 = this.getCSSValue(string3);
        this.appendBorderText(stringBuilder, hashSet, propertyValueScore, by, string, styleValue, string2, styleValue2, string3, styleValue3, bl);
    }

    private void appendBorderText(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, String string, StyleValue styleValue, String string2, StyleValue styleValue2, String string3, StyleValue styleValue3, boolean bl) {
        this.appendBorderTextTriplet(stringBuilder, set, propertyValueScore, by, string, styleValue, string2, styleValue2, string3, styleValue3);
        this.appendPriority(stringBuilder, bl);
    }

    private void appendBorderTextTriplet(StringBuilder stringBuilder, Set<String> set, PropertyValueScore propertyValueScore, byte by, String string, StyleValue styleValue, String string2, StyleValue styleValue2, String string3, StyleValue styleValue3) {
        boolean bl = false;
        if (string != null && set.contains(string) && this.isNotInitialValue(styleValue, string) && this.isLiveState(styleValue, by)) {
            String string4 = styleValue.getMinifiedCssText(string);
            stringBuilder.append(string4);
            bl = true;
        }
        if (string2 != null && set.contains(string2) && this.isNotInitialValue(styleValue2, string2) && this.isLiveState(styleValue2, by)) {
            if (bl) {
                if (by != 0) {
                    return;
                }
                stringBuilder.append(' ');
            }
            stringBuilder.append(styleValue2.getMinifiedCssText(string2));
            bl = true;
        }
        if (string3 != null && set.contains(string3) && this.isNotInitialValue(styleValue3, string3) && this.isLiveState(styleValue3, by)) {
            if (bl) {
                if (by != 0) {
                    return;
                }
                stringBuilder.append(' ');
            }
            stringBuilder.append(styleValue3.getMinifiedCssText(string3));
            bl = true;
        }
        if (!bl) {
            stringBuilder.append("none");
        }
    }

    private void appendStandAlonePropertyAndPriority(StringBuilder stringBuilder, Set<String> set, boolean bl, String string) {
        if (set.contains(string)) {
            stringBuilder.append(string).append(':').append(this.getCSSValue(string).getCssText());
            this.appendPriority(stringBuilder, bl);
        }
    }

    private boolean appendBorderWidthText(StringBuilder stringBuilder, Set<String> set, boolean bl, PropertyValueScore propertyValueScore, int n, PropertyCount propertyCount, boolean bl2) {
        return this.appendBorderPropertyBoxText(stringBuilder, set, bl, propertyValueScore, n, propertyValueScore.getWidthState().getBestState(), propertyCount, "border-width:", "border-top-width", "border-right-width", "border-bottom-width", "border-left-width", "medium", bl2);
    }

    private boolean appendBorderStyleText(StringBuilder stringBuilder, Set<String> set, boolean bl, PropertyValueScore propertyValueScore, int n, PropertyCount propertyCount, boolean bl2) {
        return this.appendBorderPropertyBoxText(stringBuilder, set, bl, propertyValueScore, n, propertyValueScore.getStyleState().getBestState(), propertyCount, "border-style:", "border-top-style", "border-right-style", "border-bottom-style", "border-left-style", "none", bl2);
    }

    private boolean appendBorderColorText(StringBuilder stringBuilder, Set<String> set, boolean bl, PropertyValueScore propertyValueScore, int n, PropertyCount propertyCount, boolean bl2) {
        return this.appendBorderPropertyBoxText(stringBuilder, set, bl, propertyValueScore, n, propertyValueScore.getColorState().getBestState(), propertyCount, "border-color:", "border-top-color", "border-right-color", "border-bottom-color", "border-left-color", "currentcolor", bl2);
    }

    private boolean appendBorderPropertyBoxText(StringBuilder stringBuilder, Set<String> set, boolean bl, PropertyValueScore propertyValueScore, int n, byte by, PropertyCount propertyCount, String string, String string2, String string3, String string4, String string5, String string6, boolean bl2) {
        if (!(set.contains(string2) || set.contains(string3) || set.contains(string4) || set.contains(string5))) {
            return false;
        }
        if (!(!bl || this.unusedSet.contains(string2) || this.unusedSet.contains(string3) || this.unusedSet.contains(string4) || this.unusedSet.contains(string5))) {
            return false;
        }
        if (propertyCount != null) {
            if (n == 16) {
                if (propertyCount.countBTop == 3 && propertyCount.countBBottom == 3) {
                    n = 21;
                    string2 = null;
                    string4 = null;
                } else if (this.equivalentProperties(string4, string3, by)) {
                    if (propertyCount.countBTop == 3) {
                        n = 21;
                        string2 = null;
                    }
                } else if (propertyCount.countBTop == 3) {
                    n = 20;
                    string2 = null;
                } else if (propertyCount.countBBottom == 3) {
                    n = 20;
                    string4 = null;
                }
            } else if (n == 17) {
                if (propertyCount.countBBottom == 3) {
                    n = 21;
                    string4 = null;
                }
            } else if (n == 20) {
                if (propertyCount.countBTop == 3 && propertyCount.countBBottom == 3) {
                    n = 21;
                    string2 = null;
                    string4 = null;
                } else if (propertyCount.countBRight == 3 && propertyCount.countBLeft == 3) {
                    n = 21;
                    string3 = null;
                    string5 = null;
                }
            } else if (n == 5) {
                if (propertyCount.countBRight == 3) {
                    n = 21;
                    string3 = null;
                } else if (propertyCount.countBLeft == 3) {
                    n = 20;
                    string5 = null;
                }
            } else if (n == 4) {
                if (propertyCount.countBRight == 3 && propertyCount.countBLeft == 3) {
                    n = 21;
                    string3 = null;
                    string5 = null;
                } else if (this.equivalentProperties(string2, string3, by)) {
                    if (propertyCount.countBLeft == 3) {
                        n = 21;
                        string5 = null;
                    }
                } else if (propertyCount.countBRight == 3) {
                    n = 20;
                    string3 = null;
                } else if (propertyCount.countBLeft == 3) {
                    n = 20;
                    string5 = null;
                }
            } else if (n == 1) {
                if (this.equivalentProperties(string4, string3, by)) {
                    if (propertyCount.countBTop == 3 && propertyCount.countBLeft == 3) {
                        n = 21;
                        string2 = null;
                        string5 = null;
                    } else if (propertyCount.countBLeft == 3) {
                        n = 16;
                        string5 = null;
                    }
                }
                if (n < 21) {
                    if (propertyCount.countBRight == 3 && propertyCount.countBBottom == 3) {
                        n = 21;
                        string3 = null;
                        string4 = null;
                    } else if (propertyCount.countBRight == 3) {
                        n = 16;
                        string3 = null;
                    }
                }
            }
            if (n >= 0 && n < 20) {
                if (this.equivalentProperties(string2, string3, by)) {
                    if (propertyCount.countBBottom == 3 && propertyCount.countBLeft == 3) {
                        n = 21;
                        string4 = null;
                        string5 = null;
                    } else if (propertyCount.countBTop == 3 && propertyCount.countBRight == 3) {
                        n = 20;
                        string2 = null;
                        string3 = null;
                    } else if (propertyCount.countBLeft == 3) {
                        n = 16;
                        string5 = null;
                    }
                }
                if (n < 21) {
                    if (this.equivalentProperties(string4, string5, by)) {
                        if (propertyCount.countBTop == 3 && propertyCount.countBRight == 3) {
                            n = 21;
                            string2 = null;
                            string3 = null;
                        } else if (n < 20 && propertyCount.countBBottom == 3 && propertyCount.countBLeft == 3) {
                            n = 20;
                            string4 = null;
                            string5 = null;
                        } else if (n < 16 && propertyCount.countBRight == 3) {
                            n = 16;
                            string3 = null;
                        }
                    }
                    if (n < 20) {
                        if (propertyCount.countBTop == 3 && propertyCount.countBRight == 3) {
                            n = 20;
                            string2 = null;
                            string3 = null;
                        } else if (propertyCount.countBBottom == 3 && propertyCount.countBLeft == 3) {
                            n = 20;
                            string4 = null;
                            string5 = null;
                        } else if (n < 16) {
                            if (propertyCount.countBRight == 3) {
                                n = 16;
                                string3 = null;
                            } else if (propertyCount.countBLeft == 3) {
                                n = 16;
                                string5 = null;
                            }
                        }
                    }
                }
            }
        }
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder);
        DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
        boolean bl3 = false;
        stringBuilder.append(string);
        switch (n) {
            case 21: {
                String string7 = string2;
                if (this.isBoxLiveProperty(propertyValueScore, string2, by)) {
                    this.unusedSet.remove(string2);
                }
                if (this.isBoxLiveProperty(propertyValueScore, string4, by) && this.unusedSet.remove(string4)) {
                    string7 = string4;
                }
                if (this.isBoxLiveProperty(propertyValueScore, string5, by) && this.unusedSet.remove(string5)) {
                    string7 = string5;
                }
                if (this.isBoxLiveProperty(propertyValueScore, string3, by) && this.unusedSet.remove(string3)) {
                    string7 = string3;
                }
                if (bl3 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string7, false)) break;
                stringBuilder.append(string6);
                break;
            }
            case 20: {
                String string8 = this.isBoxLiveProperty(propertyValueScore, string2, by) && this.unusedSet.remove(string2) ? string2 : string4;
                bl3 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string8, false);
                if (!bl3) {
                    stringBuilder.append(string6);
                }
                stringBuilder.append(' ');
                String string9 = this.isBoxLiveProperty(propertyValueScore, string5, by) && this.unusedSet.remove(string5) ? string5 : string3;
                bl3 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string9, false);
                if (!bl3) {
                    stringBuilder.append(string6);
                }
                if (this.isBoxLiveProperty(propertyValueScore, string4, by)) {
                    this.unusedSet.remove(string4);
                }
                if (!this.isBoxLiveProperty(propertyValueScore, string3, by)) break;
                this.unusedSet.remove(string3);
                break;
            }
            case 16: 
            case 17: {
                bl3 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string2, false);
                if (!bl3) {
                    stringBuilder.append(string6);
                }
                stringBuilder.append(' ');
                String string10 = this.isBoxLiveProperty(propertyValueScore, string5, by) && this.unusedSet.remove(string5) ? string5 : string3;
                bl3 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string10, false);
                if (!bl3) {
                    stringBuilder.append(string6);
                }
                stringBuilder.append(' ');
                bl3 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string4, false);
                if (!bl3) {
                    stringBuilder.append(string6);
                }
                this.unusedSet.remove(string2);
                this.unusedSet.remove(string4);
                if (!this.isBoxLiveProperty(propertyValueScore, string3, by)) break;
                this.unusedSet.remove(string3);
                break;
            }
            default: {
                bl3 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string2, false);
                if (!bl3) {
                    stringBuilder.append(string6);
                }
                stringBuilder.append(' ');
                bl3 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string3, false);
                if (!bl3) {
                    stringBuilder.append(string6);
                }
                stringBuilder.append(' ');
                bl3 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string4, false);
                if (!bl3) {
                    stringBuilder.append(string6);
                }
                stringBuilder.append(' ');
                bl3 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string5, false);
                if (!bl3) {
                    stringBuilder.append(string6);
                }
                this.unusedSet.remove(string2);
                this.unusedSet.remove(string3);
                this.unusedSet.remove(string4);
                this.unusedSet.remove(string5);
            }
        }
        this.appendPriority(stringBuilder, bl2);
        return true;
    }

    private boolean isBoxLiveProperty(PropertyValueScore propertyValueScore, String string, byte by) {
        return string != null && this.isLiveProperty(string, by);
    }

    private boolean appendBorderTopText(StringBuilder stringBuilder, boolean bl) {
        return this.appendBorderSideText(stringBuilder, "border-top:", "border-top-width", "border-top-style", "border-top-color", this.getTopKeywordState(), bl);
    }

    private boolean appendBorderRightText(StringBuilder stringBuilder, boolean bl) {
        return this.appendBorderSideText(stringBuilder, "border-right:", "border-right-width", "border-right-style", "border-right-color", this.getRightKeywordState(), bl);
    }

    private boolean appendBorderBottomText(StringBuilder stringBuilder, boolean bl) {
        return this.appendBorderSideText(stringBuilder, "border-bottom:", "border-bottom-width", "border-bottom-style", "border-bottom-color", this.getBottomKeywordState(), bl);
    }

    private boolean appendBorderLeftText(StringBuilder stringBuilder, boolean bl) {
        return this.appendBorderSideText(stringBuilder, "border-left:", "border-left-width", "border-left-style", "border-left-color", this.getLeftKeywordState(), bl);
    }

    private boolean appendBorderSideText(StringBuilder stringBuilder, String string, String string2, String string3, String string4, byte by, boolean bl) {
        if (by != -1 && (this.unusedSet.contains(string2) || this.unusedSet.contains(string3) || this.unusedSet.contains(string4))) {
            stringBuilder.append(string);
            if (by == 0) {
                BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder);
                DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
                boolean bl2 = false;
                if (!bl || this.unusedSet.contains(string2)) {
                    bl2 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string2, false);
                }
                if (!bl || this.unusedSet.contains(string3)) {
                    bl2 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string3, bl2);
                }
                if (!bl || this.unusedSet.contains(string4)) {
                    bl2 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string4, bl2);
                }
                if (!bl2) {
                    stringBuilder.append("none");
                }
            } else if (by == 1) {
                stringBuilder.append("inherit");
            } else {
                stringBuilder.append("revert");
            }
            this.unusedSet.remove(string2);
            this.unusedSet.remove(string3);
            this.unusedSet.remove(string4);
            return true;
        }
        return false;
    }

    private byte getTopKeywordState() {
        StyleValue styleValue = this.getCSSValue("border-top-width");
        StyleValue styleValue2 = this.getCSSValue("border-top-style");
        StyleValue styleValue3 = this.getCSSValue("border-top-color");
        return this.getSideKeywordState(styleValue, styleValue2, styleValue3);
    }

    private byte getRightKeywordState() {
        StyleValue styleValue = this.getCSSValue("border-right-width");
        StyleValue styleValue2 = this.getCSSValue("border-right-style");
        StyleValue styleValue3 = this.getCSSValue("border-right-color");
        return this.getSideKeywordState(styleValue, styleValue2, styleValue3);
    }

    private byte getBottomKeywordState() {
        StyleValue styleValue = this.getCSSValue("border-bottom-width");
        StyleValue styleValue2 = this.getCSSValue("border-bottom-style");
        StyleValue styleValue3 = this.getCSSValue("border-bottom-color");
        return this.getSideKeywordState(styleValue, styleValue2, styleValue3);
    }

    private byte getLeftKeywordState() {
        StyleValue styleValue = this.getCSSValue("border-left-width");
        StyleValue styleValue2 = this.getCSSValue("border-left-style");
        StyleValue styleValue3 = this.getCSSValue("border-left-color");
        return this.getSideKeywordState(styleValue, styleValue2, styleValue3);
    }

    private byte getSideKeywordState(StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3) {
        byte by;
        byte by2;
        byte by3 = this.keywordState(styleValue);
        int n = by3 + (by2 = this.keywordState(styleValue2)) + (by = this.keywordState(styleValue3));
        int n2 = n == 0 ? 0 : (n == 3 ? 1 : (n == 15 ? 2 : -1));
        return (byte)n2;
    }

    private boolean isLiveProperty(String string, byte by) {
        return this.isLiveState(this.getCSSValue(string), by);
    }

    private boolean isLiveState(StyleValue styleValue, byte by) {
        return this.keywordState(styleValue) == by;
    }

    private boolean equivalentProperties(String string, String string2, byte by) {
        StyleValue styleValue;
        StyleValue styleValue2 = this.getCSSValue(string);
        return this.valueEquals(styleValue2, styleValue = this.getCSSValue(string2)) || this.keywordState(styleValue2) != by || this.keywordState(styleValue) != by;
    }

    private class PropertyCount {
        int countBTop = 0;
        int countBRight = 0;
        int countBBottom = 0;
        int countBLeft = 0;
        int countBColor = 0;
        int countBStyle = 0;
        int countBWidth = 0;

        PropertyCount() {
        }

        private void count(Set<String> set, boolean bl) {
            BorderBuilder.this.unusedSet.clear();
            BorderBuilder.this.unusedSet.addAll(set);
            if (set.contains("border-top-width")) {
                ++this.countBTop;
                ++this.countBWidth;
            }
            if (set.contains("border-top-style")) {
                ++this.countBTop;
                ++this.countBStyle;
            }
            if (set.contains("border-top-color")) {
                ++this.countBTop;
                ++this.countBColor;
            }
            if (set.contains("border-right-width")) {
                ++this.countBRight;
                ++this.countBWidth;
            }
            if (set.contains("border-right-style")) {
                ++this.countBRight;
                ++this.countBStyle;
            }
            if (set.contains("border-right-color")) {
                ++this.countBRight;
                ++this.countBColor;
            }
            if (set.contains("border-bottom-width")) {
                ++this.countBBottom;
                ++this.countBWidth;
            }
            if (set.contains("border-bottom-style")) {
                ++this.countBBottom;
                ++this.countBStyle;
            }
            if (set.contains("border-bottom-color")) {
                ++this.countBBottom;
                ++this.countBColor;
            }
            if (set.contains("border-left-width")) {
                ++this.countBLeft;
                ++this.countBWidth;
            }
            if (set.contains("border-left-style")) {
                ++this.countBLeft;
                ++this.countBStyle;
            }
            if (set.contains("border-left-color")) {
                ++this.countBLeft;
                ++this.countBColor;
            }
            if (!bl) {
                BaseCSSStyleDeclaration baseCSSStyleDeclaration = BorderBuilder.this.getParentStyle();
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-top-width")) {
                    ++this.countBTop;
                    if (this.countBWidth != 0) {
                        ++this.countBWidth;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-top-style")) {
                    ++this.countBTop;
                    if (this.countBStyle != 0) {
                        ++this.countBStyle;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-top-color")) {
                    ++this.countBTop;
                    if (this.countBColor != 0) {
                        ++this.countBColor;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-right-width")) {
                    ++this.countBRight;
                    if (this.countBWidth != 0) {
                        ++this.countBWidth;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-right-style")) {
                    ++this.countBRight;
                    if (this.countBStyle != 0) {
                        ++this.countBStyle;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-right-color")) {
                    ++this.countBRight;
                    if (this.countBColor != 0) {
                        ++this.countBColor;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-bottom-width")) {
                    ++this.countBBottom;
                    if (this.countBWidth != 0) {
                        ++this.countBWidth;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-bottom-style")) {
                    ++this.countBBottom;
                    if (this.countBStyle != 0) {
                        ++this.countBStyle;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-bottom-color")) {
                    ++this.countBBottom;
                    if (this.countBColor != 0) {
                        ++this.countBColor;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-left-width")) {
                    ++this.countBLeft;
                    if (this.countBWidth != 0) {
                        ++this.countBWidth;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-left-style")) {
                    ++this.countBLeft;
                    if (this.countBStyle != 0) {
                        ++this.countBStyle;
                    }
                }
                if (this.isShadowed(baseCSSStyleDeclaration, set, "border-left-color")) {
                    ++this.countBLeft;
                    if (this.countBColor != 0) {
                        ++this.countBColor;
                    }
                }
            }
        }

        private boolean isShadowed(BaseCSSStyleDeclaration baseCSSStyleDeclaration, Set<String> set, String string) {
            return !set.contains(string) && baseCSSStyleDeclaration.isPropertySet(string);
        }
    }

    private class PropertyValueScore {
        final Set<String> declaredSet;
        final ShorthandPropertyState widthState = new ShorthandPropertyState();
        final ShorthandPropertyState styleState = new ShorthandPropertyState();
        final ShorthandPropertyState colorState = new ShorthandPropertyState();

        PropertyValueScore(Set<String> set) {
            this.declaredSet = set;
        }

        public ShorthandPropertyState getWidthState() {
            return this.widthState;
        }

        public ShorthandPropertyState getStyleState() {
            return this.styleState;
        }

        public ShorthandPropertyState getColorState() {
            return this.colorState;
        }

        public int getSameWidthScore() {
            return this.widthState.score;
        }

        public int getSameStyleScore() {
            return this.styleState.score;
        }

        public int getSameColorScore() {
            return this.colorState.score;
        }

        private void score() {
            this.widthState.sameValueScore("border-top-width", "border-right-width", "border-bottom-width", "border-left-width");
            this.styleState.sameValueScore("border-top-style", "border-right-style", "border-bottom-style", "border-left-style");
            this.colorState.sameValueScore("border-top-color", "border-right-color", "border-bottom-color", "border-left-color");
        }

        public void score(PropertyCount propertyCount) {
            if (propertyCount.countBWidth == 4) {
                this.widthState.sameValueScore("border-top-width", "border-right-width", "border-bottom-width", "border-left-width");
            }
            if (propertyCount.countBStyle == 4) {
                this.styleState.sameValueScore("border-top-style", "border-right-style", "border-bottom-style", "border-left-style");
            }
            if (propertyCount.countBColor == 4) {
                this.colorState.sameValueScore("border-top-color", "border-right-color", "border-bottom-color", "border-left-color");
            }
        }

        boolean hasMixedStates() {
            return this.getSameWidthScore() == -1 || this.getSameStyleScore() == -1 || this.getSameColorScore() == -1;
        }

        private int getScore(byte by) {
            int n = 0;
            if (!this.hasMixedStates()) {
                n = 0;
                if (this.widthState.keyword_state == by) {
                    n += this.getSameWidthScore();
                }
                if (this.styleState.keyword_state == by) {
                    n += this.getSameStyleScore();
                }
                if (this.colorState.keyword_state == by) {
                    n += this.getSameColorScore();
                }
            } else {
                n = -1;
            }
            return n;
        }

        private void setEquivalentScores() {
            this.widthState.equivalentValueScore("border-top-width", "border-right-width", "border-bottom-width", "border-left-width");
            this.styleState.equivalentValueScore("border-top-style", "border-right-style", "border-bottom-style", "border-left-style");
            this.colorState.equivalentValueScore("border-top-color", "border-right-color", "border-bottom-color", "border-left-color");
        }

        private Set<String> getEquivWidthSet(int n) {
            HashSet<String> hashSet = new HashSet<String>();
            switch (n) {
                case 21: {
                    hashSet.add("border-top-width");
                    hashSet.add("border-right-width");
                    hashSet.add("border-left-width");
                    hashSet.add("border-bottom-width");
                    break;
                }
                case 17: {
                    hashSet.add("border-top-width");
                    hashSet.add("border-right-width");
                    hashSet.add("border-left-width");
                    break;
                }
                case 16: {
                    hashSet.add("border-right-width");
                    hashSet.add("border-left-width");
                    break;
                }
                case 15: {
                    hashSet.add("border-right-width");
                    hashSet.add("border-left-width");
                    hashSet.add("border-bottom-width");
                    break;
                }
                case 5: {
                    hashSet.add("border-left-width");
                    hashSet.add("border-top-width");
                    hashSet.add("border-bottom-width");
                    break;
                }
                case 4: {
                    hashSet.add("border-top-width");
                    hashSet.add("border-bottom-width");
                    break;
                }
                case 3: {
                    hashSet.add("border-top-width");
                    hashSet.add("border-right-width");
                    hashSet.add("border-bottom-width");
                    break;
                }
                case 1: {
                    hashSet.add("border-top-width");
                    hashSet.add("border-left-width");
                }
            }
            return hashSet;
        }

        private Set<String> getEquivStyleSet(int n) {
            HashSet<String> hashSet = new HashSet<String>();
            switch (n) {
                case 21: {
                    hashSet.add("border-top-style");
                    hashSet.add("border-right-style");
                    hashSet.add("border-left-style");
                    hashSet.add("border-bottom-style");
                    break;
                }
                case 17: {
                    hashSet.add("border-top-style");
                    hashSet.add("border-right-style");
                    hashSet.add("border-left-style");
                    break;
                }
                case 16: {
                    hashSet.add("border-right-style");
                    hashSet.add("border-left-style");
                    break;
                }
                case 15: {
                    hashSet.add("border-right-style");
                    hashSet.add("border-left-style");
                    hashSet.add("border-bottom-style");
                    break;
                }
                case 5: {
                    hashSet.add("border-left-style");
                    hashSet.add("border-top-style");
                    hashSet.add("border-bottom-style");
                    break;
                }
                case 4: {
                    hashSet.add("border-top-style");
                    hashSet.add("border-bottom-style");
                    break;
                }
                case 3: {
                    hashSet.add("border-top-style");
                    hashSet.add("border-right-style");
                    hashSet.add("border-bottom-style");
                    break;
                }
                case 1: {
                    hashSet.add("border-top-style");
                    hashSet.add("border-left-style");
                }
            }
            return hashSet;
        }

        private Set<String> getEquivColorSet(int n) {
            HashSet<String> hashSet = new HashSet<String>();
            switch (n) {
                case 21: {
                    hashSet.add("border-top-color");
                    hashSet.add("border-right-color");
                    hashSet.add("border-left-color");
                    hashSet.add("border-bottom-color");
                    break;
                }
                case 17: {
                    hashSet.add("border-top-color");
                    hashSet.add("border-right-color");
                    hashSet.add("border-left-color");
                    break;
                }
                case 16: {
                    hashSet.add("border-right-color");
                    hashSet.add("border-left-color");
                    break;
                }
                case 15: {
                    hashSet.add("border-right-color");
                    hashSet.add("border-left-color");
                    hashSet.add("border-bottom-color");
                    break;
                }
                case 5: {
                    hashSet.add("border-left-color");
                    hashSet.add("border-top-color");
                    hashSet.add("border-bottom-color");
                    break;
                }
                case 4: {
                    hashSet.add("border-top-color");
                    hashSet.add("border-bottom-color");
                    break;
                }
                case 3: {
                    hashSet.add("border-top-color");
                    hashSet.add("border-right-color");
                    hashSet.add("border-bottom-color");
                    break;
                }
                case 1: {
                    hashSet.add("border-top-color");
                    hashSet.add("border-left-color");
                }
            }
            return hashSet;
        }

        private class ShorthandPropertyState {
            private int score = 0;
            private int keyword_state = 0;
            private byte best_state = 0;

            byte getBestState() {
                return this.best_state;
            }

            ShorthandPropertyState() {
            }

            private int sameValueScore(String string, String string2, String string3, String string4) {
                StyleValue styleValue = BorderBuilder.this.getCSSValue(string);
                StyleValue styleValue2 = BorderBuilder.this.getCSSValue(string3);
                StyleValue styleValue3 = BorderBuilder.this.getCSSValue(string4);
                StyleValue styleValue4 = BorderBuilder.this.getCSSValue(string2);
                byte by = BorderBuilder.this.keywordState(styleValue);
                byte by2 = BorderBuilder.this.keywordState(styleValue2);
                byte by3 = BorderBuilder.this.keywordState(styleValue3);
                byte by4 = BorderBuilder.this.keywordState(styleValue4);
                this.score = 0;
                if (BorderBuilder.this.valueEquals(styleValue3, styleValue4) || !PropertyValueScore.this.declaredSet.contains(string4) && !PropertyValueScore.this.declaredSet.contains(string2)) {
                    this.score = 16;
                }
                if (BorderBuilder.this.valueEquals(styleValue, styleValue2) || !PropertyValueScore.this.declaredSet.contains(string) && !PropertyValueScore.this.declaredSet.contains(string3)) {
                    this.score += 4;
                }
                if (BorderBuilder.this.valueEquals(styleValue, styleValue3) || !PropertyValueScore.this.declaredSet.contains(string) && !PropertyValueScore.this.declaredSet.contains(string4)) {
                    ++this.score;
                } else if (!PropertyValueScore.this.declaredSet.contains(string4) && this.score == 16) {
                    ++this.score;
                } else if (!(PropertyValueScore.this.declaredSet.contains(string) || this.score != 20 && this.score != 4)) {
                    ++this.score;
                }
                this.keyword_state = by + by2 + by3 + by4;
                if (this.keyword_state != 0 && this.keyword_state != 4 && this.keyword_state != 20) {
                    this.score = -1;
                } else {
                    this.best_state = (byte)(this.keyword_state / 4);
                }
                return this.score;
            }

            private int equivalentValueScore(String string, String string2, String string3, String string4) {
                StyleValue styleValue = BorderBuilder.this.getCSSValue(string);
                StyleValue styleValue2 = BorderBuilder.this.getCSSValue(string3);
                StyleValue styleValue3 = BorderBuilder.this.getCSSValue(string4);
                StyleValue styleValue4 = BorderBuilder.this.getCSSValue(string2);
                byte by = BorderBuilder.this.keywordState(styleValue);
                byte by2 = BorderBuilder.this.keywordState(styleValue2);
                byte by3 = BorderBuilder.this.keywordState(styleValue3);
                byte by4 = BorderBuilder.this.keywordState(styleValue4);
                this.keyword_state = by + by2 + by3 + by4;
                this.best_state = 0;
                int n = this.keyword_state % 5;
                if (n == 3 || n == 4) {
                    this.best_state = 1;
                } else if (this.keyword_state > 10) {
                    this.best_state = (byte)5;
                }
                this.score = 0;
                if (BorderBuilder.this.valueEquals(styleValue3, styleValue4) || by3 != this.best_state || by4 != this.best_state) {
                    this.score += 16;
                }
                if (BorderBuilder.this.valueEquals(styleValue, styleValue2) || by != this.best_state || by2 != this.best_state) {
                    this.score += 4;
                }
                if (BorderBuilder.this.valueEquals(styleValue, styleValue3) || by != this.best_state || by3 != this.best_state) {
                    ++this.score;
                }
                return this.score;
            }
        }
    }
}

