/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeInt16Array
extends NativeTypedArrayView<Short> {
    private static final long serialVersionUID = -8592870435287581398L;
    private static final String CLASS_NAME = "Int16Array";
    private static final int BYTES_PER_ELEMENT = 2;

    public NativeInt16Array() {
    }

    public NativeInt16Array(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        super(nativeArrayBuffer, n, n2, n2 * 2);
    }

    public NativeInt16Array(int n) {
        this(new NativeArrayBuffer((double)n * 2.0), 0, n);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeInt16Array nativeInt16Array = new NativeInt16Array();
        IdFunctionObject idFunctionObject = nativeInt16Array.exportAsJSClass(7, scriptable, bl);
        ScriptRuntimeES6.addSymbolSpecies(context, scriptable, idFunctionObject);
    }

    protected NativeInt16Array construct(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        return new NativeInt16Array(nativeArrayBuffer, n, n2);
    }

    @Override
    public int getBytesPerElement() {
        return 2;
    }

    protected NativeInt16Array realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        return NativeInt16Array.ensureType(scriptable, NativeInt16Array.class, idFunctionObject);
    }

    @Override
    protected Object js_get(int n) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        return ByteIo.readInt16(this.arrayBuffer.buffer, n * 2 + this.offset, NativeInt16Array.useLittleEndian());
    }

    @Override
    protected Object js_set(int n, Object object) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        int n2 = Conversions.toInt16(object);
        ByteIo.writeInt16(this.arrayBuffer.buffer, n * 2 + this.offset, n2, NativeInt16Array.useLittleEndian());
        return null;
    }

    @Override
    public Short get(int n) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return (Short)this.js_get(n);
    }

    @Override
    public Short set(int n, Short s) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return (Short)this.js_set(n, s);
    }
}

