/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.rendered;

import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;

public class MultiplyAlphaRed
extends AbstractRed {
    public MultiplyAlphaRed(CachableRed cachableRed, CachableRed cachableRed2) {
        super(MultiplyAlphaRed.makeList(cachableRed, cachableRed2), MultiplyAlphaRed.makeBounds(cachableRed, cachableRed2), MultiplyAlphaRed.fixColorModel(cachableRed), MultiplyAlphaRed.fixSampleModel(cachableRed), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    public boolean is_INT_PACK_BYTE_COMP(SampleModel sampleModel, SampleModel sampleModel2) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (!(sampleModel2 instanceof ComponentSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        if (sampleModel2.getDataType() != 0) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        if (nArray[3] != -16777216) {
            return false;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel2;
        if (componentSampleModel.getNumBands() != 1) {
            return false;
        }
        return componentSampleModel.getPixelStride() == 1;
    }

    public WritableRaster INT_PACK_BYTE_COMP_Impl(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        CachableRed cachableRed2 = (CachableRed)this.getSources().get(1);
        cachableRed.copyData(writableRaster);
        Rectangle rectangle = writableRaster.getBounds();
        rectangle = rectangle.intersection(cachableRed2.getBounds());
        Raster raster = cachableRed2.getData(rectangle);
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = componentSampleModel.getScanlineStride();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n2 = dataBufferByte.getOffset() + componentSampleModel.getOffset(rectangle.x - raster.getSampleModelTranslateX(), rectangle.y - raster.getSampleModelTranslateY());
        byte[] byArray = dataBufferByte.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n3 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n4 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(rectangle.x - writableRaster.getSampleModelTranslateX(), rectangle.y - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.isAlphaPremultiplied()) {
            for (int i = 0; i < rectangle.height; ++i) {
                int n5;
                int n6 = n2 + i * n;
                int n7 = n5 + rectangle.width;
                for (n5 = n4 + i * n3; n5 < n7; ++n5) {
                    int n8 = byArray[n6++] & 0xFF;
                    int n9 = nArray[n5];
                    nArray[n5] = ((n9 >>> 24) * n8 & 0xFF00) << 16 | ((n9 >>> 16 & 0xFF) * n8 & 0xFF00) << 8 | (n9 >>> 8 & 0xFF) * n8 & 0xFF00 | ((n9 & 0xFF) * n8 & 0xFF00) >> 8;
                }
            }
        } else {
            for (int i = 0; i < rectangle.height; ++i) {
                int n10;
                int n11 = n2 + i * n;
                int n12 = n10 + rectangle.width;
                for (n10 = n4 + i * n3; n10 < n12; ++n10) {
                    int n13 = byArray[n11++] & 0xFF;
                    int n14 = nArray[n10] >>> 24;
                    nArray[n10] = (n14 * n13 & 0xFF00) << 16 | nArray[n10] & 0xFFFFFF;
                }
            }
        }
        return writableRaster;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        CachableRed cachableRed2 = (CachableRed)this.getSources().get(1);
        if (this.is_INT_PACK_BYTE_COMP(cachableRed.getSampleModel(), cachableRed2.getSampleModel())) {
            return this.INT_PACK_BYTE_COMP_Impl(writableRaster);
        }
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.hasAlpha()) {
            cachableRed.copyData(writableRaster);
            Rectangle rectangle = writableRaster.getBounds();
            if (!rectangle.intersects(cachableRed2.getBounds())) {
                return writableRaster;
            }
            rectangle = rectangle.intersection(cachableRed2.getBounds());
            int[] nArray = null;
            int[] nArray2 = null;
            Raster raster = cachableRed2.getData(rectangle);
            int n = rectangle.width;
            int n2 = writableRaster.getSampleModel().getNumBands();
            if (colorModel.isAlphaPremultiplied()) {
                for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
                    nArray = writableRaster.getPixels(rectangle.x, i, n, 1, nArray);
                    nArray2 = raster.getSamples(rectangle.x, i, n, 1, 0, nArray2);
                    int n3 = 0;
                    switch (n2) {
                        case 2: {
                            int n4;
                            for (int n5 : nArray2) {
                                n4 = n5 & 0xFF;
                                nArray[n3] = (nArray[n3] & 0xFF) * n4 >> 8;
                                nArray[++n3] = (nArray[n3] & 0xFF) * n4 >> 8;
                                ++n3;
                            }
                            break;
                        }
                        case 4: {
                            int n4;
                            for (int n5 : nArray2) {
                                n4 = n5 & 0xFF;
                                nArray[n3] = (nArray[n3] & 0xFF) * n4 >> 8;
                                nArray[++n3] = (nArray[n3] & 0xFF) * n4 >> 8;
                                nArray[++n3] = (nArray[n3] & 0xFF) * n4 >> 8;
                                nArray[++n3] = (nArray[n3] & 0xFF) * n4 >> 8;
                                ++n3;
                            }
                            break;
                        }
                        default: {
                            int n4;
                            for (int n5 : nArray2) {
                                n4 = n5 & 0xFF;
                                for (int j = 0; j < n2; ++j) {
                                    nArray[n3] = (nArray[n3] & 0xFF) * n4 >> 8;
                                    ++n3;
                                }
                            }
                        }
                    }
                    writableRaster.setPixels(rectangle.x, i, n, 1, nArray);
                }
            } else {
                int n6 = cachableRed.getSampleModel().getNumBands() - 1;
                for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
                    nArray = writableRaster.getSamples(rectangle.x, i, n, 1, n6, nArray);
                    nArray2 = raster.getSamples(rectangle.x, i, n, 1, 0, nArray2);
                    for (int j = 0; j < nArray.length; ++j) {
                        nArray[j] = (nArray[j] & 0xFF) * (nArray2[j] & 0xFF) >> 8;
                    }
                    writableRaster.setSamples(rectangle.x, i, n, 1, n6, nArray);
                }
            }
            return writableRaster;
        }
        int[] nArray = new int[writableRaster.getNumBands() - 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        WritableRaster writableRaster2 = writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), nArray);
        cachableRed.copyData(writableRaster2);
        Rectangle rectangle = writableRaster.getBounds();
        rectangle = rectangle.intersection(cachableRed2.getBounds());
        nArray = new int[]{writableRaster.getNumBands() - 1};
        writableRaster2 = writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, nArray);
        cachableRed2.copyData(writableRaster2);
        return writableRaster;
    }

    public static List<CachableRed> makeList(CachableRed cachableRed, CachableRed cachableRed2) {
        ArrayList<CachableRed> arrayList = new ArrayList<CachableRed>(2);
        arrayList.add(cachableRed);
        arrayList.add(cachableRed2);
        return arrayList;
    }

    public static Rectangle makeBounds(CachableRed cachableRed, CachableRed cachableRed2) {
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = cachableRed2.getBounds();
        return rectangle.intersection(rectangle2);
    }

    public static SampleModel fixSampleModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        SampleModel sampleModel = cachableRed.getSampleModel();
        if (colorModel.hasAlpha()) {
            return sampleModel;
        }
        int n = sampleModel.getWidth();
        int n2 = sampleModel.getHeight();
        int n3 = sampleModel.getNumBands() + 1;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = i;
        }
        return new PixelInterleavedSampleModel(0, n, n2, n3, n * n3, nArray);
    }

    public static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.hasAlpha()) {
            return colorModel;
        }
        int n = cachableRed.getSampleModel().getNumBands() + 1;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 8;
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        return new ComponentColorModel(colorSpace, nArray, true, false, 3, 0);
    }
}

